package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.GameScoreRank;
import com.ptteng.learn.course.service.GameScoreRankService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class GameScoreRankServiceImpl extends BaseDaoServiceImpl implements GameScoreRankService {

 

	private static final Log log = LogFactory.getLog(GameScoreRankServiceImpl.class);



		   
		@Override
		public Long insert(GameScoreRank gameScoreRank)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + gameScoreRank);

		if (gameScoreRank == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		gameScoreRank.setCreateAt(currentTimeMillis);
		gameScoreRank.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(gameScoreRank);
		} catch (DaoException e) {
			log.error(" insert wrong : " + gameScoreRank);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<GameScoreRank> insertList(List<GameScoreRank> gameScoreRankList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (gameScoreRankList == null ? "null" : gameScoreRankList.size()));
      
		List<GameScoreRank> resultList = null;

		if (CollectionUtils.isEmpty(gameScoreRankList)) {
			return new ArrayList<GameScoreRank>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (GameScoreRank gameScoreRank : gameScoreRankList) {
			gameScoreRank.setCreateAt(currentTimeMillis);
			gameScoreRank.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<GameScoreRank>) dao.batchSave(gameScoreRankList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + gameScoreRankList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(GameScoreRank.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(GameScoreRank gameScoreRank)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (gameScoreRank == null ? "null" : gameScoreRank.getId()));

		boolean result = false;

		if (gameScoreRank == null) {
			return true;
		}

		gameScoreRank.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(gameScoreRank);
		} catch (DaoException e) {
			log.error(" update wrong : " + gameScoreRank);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + gameScoreRank);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<GameScoreRank> gameScoreRankList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (gameScoreRankList == null ? "null" : gameScoreRankList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(gameScoreRankList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (GameScoreRank gameScoreRank : gameScoreRankList) {
			gameScoreRank.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(gameScoreRankList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + gameScoreRankList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + gameScoreRankList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public GameScoreRank getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		GameScoreRank gameScoreRank = null;

		if (id == null) {
			return gameScoreRank;
		}

		try {
			gameScoreRank = (GameScoreRank) dao.get(GameScoreRank.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return gameScoreRank;		
		}	
		  
    	   
		@Override
		public List<GameScoreRank> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<GameScoreRank> gameScoreRank = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<GameScoreRank>();
		}

		try {
			gameScoreRank = (List<GameScoreRank>) dao.getList(GameScoreRank.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (gameScoreRank == null ? "null" : gameScoreRank.size()));
    
		return gameScoreRank;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getGameScoreRankIdsByUserIdOrderByCreateAt(Long userId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by userId,start,limit  : " + userId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getGameScoreRankIdsByUserIdOrderByCreateAt", new Object[] { userId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by userId,start,limit)  : " + userId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(Long stasticsAt,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by stasticsAt,start,limit  : " + stasticsAt+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt", new Object[] { stasticsAt},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by stasticsAt,start,limit)  : " + stasticsAt+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGameScoreRankIdsByUserIdOrderByCreateAt(Long userId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by userId  : " + userId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getGameScoreRankIdsByUserIdOrderByCreateAt", new Object[] { userId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by userId)  : " + userId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(Long stasticsAt)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by stasticsAt  : " + stasticsAt );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt", new Object[] { stasticsAt});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by stasticsAt)  : " + stasticsAt );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getGameScoreRankIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getGameScoreRankIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
//	@Override
//	public List<Long> getWeekGameScoreRankByUserIdOrderByGameScore(Long stasticsAt, Integer start, Integer limit)
//			throws ServiceException, ServiceDaoException {
//
//		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
//		List<Long> idList = null;
//
//
//
//		if (start == null) {
//			start = 0;
//		}
//
//		if (limit == null) {
//			limit = Integer.MAX_VALUE;
//		}
//
//		try {
//			idList = dao.getIdList("getWeekGameScoreRankByUserIdOrderByGameScore",new Object[] {stasticsAt},start, limit, false);
//		} catch (DaoException e) {
//			log.error(" get ids  wrong by start,limit)  : " +stasticsAt+","+ start + " , " + limit);
//			log.error(e);
//			e.printStackTrace();
//			throw new ServiceDaoException(e);
//		}
//		if (log.isInfoEnabled()) {
//			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
//		}
//		return idList;
//	}


		@Override
	public Integer countGameScoreRankIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getGameScoreRankIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getGameScoreRankIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

