/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.DictationSubject;
import com.ptteng.learn.course.service.DictationSubjectService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DictationSubjectServiceImpl
extends BaseDaoServiceImpl
implements DictationSubjectService {
    private static final Log log = LogFactory.getLog(DictationSubjectServiceImpl.class);

    public Long insert(DictationSubject dictationSubject) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + dictationSubject));
        if (dictationSubject == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        dictationSubject.setCreateAt(Long.valueOf(currentTimeMillis));
        dictationSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)dictationSubject);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + dictationSubject));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<DictationSubject> insertList(List<DictationSubject> dictationSubjectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (dictationSubjectList == null ? "null" : Integer.valueOf(dictationSubjectList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(dictationSubjectList)) {
            return new ArrayList<DictationSubject>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DictationSubject dictationSubject : dictationSubjectList) {
            dictationSubject.setCreateAt(Long.valueOf(currentTimeMillis));
            dictationSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(dictationSubjectList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + dictationSubjectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(DictationSubject.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(DictationSubject dictationSubject) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (dictationSubject == null ? "null" : dictationSubject.getId())));
        boolean result = false;
        if (dictationSubject == null) {
            return true;
        }
        dictationSubject.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)dictationSubject);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + dictationSubject));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + dictationSubject));
        }
        return result;
    }

    public boolean updateList(List<DictationSubject> dictationSubjectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (dictationSubjectList == null ? "null" : Integer.valueOf(dictationSubjectList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(dictationSubjectList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DictationSubject dictationSubject : dictationSubjectList) {
            dictationSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(dictationSubjectList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + dictationSubjectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + dictationSubjectList.size()));
        return result;
    }

    public DictationSubject getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        DictationSubject dictationSubject = null;
        if (id == null) {
            return dictationSubject;
        }
        try {
            dictationSubject = (DictationSubject)this.dao.get(DictationSubject.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return dictationSubject;
    }

    public List<DictationSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List dictationSubject = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationSubject>();
        }
        try {
            dictationSubject = this.dao.getList(DictationSubject.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (dictationSubject == null ? "null" : Integer.valueOf(dictationSubject.size()))));
        return dictationSubject;
    }

    public List<Long> getIdsOnline(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get online ids by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIdsOnline", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getDictationSubjectIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getDictationSubjectIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDictationSubjectIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDictationSubjectIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDictationSubjectIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDictationSubjectIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

