package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.UserDlessonRelation;
import com.ptteng.learn.course.service.UserDlessonRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserDlessonRelationServiceImpl extends BaseDaoServiceImpl implements UserDlessonRelationService {

 

	private static final Log log = LogFactory.getLog(UserDlessonRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserDlessonRelation userDlessonRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userDlessonRelation);

		if (userDlessonRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userDlessonRelation.setCreateAt(currentTimeMillis);
		userDlessonRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userDlessonRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userDlessonRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserDlessonRelation> insertList(List<UserDlessonRelation> userDlessonRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userDlessonRelationList == null ? "null" : userDlessonRelationList.size()));
      
		List<UserDlessonRelation> resultList = null;

		if (CollectionUtils.isEmpty(userDlessonRelationList)) {
			return new ArrayList<UserDlessonRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserDlessonRelation userDlessonRelation : userDlessonRelationList) {
			userDlessonRelation.setCreateAt(currentTimeMillis);
			userDlessonRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserDlessonRelation>) dao.batchSave(userDlessonRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userDlessonRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserDlessonRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserDlessonRelation userDlessonRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userDlessonRelation == null ? "null" : userDlessonRelation.getId()));

		boolean result = false;

		if (userDlessonRelation == null) {
			return true;
		}

		userDlessonRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userDlessonRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userDlessonRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userDlessonRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserDlessonRelation> userDlessonRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userDlessonRelationList == null ? "null" : userDlessonRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userDlessonRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserDlessonRelation userDlessonRelation : userDlessonRelationList) {
			userDlessonRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userDlessonRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userDlessonRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userDlessonRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserDlessonRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserDlessonRelation userDlessonRelation = null;

		if (id == null) {
			return userDlessonRelation;
		}

		try {
			userDlessonRelation = (UserDlessonRelation) dao.get(UserDlessonRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userDlessonRelation;		
		}	
		  
    	   
		@Override
		public List<UserDlessonRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserDlessonRelation> userDlessonRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserDlessonRelation>();
		}

		try {
			userDlessonRelation = (List<UserDlessonRelation>) dao.getList(UserDlessonRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userDlessonRelation == null ? "null" : userDlessonRelation.size()));
    
		return userDlessonRelation;	
		}

	@Override
	public List<Long> getIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get ids by uid,start,limit : " + uid + " , " + start + " , " + limit);
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getIdsByUid", new Object[]{uid}, start, limit, false);


		} catch (DaoException e) {
			log.error(" get ids wrong by uid,start,limit : " + uid + " , " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public Integer countIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getIdsByUid",new Object[] {uid});
		} catch (DaoException e) {
			log.error(" count by uid " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	@Override
	public Long getIdsByUserIdAndLessonId(Long userId, Long lessonId) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get id by userId,lessonId : " + userId + " , " + lessonId );
		}
		Long id = null;

		try {
			id = (Long)dao.getMapping("getIdsByUserIdAndLessonId", new Object[] { userId,lessonId});


		} catch (DaoException e) {
			log.error(" get ids  wrong by userId,lessonId : " + userId + " , " + lessonId);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + id);
		}
		return id;
	}


	@Override
	public List<Long> getUserDlessonRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserDlessonRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserDlessonRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserDlessonRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserDlessonRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

