package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.DictationLesson;
import com.ptteng.learn.course.service.DictationLessonService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DictationLessonServiceImpl extends BaseDaoServiceImpl implements DictationLessonService {


    private static final Log log = LogFactory.getLog(DictationLessonServiceImpl.class);


    @Override
    public Long insert(DictationLesson dictationLesson) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + dictationLesson);

        if (dictationLesson == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        dictationLesson.setCreateAt(currentTimeMillis);
        dictationLesson.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(dictationLesson);
        } catch (DaoException e) {
            log.error(" insert wrong : " + dictationLesson);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DictationLesson> insertList(List<DictationLesson> dictationLessonList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (dictationLessonList == null ? "null" : dictationLessonList.size()));

        List<DictationLesson> resultList = null;

        if (CollectionUtils.isEmpty(dictationLessonList)) {
            return new ArrayList<DictationLesson>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationLesson dictationLesson : dictationLessonList) {
            dictationLesson.setCreateAt(currentTimeMillis);
            dictationLesson.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DictationLesson>) dao.batchSave(dictationLessonList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + dictationLessonList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DictationLesson.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DictationLesson dictationLesson) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (dictationLesson == null ? "null" : dictationLesson.getId()));

        boolean result = false;

        if (dictationLesson == null) {
            return true;
        }

        dictationLesson.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(dictationLesson);
        } catch (DaoException e) {
            log.error(" update wrong : " + dictationLesson);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + dictationLesson);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DictationLesson> dictationLessonList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (dictationLessonList == null ? "null" : dictationLessonList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(dictationLessonList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationLesson dictationLesson : dictationLessonList) {
            dictationLesson.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(dictationLessonList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + dictationLessonList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + dictationLessonList.size());

        return result;
    }


    @Override
    public DictationLesson getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DictationLesson dictationLesson = null;

        if (id == null) {
            return dictationLesson;
        }

        try {
            dictationLesson = (DictationLesson) dao.get(DictationLesson.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return dictationLesson;
    }


    @Override
    public List<DictationLesson> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DictationLesson> dictationLesson = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationLesson>();
        }

        try {
            dictationLesson = (List<DictationLesson>) dao.getList(DictationLesson.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (dictationLesson == null ? "null" : dictationLesson.size()));

        return dictationLesson;
    }

    @Override
    public List<Long> getLessonListBySidAndLid(Long sid, Long lid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by sid,lid,start,limit : " + sid + " , " + lid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonListBySidAndLid", new Object[]{sid, lid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids wrong by sid,lid,start,limit : " + sid + " , " + lid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Integer countLessonListBySidAndLid(Long sid, Long lid) throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getLessonListBySidAndLid", new Object[]{sid, lid});
        } catch (DaoException e) {
            log.error(" count by sid and lid ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getLessonListBySidAndLidAndStatus(Long sid, Long lid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by sid,lid,status,start,limit : " + sid + " , " + lid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonListBySidAndLidAndStatus", new Object[]{sid, lid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids wrong by sid,lid,status,start,limit : " + sid + " , " + lid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Integer countLessonListBySidAndLidAndStatus(Long sid, Long lid, Integer status) throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getLessonListBySidAndLidAndStatus", new Object[]{sid, lid, status});
        } catch (DaoException e) {
            log.error(" count by sid and lid and status ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getLessonListBySid(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by sid,start,limit : " + sid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonListBySid", new Object[]{sid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids wrong by sid,start,limit : " + sid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getLessonListBySidAndStatus(Long sid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by sid,status,start,limit : " + sid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonListBySidAndStatus", new Object[]{sid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids wrong by sid,status,start,limit : " + sid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getDictationLessonIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDictationLessonIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDictationLessonIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDictationLessonIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDictationLessonIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

