package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.learn.course.model.BookVersion;
import com.ptteng.learn.course.service.BookVersionService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class BookVersionServiceImpl extends BaseDaoServiceImpl implements BookVersionService {

 

	private static final Log log = LogFactory.getLog(BookVersionServiceImpl.class);



		   
		@Override
		public Long insert(BookVersion bookVersion)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + bookVersion);

		if (bookVersion == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		bookVersion.setCreateAt(currentTimeMillis);
		bookVersion.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(bookVersion);
		} catch (DaoException e) {
			log.error(" insert wrong : " + bookVersion);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<BookVersion> insertList(List<BookVersion> bookVersionList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (bookVersionList == null ? "null" : bookVersionList.size()));
      
		List<BookVersion> resultList = null;

		if (CollectionUtils.isEmpty(bookVersionList)) {
			return new ArrayList<BookVersion>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BookVersion bookVersion : bookVersionList) {
			bookVersion.setCreateAt(currentTimeMillis);
			bookVersion.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<BookVersion>) dao.batchSave(bookVersionList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + bookVersionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(BookVersion.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(BookVersion bookVersion)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (bookVersion == null ? "null" : bookVersion.getId()));

		boolean result = false;

		if (bookVersion == null) {
			return true;
		}

		bookVersion.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(bookVersion);
		} catch (DaoException e) {
			log.error(" update wrong : " + bookVersion);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + bookVersion);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<BookVersion> bookVersionList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (bookVersionList == null ? "null" : bookVersionList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(bookVersionList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BookVersion bookVersion : bookVersionList) {
			bookVersion.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(bookVersionList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + bookVersionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + bookVersionList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public BookVersion getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		BookVersion bookVersion = null;

		if (id == null) {
			return bookVersion;
		}

		try {
			bookVersion = (BookVersion) dao.get(BookVersion.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return bookVersion;		
		}	
		  
    	   
		@Override
		public List<BookVersion> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<BookVersion> bookVersion = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<BookVersion>();
		}

		try {
			bookVersion = (List<BookVersion>) dao.getList(BookVersion.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (bookVersion == null ? "null" : bookVersion.size()));
    
		return bookVersion;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getBookVersionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getBookVersionIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countBookVersionIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBookVersionIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBookVersionIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	@Override
	public Long getIdByName(String name) throws ServiceException, ServiceDaoException{
		if (log.isInfoEnabled()) {
			log.info(" get id by name  : " + name);
		}
		Long id = null;

		// TODO 参数检查!

		try {

			id = (Long) dao.getMapping("getIdByName", new Object[]{name});

		} catch (DaoException e) {
			log.error(" get id wrong by name  : " + name);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}

}

