/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.OrderStatistics;
import com.ptteng.learn.course.service.OrderStatisticsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderStatisticsServiceImpl
extends BaseDaoServiceImpl
implements OrderStatisticsService {
    private static final Log log = LogFactory.getLog(OrderStatisticsServiceImpl.class);

    public Long insert(OrderStatistics orderStatistics) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + orderStatistics));
        if (orderStatistics == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        orderStatistics.setCreateAt(Long.valueOf(currentTimeMillis));
        orderStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)orderStatistics);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + orderStatistics));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<OrderStatistics> insertList(List<OrderStatistics> orderStatisticsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (orderStatisticsList == null ? "null" : Integer.valueOf(orderStatisticsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(orderStatisticsList)) {
            return new ArrayList<OrderStatistics>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (OrderStatistics orderStatistics : orderStatisticsList) {
            orderStatistics.setCreateAt(Long.valueOf(currentTimeMillis));
            orderStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(orderStatisticsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + orderStatisticsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(OrderStatistics.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(OrderStatistics orderStatistics) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (orderStatistics == null ? "null" : orderStatistics.getId())));
        boolean result = false;
        if (orderStatistics == null) {
            return true;
        }
        orderStatistics.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)orderStatistics);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + orderStatistics));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + orderStatistics));
        }
        return result;
    }

    public boolean updateList(List<OrderStatistics> orderStatisticsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (orderStatisticsList == null ? "null" : Integer.valueOf(orderStatisticsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(orderStatisticsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (OrderStatistics orderStatistics : orderStatisticsList) {
            orderStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(orderStatisticsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + orderStatisticsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + orderStatisticsList.size()));
        return result;
    }

    public OrderStatistics getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        OrderStatistics orderStatistics = null;
        if (id == null) {
            return orderStatistics;
        }
        try {
            orderStatistics = (OrderStatistics)this.dao.get(OrderStatistics.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return orderStatistics;
    }

    public List<OrderStatistics> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List orderStatistics = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OrderStatistics>();
        }
        try {
            orderStatistics = this.dao.getList(OrderStatistics.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (orderStatistics == null ? "null" : Integer.valueOf(orderStatistics.size()))));
        return orderStatistics;
    }

    public Long getOrderStatisticsIdByStaticAt(Long staticAt) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by staticAt  : " + staticAt));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrderStatisticsIdByStaticAt", new Object[]{staticAt});
        }
        catch (DaoException e) {
            log.error((Object)("  get id wrong by staticAt  : " + staticAt));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getOrderStatisticsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderStatisticsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderStatisticsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrderStatisticsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrderStatisticsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

