/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.BookVersion;
import com.ptteng.learn.course.service.BookVersionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BookVersionServiceImpl
extends BaseDaoServiceImpl
implements BookVersionService {
    private static final Log log = LogFactory.getLog(BookVersionServiceImpl.class);

    public Long insert(BookVersion bookVersion) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + bookVersion));
        if (bookVersion == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        bookVersion.setCreateAt(Long.valueOf(currentTimeMillis));
        bookVersion.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)bookVersion);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + bookVersion));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<BookVersion> insertList(List<BookVersion> bookVersionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (bookVersionList == null ? "null" : Integer.valueOf(bookVersionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(bookVersionList)) {
            return new ArrayList<BookVersion>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BookVersion bookVersion : bookVersionList) {
            bookVersion.setCreateAt(Long.valueOf(currentTimeMillis));
            bookVersion.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(bookVersionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + bookVersionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(BookVersion.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(BookVersion bookVersion) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (bookVersion == null ? "null" : bookVersion.getId())));
        boolean result = false;
        if (bookVersion == null) {
            return true;
        }
        bookVersion.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)bookVersion);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + bookVersion));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + bookVersion));
        }
        return result;
    }

    public boolean updateList(List<BookVersion> bookVersionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (bookVersionList == null ? "null" : Integer.valueOf(bookVersionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(bookVersionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BookVersion bookVersion : bookVersionList) {
            bookVersion.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(bookVersionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + bookVersionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + bookVersionList.size()));
        return result;
    }

    public BookVersion getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        BookVersion bookVersion = null;
        if (id == null) {
            return bookVersion;
        }
        try {
            bookVersion = (BookVersion)this.dao.get(BookVersion.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return bookVersion;
    }

    public List<BookVersion> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List bookVersion = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BookVersion>();
        }
        try {
            bookVersion = this.dao.getList(BookVersion.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (bookVersion == null ? "null" : Integer.valueOf(bookVersion.size()))));
        return bookVersion;
    }

    public List<Long> getBookVersionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBookVersionIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBookVersionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBookVersionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBookVersionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

