package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.LoginRecord;
import com.ptteng.learn.course.service.LoginRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class LoginRecordServiceImpl extends BaseDaoServiceImpl implements LoginRecordService {

 

	private static final Log log = LogFactory.getLog(LoginRecordServiceImpl.class);



		   
		@Override
		public Long insert(LoginRecord loginRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + loginRecord);

		if (loginRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		loginRecord.setCreateAt(currentTimeMillis);
		loginRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(loginRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + loginRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<LoginRecord> insertList(List<LoginRecord> loginRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (loginRecordList == null ? "null" : loginRecordList.size()));
      
		List<LoginRecord> resultList = null;

		if (CollectionUtils.isEmpty(loginRecordList)) {
			return new ArrayList<LoginRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (LoginRecord loginRecord : loginRecordList) {
			loginRecord.setCreateAt(currentTimeMillis);
			loginRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<LoginRecord>) dao.batchSave(loginRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + loginRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(LoginRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(LoginRecord loginRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (loginRecord == null ? "null" : loginRecord.getId()));

		boolean result = false;

		if (loginRecord == null) {
			return true;
		}

		loginRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(loginRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + loginRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + loginRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<LoginRecord> loginRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (loginRecordList == null ? "null" : loginRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(loginRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (LoginRecord loginRecord : loginRecordList) {
			loginRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(loginRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + loginRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + loginRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public LoginRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		LoginRecord loginRecord = null;

		if (id == null) {
			return loginRecord;
		}

		try {
			loginRecord = (LoginRecord) dao.get(LoginRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return loginRecord;		
		}	
		  
    	   
		@Override
		public List<LoginRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<LoginRecord> loginRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<LoginRecord>();
		}

		try {
			loginRecord = (List<LoginRecord>) dao.getList(LoginRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (loginRecord == null ? "null" : loginRecord.size()));
    
		return loginRecord;	
		}

	@Override
	public List<Long> getLoginRecordIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		log.info(" get ids by uid,start,limit " + uid + " , " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getLoginRecordIdsByUid",new Object[] {uid},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong uid,start,limit " + uid + " , " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public List<Long> getLoginRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getLoginRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countLoginRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getLoginRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getLoginRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

