package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.DictationNote;
import com.ptteng.learn.course.service.DictationNoteService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class DictationNoteServiceImpl extends BaseDaoServiceImpl implements DictationNoteService {

 

	private static final Log log = LogFactory.getLog(DictationNoteServiceImpl.class);



		   
		@Override
		public Long insert(DictationNote dictationNote)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + dictationNote);

		if (dictationNote == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		dictationNote.setCreateAt(currentTimeMillis);
		dictationNote.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(dictationNote);
		} catch (DaoException e) {
			log.error(" insert wrong : " + dictationNote);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<DictationNote> insertList(List<DictationNote> dictationNoteList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (dictationNoteList == null ? "null" : dictationNoteList.size()));
      
		List<DictationNote> resultList = null;

		if (CollectionUtils.isEmpty(dictationNoteList)) {
			return new ArrayList<DictationNote>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (DictationNote dictationNote : dictationNoteList) {
			dictationNote.setCreateAt(currentTimeMillis);
			dictationNote.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<DictationNote>) dao.batchSave(dictationNoteList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + dictationNoteList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(DictationNote.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(DictationNote dictationNote)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (dictationNote == null ? "null" : dictationNote.getId()));

		boolean result = false;

		if (dictationNote == null) {
			return true;
		}

		dictationNote.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(dictationNote);
		} catch (DaoException e) {
			log.error(" update wrong : " + dictationNote);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + dictationNote);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<DictationNote> dictationNoteList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (dictationNoteList == null ? "null" : dictationNoteList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(dictationNoteList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (DictationNote dictationNote : dictationNoteList) {
			dictationNote.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(dictationNoteList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + dictationNoteList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + dictationNoteList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public DictationNote getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		DictationNote dictationNote = null;

		if (id == null) {
			return dictationNote;
		}

		try {
			dictationNote = (DictationNote) dao.get(DictationNote.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return dictationNote;		
		}	
		  
    	   
		@Override
		public List<DictationNote> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<DictationNote> dictationNote = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<DictationNote>();
		}

		try {
			dictationNote = (List<DictationNote>) dao.getList(DictationNote.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (dictationNote == null ? "null" : dictationNote.size()));
    
		return dictationNote;	
		}

	@Override
	public List<Long> getDictationNoteIdsByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException {
		log.info(" get ids by uid,sid " + uid + " , " + sid);
		List<Long> idList = null;

		try {
			idList = dao.getIdList("getDictationNoteIdsByUidAndSid",new Object[] {uid, sid}, 0, Integer.MAX_VALUE, false);
		} catch (DaoException e) {
			log.error(" get ids wrong by uid,sid : " + uid + " , " + sid);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public Long getDictationNoteIdsByUidAndSidAndName(Long uid, Long sid, String name) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by uid , sid , name  : " + uid + " , " + sid + " , " + name);
		}
		Long id = null;

		// TODO 参数检查!

		try {

			id = (Long) dao.getMapping("getDictationNoteIdsByUidAndSidAndName", new Object[]{uid, sid, name});

		} catch (DaoException e) {
			log.error(" get id wrong by uid , sid , name  : " + uid + " , " + sid + " , " + name);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}

	@Override
	public Long getDefaultDictationNoteIdByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by uid , sid : " + uid + " , " + sid );
		}
		Long id = null;

		// TODO 参数检查!

		try {

			id = (Long) dao.getMapping("getDefaultDictationNoteIdByUidAndSid", new Object[]{uid, sid});

		} catch (DaoException e) {
			log.error(" get id wrong by uid , sid : " + uid + " , " + sid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}


	@Override
	public List<Long> getDictationNoteIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getDictationNoteIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countDictationNoteIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getDictationNoteIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getDictationNoteIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

