/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Sign;
import com.ptteng.learn.course.service.SignService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignServiceImpl
extends BaseDaoServiceImpl
implements SignService {
    private static final Log log = LogFactory.getLog(SignServiceImpl.class);

    public Long insert(Sign sign) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + sign));
        if (sign == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        sign.setCreateAt(Long.valueOf(currentTimeMillis));
        sign.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)sign);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + sign));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Sign> insertList(List<Sign> signList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (signList == null ? "null" : Integer.valueOf(signList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(signList)) {
            return new ArrayList<Sign>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sign sign : signList) {
            sign.setCreateAt(Long.valueOf(currentTimeMillis));
            sign.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(signList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + signList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Sign.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Sign sign) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (sign == null ? "null" : sign.getId())));
        boolean result = false;
        if (sign == null) {
            return true;
        }
        sign.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)sign);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + sign));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + sign));
        }
        return result;
    }

    public boolean updateList(List<Sign> signList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (signList == null ? "null" : Integer.valueOf(signList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(signList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sign sign : signList) {
            sign.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(signList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + signList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + signList.size()));
        return result;
    }

    public Sign getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Sign sign = null;
        if (id == null) {
            return sign;
        }
        try {
            sign = (Sign)this.dao.get(Sign.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return sign;
    }

    public List<Sign> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List sign = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Sign>();
        }
        try {
            sign = this.dao.getList(Sign.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (sign == null ? "null" : Integer.valueOf(sign.size()))));
        return sign;
    }

    public List<Long> getSignIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSignIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getSignIdsByUidAndSignDateAreaOrderBySignDateAsc(Long uid, Long signStart, Long signEnd) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,signStart,signEnd  : " + uid + " , " + signStart + " , " + signEnd));
        }
        List idList = null;
        try {
            idList = this.dao.getIdList("getSignIdsByUidAndSignDateAreaOrderBySignDateAsc", new Object[]{uid, signStart, signEnd}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,signStart,signEnd  : " + uid + " , " + signStart + " , " + signEnd));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getSignIdByUidAndSignDate(Long uid, Long signDate) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,signDate  : " + uid + " , " + signDate));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getSignIdByUidAndSignDate", new Object[]{uid, signDate});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,signDate  : " + uid + " , " + signDate));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countSignIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSignIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getSignIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSignIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSignIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSignIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSignIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

