package com.ptteng.learn.course.service.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import org.apache.commons.lang3.time.DateUtils;
import org.osoa.sca.annotations.Remotable;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


public class UserOrderServiceImpl extends BaseDaoServiceImpl implements UserOrderService {


    private static final Log log = LogFactory.getLog("order");

    @Autowired
    UserPaperRelationService userPaperRelationService;
    @Autowired
    PeriodService periodService;
    @Autowired
    UserService userService;
    @Autowired
    LocksService locksService;
    @Autowired
    LessonService lessonService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserRecommendService userRecommendService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Autowired
    RecommendStatisticsService recommendStatisticsService;
    @Autowired
    OrderStatisticsService orderStatisticsService;

    @Override
    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userOrder);

        if (userOrder == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(currentTimeMillis);
        userOrder.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userOrder);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userOrder);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userOrderList == null ? "null" : userOrderList.size()));

        List<UserOrder> resultList = null;

        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(currentTimeMillis);
            userOrder.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserOrder>) dao.batchSave(userOrderList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userOrderList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserOrder.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userOrder == null ? "null" : userOrder.getId()));

        boolean result = false;

        if (userOrder == null) {
            return true;
        }

        userOrder.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userOrder);
        } catch (DaoException e) {
            log.error(" update wrong : " + userOrder);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userOrder);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userOrderList == null ? "null" : userOrderList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userOrderList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userOrderList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userOrderList.size());

        return result;
    }


    @Override
    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserOrder userOrder = null;

        if (id == null) {
            return userOrder;
        }

        try {
            userOrder = (UserOrder) dao.get(UserOrder.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userOrder;
    }


    @Override
    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserOrder> userOrder = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }

        try {
            userOrder = (List<UserOrder>) dao.getList(UserOrder.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userOrder == null ? "null" : userOrder.size()));

        return userOrder;
    }

    @Override
    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by order_id  : " + orderId);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getIdByOrderId", new Object[]{orderId});
        } catch (DaoException e) {
            log.error(" get id wrong by orderId  : " + orderId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return getObjectById(id);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        } catch (DaoException e) {
            log.error(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status);
        }
        List<Long> ids = null;

        // TODO 参数检查!

        try {

            ids = dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + ids);
        }
        return ids;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,buyType  : " + uid + " , " + buyType);
        }
        Integer count = null;


        try {

            count = dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getUserOrderIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserOrderIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserOrderIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserOrderIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }


    //在发送课程资料的时候，将课程所有的课时（包括上下架）资料全部发送
    //已经下架的课时，可以发送资料
    @Override
    public void noticeBack(String indentCode, int respCode, int payManner, String os) throws ServiceException, ServiceDaoException {
        Locks locks = new Locks();
        List<Long> pids = new ArrayList<>();
        List<Locks> lockses = new ArrayList<>();
        Long lockRelation = 0L;
        UserPaperRelation userPaperRelation = new UserPaperRelation();
        List<UserPaperRelation> userPaperRelations = new ArrayList<>();

        try {
            log.info("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : "
                    + payManner + " and os : " + os);
            UserOrder order = getOrderObjectByOrderId(indentCode);
            log.info("get order : " + order.toString());
            if (!Integer.valueOf(UserOrder.WAITFORPAY).equals(order.getStatus())) {
                log.info(" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = userService.getObjectById(uid);

            switch (respCode) {
                case UserOrder.PAY_SUCCESS:         //支付成功
                    status = UserOrder.COMPLETED;  //订单状态设为完成
                    log.info("lesson order : " + order.getId() + " completed ");

                    switch (order.getBuyType()) {
                        case UserOrder.ORDER_LESSON: {

                            log.info("==========解锁课程逻辑==========");

                            locks.setTargetID(targetId);
                            locks.setUserID(uid);
                            locks.setType(order.getBuyType());
                            locksService.insert(locks);

                            pids = periodService.getPeriodIdsByLessonIDOrderBySort(targetId, null, null);
                            log.info("pids size : " + pids.size());

                            List<Period> periods = periodService.getObjectsByIds(pids);
                            for (Period period : periods) {
                                if (Period.Lock.equals(period.getLocked())) {
                                    lockRelation = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                                    if (null == lockRelation) {
                                        Locks locks1 = new Locks();
                                        locks1.setUserID(uid);
                                        locks1.setType(Locks.TYPE_PERIOD);
                                        locks1.setTargetID(period.getId());
                                        lockses.add(locks1);
                                    }
                                }
                            }
                            locksService.insertList(lockses);
                            break;
                        }

                        case UserOrder.ORDER_PERIOD: {

                            log.info("==========解锁课时逻辑==========");

                            locks.setTargetID(targetId);
                            locks.setUserID(uid);
                            locks.setType(order.getBuyType());
                            locksService.insert(locks);

                            //是否已将所属课程/教材全部解锁
                            Period period = periodService.getObjectById(targetId);

                            if (Period.Lesson.equals(period.getType())) {
                                List<Long> periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getLessonID(), Period.status_normal, 0, Integer.MAX_VALUE);
                                List<Period> periods = periodService.getObjectsByIds(periodIds);
                                for (Period period1 : periods) {
                                    if (Period.Lock.equals(period.getLocked())) {
                                        Long lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period1.getId());
                                        if (null == lockId) {
                                            unlockStatus = false;
                                        }
                                    }
                                }
                                if (unlockStatus) {
                                    Long locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, period.getLessonID());
                                    if (null == locksId) {
                                        locks.setId(null);
                                        locks.setTargetID(period.getLessonID());
                                        locks.setUserID(uid);
                                        locks.setType(Locks.TYPE_LESSON);
                                        locksService.insert(locks);
                                    }
                                }
                            } else {
                                List<Long> periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(period.getBookID(), Period.status_normal, 0, Integer.MAX_VALUE);
                                List<Period> periods = periodService.getObjectsByIds(periodIds);
                                for (Period period1 : periods) {
                                    if (Period.Lock.equals(period.getLocked())) {
                                        Long lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period1.getId());
                                        if (null == lockId) {
                                            unlockStatus = false;
                                        }
                                    }
                                }
                                if (unlockStatus) {
                                    Long locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_BOOK, period.getBookID());
                                    if (null == locksId) {
                                        locks.setId(null);
                                        locks.setTargetID(period.getBookID());
                                        locks.setUserID(uid);
                                        locks.setType(Locks.TYPE_BOOK);
                                        locksService.insert(locks);
                                    }
                                }
                            }

                            break;
                        }

                        case UserOrder.ORDER_LPAPER: {

                            log.info("==========购买课程资料逻辑==========");

                            userPaperRelation.setTarget(targetId);
                            userPaperRelation.setUid(uid);
                            userPaperRelation.setType(order.getBuyType());
                            userPaperRelationService.insert(userPaperRelation);

                            pids = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal, 0, Integer.MAX_VALUE);
                            List<Period> periods = periodService.getObjectsByIds(pids);
                            log.info("pids size : " + pids);
                            for (Period period : periods) {
                                log.info("pid is " + period.getId());
                                if (null != period.getPaperID()) {
                                    UserPaperRelation userPaperRelation1 = new UserPaperRelation();
                                    userPaperRelation1.setUid(uid);
                                    userPaperRelation1.setType(UserPaperRelation.TYPE_PPAPER);
                                    userPaperRelation1.setTarget(period.getId());
                                    userPaperRelations.add(userPaperRelation1);
                                    log.info("insert relation : " + userPaperRelation);
                                }
                            }
                            userPaperRelationService.insertList(userPaperRelations);

                            Integer learnBuy = user.getLearnBuy();
                            user.setLearnBuy(learnBuy + 1);
                            log.info("user learn buy : " + learnBuy + " >>>>>>>>>> " + user.getLearnBuy());
                            userService.update(user);
                            break;
                        }

                        case UserOrder.ORDER_PPAPER: {

                            log.info("==========购买课时资料逻辑==========");

                            userPaperRelation.setTarget(targetId);
                            userPaperRelation.setUid(uid);
                            userPaperRelation.setType(order.getBuyType());
                            userPaperRelationService.insert(userPaperRelation);

                            //是否已将所属课程/教材资料全部解锁
                            Period period = periodService.getObjectById(targetId);

                            if (Period.Lesson.equals(period.getType())) {
                                List<Long> periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getLessonID(), Period.status_normal, 0, Integer.MAX_VALUE);
                                List<Period> periods = periodService.getObjectsByIds(periodIds);
                                for (Period period1 : periods) {
                                    if (null != period.getPaperID()) {
                                        Long paperRelationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period1.getId());
                                        if (null == paperRelationId) {
                                            unlockStatus = false;
                                        }
                                    }
                                }
                                if (unlockStatus) {
                                    Long relationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_LPAPER, uid, period.getLessonID());
                                    if (null == relationId) {
                                        log.info("insert LPAPER record");
                                        userPaperRelation.setId(null);
                                        userPaperRelation.setTarget(period.getLessonID());
                                        userPaperRelation.setUid(uid);
                                        userPaperRelation.setType(UserPaperRelation.TYPE_LPAPER);
                                        userPaperRelationService.insert(userPaperRelation);
                                    }
                                }
                            } else {
                                List<Long> periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(period.getBookID(), Period.status_normal, 0, Integer.MAX_VALUE);
                                List<Period> periods = periodService.getObjectsByIds(periodIds);
                                for (Period period1 : periods) {
                                    if (null != period.getPaperID()) {
                                        Long paperRelationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_BPAPER, uid, period1.getId());
                                        if (null == paperRelationId) {
                                            unlockStatus = false;
                                        }
                                    }
                                }
                                if (unlockStatus) {
                                    Long relationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_BPAPER, uid, period.getBookID());
                                    if (null == relationId) {
                                        log.info("insert BPAPER record");
                                        userPaperRelation.setId(null);
                                        userPaperRelation.setTarget(period.getBookID());
                                        userPaperRelation.setUid(uid);
                                        userPaperRelation.setType(UserPaperRelation.TYPE_BPAPER);
                                        userPaperRelationService.insert(userPaperRelation);
                                    }
                                }
                            }

                            Integer learnBuy = user.getLearnBuy();
                            user.setLearnBuy(learnBuy + 1);
                            log.info("user learn buy : " + learnBuy + " >>>>>>>>>> " + user.getLearnBuy());
                            userService.update(user);

                            break;
                        }

                        case UserOrder.ORDER_BPAPER: {

                            log.info("==========购买教材资料逻辑==========");

                            userPaperRelation.setTarget(targetId);
                            userPaperRelation.setUid(uid);
                            userPaperRelation.setType(order.getBuyType());
                            userPaperRelationService.insert(userPaperRelation);

                            pids = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(targetId, Period.status_normal, 0, Integer.MAX_VALUE);
                            List<Period> periods = periodService.getObjectsByIds(pids);
                            log.info("pids size : " + pids.size());
                            for (Period period : periods) {
                                if (null != period.getPaperID()) {
                                    UserPaperRelation userPaperRelation1 = new UserPaperRelation();
                                    userPaperRelation1.setUid(uid);
                                    userPaperRelation1.setType(UserPaperRelation.TYPE_PPAPER);
                                    userPaperRelation1.setTarget(period.getId());
                                    userPaperRelations.add(userPaperRelation1);
                                }
                            }
                            userPaperRelationService.insertList(userPaperRelations);

                            Integer learnBuy = user.getLearnBuy();
                            user.setLearnBuy(learnBuy + 1);
                            log.info("user learn buy : " + learnBuy + " >>>>>>>>>> " + user.getLearnBuy());
                            userService.update(user);
                            break;
                        }

                        case UserOrder.ORDER_MEMBER: {

                            log.info("==========购买会员逻辑==========");

                            log.info(" pay noticeBack ,type is member ");
                            Member member = memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;

                            //判断是开会员还是续费会员
                            List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, User.IS_MEMBER, 0, Integer.MAX_VALUE);
                            if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                                log.info(" user " + uid + " is not a member ");

                                log.info("==========开会员逻辑==========");

                                startAt = now;

                            } else {
                                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    log.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                                        log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                                        endAt = userMemberRelation.getEndAt().longValue();
                                    } else {
                                        log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                                    }
                                }
                                log.info("final end at member time is : " + endAt);

                                startAt = endAt;

                            }

                            //给用户添加会员记录
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(User.IS_MEMBER);
                            userMemberRelation.setStartAt(startAt);

                            Date startDate = new Date(startAt);
                            Date endDate = DateUtils.addMonths(startDate, member.getPeriod().intValue());

                            endAt = endDate.getTime();
                            userMemberRelation.setEndAt(endAt);
                            log.info(" user " + uid + " member startAt = " + getDate(now) + " endAt = " + getDate(endAt));
                            Long userMemberRelationId = userMemberRelationService.insert(userMemberRelation);
                            log.info(" user " + uid + " member id is = " + userMemberRelationId);


                            break;
                        }

                    }
                    break;

                case UserOrder.PAY_FAIL:         //支付失败
                    status = UserOrder.CLOSED; //订单状态设为关闭
                    log.info("lesson order : " + order.getId() + " close ");

                    break;
            }

            if (UserOrder.PAY_SUCCESS == respCode) {
                log.info("==========支付成功，记录推广统计信息==========");

                user = userService.getObjectById(uid);
                Long recommendId = user.getRecommendId();
                log.info(" user recommend is " + recommendId);

                //记录消费用户不同平台消费
                if ("ios".equals(os)) {
                    BigDecimal userIosAmount = user.getIosAmount();
                    user.setIosAmount(userIosAmount.add(order.getPrice()));
                    log.info("user ios amount " + userIosAmount + " >>>>>>>>>> " + user.getIosAmount());
                } else {
                    BigDecimal userAndroidAmount = user.getAndroidAmount();
                    user.setAndroidAmount(userAndroidAmount.add(order.getPrice()));
                    log.info("user ios amount " + userAndroidAmount + " >>>>>>>>>> " + user.getAndroidAmount());
                }

                //用户第一次消费修改消费状态添加推荐人消费计数
                if (User.no_spend.equals(user.getSpendStatus())) {
                    user.setSpendStatus(User.spend);
                    userService.update(user);
                    log.info("user spend status update ");
                    if (null != recommendId) {
                        UserRecommend userRecommend = userRecommendService.getObjectById(recommendId);

                        if (null == userRecommend) {
                            //推荐用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                            UserRecommend newUserRecommend = new UserRecommend();
                            newUserRecommend.setId(recommendId);
                            log.info("insert newUserRecommend : " + newUserRecommend);
                            userRecommendService.insert(newUserRecommend);

                            userRecommend = userRecommendService.getObjectById(recommendId);
                            log.info("user recommend info not exist , create and insert data : " + userRecommend);
                        } else {
                            log.info("user recommend info : " + userRecommend);
                        }

                        Integer oldSpendNum = userRecommend.getSpendNum();
                        userRecommend.setSpendNum(oldSpendNum + 1);
                        userRecommendService.update(userRecommend);
                        log.info("user : " + recommendId + " spend recommend user number " + oldSpendNum + " >>>>>>>>>> " + userRecommend.getSpendNum());
                    }
                }

                if (null != recommendId) {
                    log.info(" add recommend statistics ");
                    RecommendStatistics recommendStatistics = null;

                    Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
                    log.info(" today is = " + getDate(staticAt));
                    List<Long> recommendStatisticsIds = recommendStatisticsService.getIdsByUserId(recommendId, 0, 1);
                    log.info(" recommendStatisticsIds size = " + recommendStatisticsIds.size());
                    if (recommendStatisticsIds.size() > 0) {
                        recommendStatistics = recommendStatisticsService.getObjectById(recommendStatisticsIds.get(0));
                        if (staticAt.equals(recommendStatistics.getStaticAt())) {
                            log.info(" add 1 ");
                            recommendStatistics.setAmount(recommendStatistics.getAmount().add(order.getPrice()));
                            recommendStatisticsService.update(recommendStatistics);
                        } else {
                            log.info(" new  recommendStatistics  ");
                            recommendStatistics = new RecommendStatistics();
                            recommendStatistics.setStaticAt(staticAt);
                            recommendStatistics.setUid(recommendId);
                            recommendStatistics.setAmount(order.getPrice());
                            recommendStatisticsService.insert(recommendStatistics);
                        }

                    } else {
                        log.info(" new  recommendStatistics  ");
                        recommendStatistics = new RecommendStatistics();
                        recommendStatistics.setStaticAt(staticAt);
                        recommendStatistics.setUid(recommendId);
                        recommendStatistics.setAmount(order.getPrice());
                        recommendStatisticsService.insert(recommendStatistics);
                    }

                    //修改用户推荐人推广消费记录
                    UserRecommend userRecommend = userRecommendService.getObjectById(recommendId);

                    if (null == userRecommend) {
                        //推荐用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                        UserRecommend newUserRecommend = new UserRecommend();
                        newUserRecommend.setId(recommendId);
                        log.info("insert newUserRecommend : " + newUserRecommend);
                        userRecommendService.insert(newUserRecommend);

                        userRecommend = userRecommendService.getObjectById(recommendId);
                        log.info("user recommend info not exist , create and insert data : " + userRecommend);
                    } else {
                        log.info("user recommend info : " + userRecommend);
                    }

                    if ("ios".equals(os)) {
                        BigDecimal IosAmount = userRecommend.getIosAmount();
                        userRecommend.setIosAmount(IosAmount.add(order.getPrice()));
                        log.info("user ios amount " + IosAmount + " >>>>>>>>>> " + userRecommend.getIosAmount());
                    } else {
                        BigDecimal AndroidAmount = userRecommend.getAndroidAmount();
                        userRecommend.setAndroidAmount(AndroidAmount.add(order.getPrice()));
                        log.info("user ios amount " + AndroidAmount + " >>>>>>>>>> " + userRecommend.getAndroidAmount());
                    }

                    userRecommendService.update(userRecommend);

                    //订单统计
                    addOrderStatistics(order.getBuyType(), payManner, order.getPrice());
                }

            } else {
                log.info("==========支付失败，不记录统计信息==========");
            }

            order.setStatus(status);
            order.setPayType(payManner);
            order.setUpdateAt(System.currentTimeMillis());
            order.setPayAt(System.currentTimeMillis());
            update(order);
            log.info("update order over");


        } catch (Exception e) {
            log.error(e.getMessage());
            log.error(e.getStackTrace());

            e.printStackTrace(System.out);
            log.error("error : ", e);
        }

    }


    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }


    public void addOrderStatistics(Integer buyType, Integer payManner, BigDecimal price) throws ServiceException, ServiceDaoException {

        log.info(" add recommend statistics ");

        Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
        log.info(" today is = " + getDate(staticAt));

        Long sid = orderStatisticsService.getOrderStatisticsIdByStaticAt(staticAt);
        OrderStatistics orderStatistics = orderStatisticsService.getObjectById(sid);

        if (orderStatistics != null) {
            log.info(" add 1 ");
            orderStatistics.setOrderCount(orderStatistics.getOrderCount() + 1);
            orderStatistics.setTotalAmount(orderStatistics.getTotalAmount().add(price));
            switch (buyType) {
                case UserOrder.ORDER_LESSON: {
                    orderStatistics.setLessonCount(orderStatistics.getLessonCount() + 1);
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_PERIOD: {
                    orderStatistics.setLessonCount(orderStatistics.getLessonCount() + 1);
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_LPAPER: {
                    orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_PPAPER: {
                    orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_BPAPER: {
                    orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_MEMBER: {
                    orderStatistics.setVipCount(orderStatistics.getVipCount() + 1);
                    orderStatistics.setVipAmount(orderStatistics.getVipAmount().add(price));
                    break;
                }
            }

            switch (payManner) {
                case UserOrder.PAYMANNER_3: {
                    orderStatistics.setAlipayAmount(orderStatistics.getAlipayAmount().add(price));
                    break;
                }
                case UserOrder.PAYMANNER_4: {
                    orderStatistics.setWeixinAmount(orderStatistics.getWeixinAmount().add(price));
                    break;
                }
                case UserOrder.PAYMANNER_5: {
                    orderStatistics.setAppleAmount(orderStatistics.getAppleAmount().add(price));
                    break;
                }
            }

            orderStatisticsService.update(orderStatistics);
        } else {
            log.info(" new  recommendStatistics  ");
            orderStatistics = new OrderStatistics();
            orderStatistics.setStaticAt(staticAt);
            orderStatistics.setOrderCount(1);
            orderStatistics.setTotalAmount(price);
            switch (buyType) {
                case UserOrder.ORDER_LESSON: {
                    orderStatistics.setLessonCount(1);
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case UserOrder.ORDER_PERIOD: {
                    orderStatistics.setLessonCount(1);
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case UserOrder.ORDER_LPAPER: {
                    orderStatistics.setPaperCount(1);
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case UserOrder.ORDER_PPAPER: {
                    orderStatistics.setPaperCount(1);
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case UserOrder.ORDER_BPAPER: {
                    orderStatistics.setPaperCount(1);
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case UserOrder.ORDER_MEMBER: {
                    orderStatistics.setVipCount(1);
                    orderStatistics.setVipAmount(price);
                    break;
                }
            }

            switch (payManner) {
                case UserOrder.PAYMANNER_3: {
                    orderStatistics.setAlipayAmount(price);
                    break;
                }
                case UserOrder.PAYMANNER_4: {
                    orderStatistics.setWeixinAmount(price);
                    break;
                }
                case UserOrder.PAYMANNER_5: {
                    orderStatistics.setAppleAmount(price);
                    break;
                }
            }
            orderStatisticsService.insert(orderStatistics);
        }

    }
}

