package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.Unit;
import com.ptteng.learn.course.service.UnitService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UnitServiceImpl extends BaseDaoServiceImpl implements UnitService {

 

	private static final Log log = LogFactory.getLog(UnitServiceImpl.class);



		   
		@Override
		public Long insert(Unit unit)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + unit);

		if (unit == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		unit.setCreateAt(currentTimeMillis);
		unit.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(unit);
		} catch (DaoException e) {
			log.error(" insert wrong : " + unit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Unit> insertList(List<Unit> unitList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (unitList == null ? "null" : unitList.size()));
      
		List<Unit> resultList = null;

		if (CollectionUtils.isEmpty(unitList)) {
			return new ArrayList<Unit>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Unit unit : unitList) {
			unit.setCreateAt(currentTimeMillis);
			unit.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Unit>) dao.batchSave(unitList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + unitList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Unit.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Unit unit)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (unit == null ? "null" : unit.getId()));

		boolean result = false;

		if (unit == null) {
			return true;
		}

		unit.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(unit);
		} catch (DaoException e) {
			log.error(" update wrong : " + unit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + unit);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Unit> unitList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (unitList == null ? "null" : unitList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(unitList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Unit unit : unitList) {
			unit.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(unitList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + unitList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + unitList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Unit getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Unit unit = null;

		if (id == null) {
			return unit;
		}

		try {
			unit = (Unit) dao.get(Unit.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return unit;		
		}	
		  
    	   
		@Override
		public List<Unit> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Unit> unit = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Unit>();
		}

		try {
			unit = (List<Unit>) dao.getList(Unit.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (unit == null ? "null" : unit.size()));
    
		return unit;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUnitIdsByTaskIDOrderBySort(Long taskID,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by taskID,start,limit  : " + taskID+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUnitIdsByTaskIDOrderBySort", new Object[] { taskID},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by taskID,start,limit)  : " + taskID+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUnitIdsByTaskIDOrderBySort(Long taskID)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by taskID  : " + taskID );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUnitIdsByTaskIDOrderBySort", new Object[] { taskID});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by taskID)  : " + taskID );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUnitIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUnitIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUnitIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUnitIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUnitIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

