package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.learn.course.model.Sign;
import com.ptteng.learn.course.service.SignService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SignServiceImpl extends BaseDaoServiceImpl implements SignService {

 

	private static final Log log = LogFactory.getLog(SignServiceImpl.class);



		   
		@Override
		public Long insert(Sign sign)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + sign);

		if (sign == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		sign.setCreateAt(currentTimeMillis);
		sign.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(sign);
		} catch (DaoException e) {
			log.error(" insert wrong : " + sign);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Sign> insertList(List<Sign> signList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (signList == null ? "null" : signList.size()));
      
		List<Sign> resultList = null;

		if (CollectionUtils.isEmpty(signList)) {
			return new ArrayList<Sign>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Sign sign : signList) {
			sign.setCreateAt(currentTimeMillis);
			sign.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Sign>) dao.batchSave(signList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + signList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Sign.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Sign sign)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (sign == null ? "null" : sign.getId()));

		boolean result = false;

		if (sign == null) {
			return true;
		}

		sign.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(sign);
		} catch (DaoException e) {
			log.error(" update wrong : " + sign);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + sign);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Sign> signList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (signList == null ? "null" : signList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(signList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Sign sign : signList) {
			sign.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(signList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + signList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + signList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Sign getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Sign sign = null;

		if (id == null) {
			return sign;
		}

		try {
			sign = (Sign) dao.get(Sign.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return sign;		
		}	
		  
    	   
		@Override
		public List<Sign> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Sign> sign = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Sign>();
		}

		try {
			sign = (List<Sign>) dao.getList(Sign.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (sign == null ? "null" : sign.size()));
    
		return sign;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSignIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getSignIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getSignIdsByUidAndSignDateAreaOrderBySignDateAsc(Long uid, Long signStart, Long signEnd) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by uid,signStart,signEnd  : " + uid+" , "+signStart+" , "+signEnd );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		try {
			idList = dao.getIdList("getSignIdsByUidAndSignDateAreaOrderBySignDateAsc", new Object[] { uid,signStart,signEnd},0,Integer.MAX_VALUE, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,signStart,signEnd  : " + uid+" , "+signStart+" , "+signEnd );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getSignIdByUidAndSignDate(Long uid,Long signDate)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid,signDate  : " + uid+" , "+signDate );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getSignIdByUidAndSignDate", new Object[] {uid,signDate });
   } catch (DaoException e) {
			log.error(" get id wrong by uid,signDate  : " + uid+" , "+signDate );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSignIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSignIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getSignIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSignIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSignIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSignIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSignIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

