package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.ScoreRecord;
import com.ptteng.learn.course.service.ScoreRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ScoreRecordServiceImpl extends BaseDaoServiceImpl implements ScoreRecordService {

 

	private static final Log log = LogFactory.getLog(ScoreRecordServiceImpl.class);



		   
		@Override
		public Long insert(ScoreRecord scoreRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + scoreRecord);

		if (scoreRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		scoreRecord.setCreateAt(currentTimeMillis);
		scoreRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(scoreRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + scoreRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ScoreRecord> insertList(List<ScoreRecord> scoreRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (scoreRecordList == null ? "null" : scoreRecordList.size()));
      
		List<ScoreRecord> resultList = null;

		if (CollectionUtils.isEmpty(scoreRecordList)) {
			return new ArrayList<ScoreRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ScoreRecord scoreRecord : scoreRecordList) {
			scoreRecord.setCreateAt(currentTimeMillis);
			scoreRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ScoreRecord>) dao.batchSave(scoreRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + scoreRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ScoreRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ScoreRecord scoreRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (scoreRecord == null ? "null" : scoreRecord.getId()));

		boolean result = false;

		if (scoreRecord == null) {
			return true;
		}

		scoreRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(scoreRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + scoreRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + scoreRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ScoreRecord> scoreRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (scoreRecordList == null ? "null" : scoreRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(scoreRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ScoreRecord scoreRecord : scoreRecordList) {
			scoreRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(scoreRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + scoreRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + scoreRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ScoreRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ScoreRecord scoreRecord = null;

		if (id == null) {
			return scoreRecord;
		}

		try {
			scoreRecord = (ScoreRecord) dao.get(ScoreRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return scoreRecord;		
		}	
		  
    	   
		@Override
		public List<ScoreRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ScoreRecord> scoreRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ScoreRecord>();
		}

		try {
			scoreRecord = (List<ScoreRecord>) dao.getList(ScoreRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (scoreRecord == null ? "null" : scoreRecord.size()));
    
		return scoreRecord;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getScoreRecordIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getScoreRecordIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countScoreRecordIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getScoreRecordIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getScoreRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getScoreRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countScoreRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getScoreRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getScoreRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

