package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.Introduce;
import com.ptteng.learn.course.service.IntroduceService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class IntroduceServiceImpl extends BaseDaoServiceImpl implements IntroduceService {

 

	private static final Log log = LogFactory.getLog(IntroduceServiceImpl.class);



		   
		@Override
		public Long insert(Introduce introduce)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + introduce);

		if (introduce == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		introduce.setCreateAt(currentTimeMillis);
		introduce.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(introduce);
		} catch (DaoException e) {
			log.error(" insert wrong : " + introduce);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Introduce> insertList(List<Introduce> introduceList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (introduceList == null ? "null" : introduceList.size()));
      
		List<Introduce> resultList = null;

		if (CollectionUtils.isEmpty(introduceList)) {
			return new ArrayList<Introduce>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Introduce introduce : introduceList) {
			introduce.setCreateAt(currentTimeMillis);
			introduce.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Introduce>) dao.batchSave(introduceList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + introduceList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Introduce.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Introduce introduce)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (introduce == null ? "null" : introduce.getId()));

		boolean result = false;

		if (introduce == null) {
			return true;
		}

		introduce.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(introduce);
		} catch (DaoException e) {
			log.error(" update wrong : " + introduce);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + introduce);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Introduce> introduceList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (introduceList == null ? "null" : introduceList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(introduceList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Introduce introduce : introduceList) {
			introduce.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(introduceList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + introduceList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + introduceList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Introduce getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Introduce introduce = null;

		if (id == null) {
			return introduce;
		}

		try {
			introduce = (Introduce) dao.get(Introduce.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return introduce;		
		}	
		  
    	   
		@Override
		public List<Introduce> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Introduce> introduce = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Introduce>();
		}

		try {
			introduce = (List<Introduce>) dao.getList(Introduce.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (introduce == null ? "null" : introduce.size()));
    
		return introduce;	
		}

	@Override
	public List<Long> getIdsByLessonId(Long lessonId) throws ServiceException, ServiceDaoException {
		log.info(" get ids by level,start,limit  : "  );

	List<Long> idList = null;

	// TODO 参数检查!

	try {
		idList = dao.getIdList("getIdsByLessonId", new Object[] {lessonId},0,Integer.MAX_VALUE, false);


	} catch (DaoException e) {
		log.error(" get ids  wrong by level,start,limit)  : "  );
		log.error(e);
		e.printStackTrace();
		throw new ServiceDaoException(e);
	}
	if(log.isInfoEnabled()){
		log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
	}
	return idList;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIntroduceIdsByLevel(Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by level,start,limit  : " + level+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIntroduceIdsByLevel", new Object[] { level},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by level,start,limit)  : " + level+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIntroduceIdsByLevel(Integer level)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by level  : " + level );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIntroduceIdsByLevel", new Object[] { level});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by level)  : " + level );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getIntroduceIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getIntroduceIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countIntroduceIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getIntroduceIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getIntroduceIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

