package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.ptteng.learn.course.model.Collaborate;
import com.ptteng.learn.course.service.CollaborateService;
import org.osoa.sca.annotations.Remotable;




import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class CollaborateServiceImpl extends BaseDaoServiceImpl implements CollaborateService {

 

	private static final Log log = LogFactory.getLog(CollaborateServiceImpl.class);



		   
		@Override
		public Long insert(Collaborate collaborate)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + collaborate);

		if (collaborate == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		collaborate.setCreateAt(currentTimeMillis);
		collaborate.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(collaborate);
		} catch (DaoException e) {
			log.error(" insert wrong : " + collaborate);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Collaborate> insertList(List<Collaborate> collaborateList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (collaborateList == null ? "null" : collaborateList.size()));
      
		List<Collaborate> resultList = null;

		if (CollectionUtils.isEmpty(collaborateList)) {
			return new ArrayList<Collaborate>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Collaborate collaborate : collaborateList) {
			collaborate.setCreateAt(currentTimeMillis);
			collaborate.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Collaborate>) dao.batchSave(collaborateList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + collaborateList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Collaborate.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Collaborate collaborate)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (collaborate == null ? "null" : collaborate.getId()));

		boolean result = false;

		if (collaborate == null) {
			return true;
		}

		collaborate.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(collaborate);
		} catch (DaoException e) {
			log.error(" update wrong : " + collaborate);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + collaborate);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Collaborate> collaborateList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (collaborateList == null ? "null" : collaborateList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(collaborateList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Collaborate collaborate : collaborateList) {
			collaborate.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(collaborateList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + collaborateList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + collaborateList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Collaborate getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Collaborate collaborate = null;

		if (id == null) {
			return collaborate;
		}

		try {
			collaborate = (Collaborate) dao.get(Collaborate.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return collaborate;		
		}	
		  
    	   
		@Override
		public List<Collaborate> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Collaborate> collaborate = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Collaborate>();
		}

		try {
			collaborate = (List<Collaborate>) dao.getList(Collaborate.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (collaborate == null ? "null" : collaborate.size()));
    
		return collaborate;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getCollaborateIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCollaborateIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCollaborateIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCollaborateIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCollaborateIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

