package com.ptteng.learn.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.learn.course.model.LoginRecord;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface LoginRecordService extends BaseDaoService {

	



   		   
		
		public Long insert(LoginRecord loginRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<LoginRecord> insertList(List<LoginRecord> loginRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(LoginRecord loginRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<LoginRecord> loginRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public LoginRecord getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<LoginRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;




	/**
	 * @Description 根据用户id获取登陆记录
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/29 23:38
	 */
	public List<Long> getLoginRecordIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getLoginRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countLoginRecordIds() throws ServiceException, ServiceDaoException;
	

}

