package com.ptteng.learn.course.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user_recommend")
public class UserRecommend implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6086761634196338688L;

	public static final Integer Recommend_normal = 1;

	public static final Integer Recommend_forbidden = 2;


	public static final Integer android = 1;

	public static final Integer ios = 2;
   	 


	private  Long id;
	
  	 
    private  Integer recommendStatus = Recommend_forbidden;
	
  	 
    private  BigDecimal discount = BigDecimal.TEN;
	
  	 
    private  Integer recommendNum = 0;
	
  	 
    private  Integer spendNum = 0;
	
  	 
    private  BigDecimal iosAmount = BigDecimal.ZERO;
	
  	 
    private  BigDecimal androidAmount = BigDecimal.ZERO;
	
  	 
    private  BigDecimal iosSettlement = BigDecimal.ZERO;
	
  	 
    private  BigDecimal androidSettlement = BigDecimal.ZERO;

	/**
	 * 1、显示
	 * 2、隐藏
	 */
	public static final Integer DISPLAY_TRUE = 1;
	public static final Integer DISPLAY_FALSE = 2;

	private  Integer display = DISPLAY_FALSE;


    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
	
  
	
		 	
			@Id
			@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "recommend_status")
	public Integer getRecommendStatus() {
		return recommendStatus;
	}
	
	
	public void setRecommendStatus(Integer recommendStatus) {
		this.recommendStatus = recommendStatus;
	}
		 	@Column(name = "discount")
	public BigDecimal getDiscount() {
		return discount;
	}
	
	
	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}
		 	@Column(name = "recommend_num")
	public Integer getRecommendNum() {
		return recommendNum;
	}
	
	
	public void setRecommendNum(Integer recommendNum) {
		this.recommendNum = recommendNum;
	}
		 	@Column(name = "spend_num")
	public Integer getSpendNum() {
		return spendNum;
	}
	
	
	public void setSpendNum(Integer spendNum) {
		this.spendNum = spendNum;
	}
		 	@Column(name = "ios_amount")
	public BigDecimal getIosAmount() {
		return iosAmount;
	}
	
	
	public void setIosAmount(BigDecimal iosAmount) {
		this.iosAmount = iosAmount;
	}
		 	@Column(name = "android_amount")
	public BigDecimal getAndroidAmount() {
		return androidAmount;
	}
	
	
	public void setAndroidAmount(BigDecimal androidAmount) {
		this.androidAmount = androidAmount;
	}
		 	@Column(name = "ios_settlement")
	public BigDecimal getIosSettlement() {
		return iosSettlement;
	}
	
	
	public void setIosSettlement(BigDecimal iosSettlement) {
		this.iosSettlement = iosSettlement;
	}
		 	@Column(name = "android_settlement")
	public BigDecimal getAndroidSettlement() {
		return androidSettlement;
	}
	
	
	public void setAndroidSettlement(BigDecimal androidSettlement) {
		this.androidSettlement = androidSettlement;
	}
			@Column(name = "display")
	public Integer getDisplay() {
		return display;
	}

	public void setDisplay(Integer display) {
		this.display = display;
	}

	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

