package com.ptteng.learn.course.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "task")
public class Task implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1100707670964248576L;


	public static final Integer Lock = 1;
	public static final Integer UnLock = 2;
	public static final Integer status_normal = 1;
	public static final Integer status_freeze = 2;
	public static final Integer task_type_lesson = 1;//课程任务
	public static final Integer task_type_book = 2;//教材任务
	public static final Integer exercise_type_lesson = 3;//课程习题
	public static final Integer exercise_type_book = 4;//教材习题

	public static final Integer Answer_Type_Select = 1;//选择题
	public static final Integer Answer_Type_Fill = 2;//填空
	public static final Integer Answer_Type_Connection = 3;//连线
	public static final Integer Answer_Type_Judgment = 4;//判断



	private  Long id;
	
  	 
    private  String name;
	
  	 
    private  String introduce;
	
  	 
    private  Integer level;
	
  	 
    private  String img;
	
  	 
    private  String hintContent;
	
  	 
    private  Integer hintType;


	private Integer hintStatus;
	
  	 //排序
    private  Integer sort;
	
  	 //单元统计
    private  Integer unitCount=0;
	
  	 //课时
    private  Long periodID;


	private String periodName;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;

	//上下架状态
	private  Integer status=Task.status_normal;

	//任务类型1、课程任务2、教材任务

	public static final Integer lesson = 1;
	public static final Integer book = 2;

	private Integer type;


	private Long lessonId;

	private String lessonName;


	private Long subjectId;


	private String subjectName;

	private Long bookId;


	private String bookName;


	private String bookPress;
//是否启用提示
	private Integer using=1;


	private Integer step=1;


	//用户学习进度
	private Integer progress=0;

	//判断学习状态
	private Integer over=3;



	private Long paperId;

	//习题类型
	private Integer answerType;

	private Integer resolution;


	private String resolutionContent;


	@Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "introduce")
	public String getIntroduce() {
		return introduce;
	}
	
	
	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}
		 	@Column(name = "level")
	public Integer getLevel() {
		return level;
	}
	
	
	public void setLevel(Integer level) {
		this.level = level;
	}
		 	@Column(name = "img")
	public String getImg() {
		return img;
	}
	
	
	public void setImg(String img) {
		this.img = img;
	}
		 	@Column(name = "hint_content")
	public String getHintContent() {
		return hintContent;
	}
	
	
	public void setHintContent(String hintContent) {
		this.hintContent = hintContent;
	}
		 	@Column(name = "hint_type")
	public Integer getHintType() {
		return hintType;
	}
	
	
	public void setHintType(Integer hintType) {
		this.hintType = hintType;
	}
		 	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}
	
	
	public void setSort(Integer sort) {
		this.sort = sort;
	}
		 	@Column(name = "unit_count")
	public Integer getUnitCount() {
		return unitCount;
	}
	
	
	public void setUnitCount(Integer unitCount) {
		this.unitCount = unitCount;
	}
		 	@Column(name = "period_id")
	public Long getPeriodID() {
		return periodID;
	}
	
	
	public void setPeriodID(Long periodID) {
		this.periodID = periodID;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
	@Column(name = "hint_status")
	public Integer getHintStatus() {
		return hintStatus;
	}

	public void setHintStatus(Integer hintStatus) {
		this.hintStatus = hintStatus;
	}
	@Column(name = "type")
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	@Column(name = "answer_type")
	public Integer getAnswerType() {
		return answerType;
	}

	public void setAnswerType(Integer answerType) {
		this.answerType = answerType;
	}

	@Column(name = "resolution")
	public Integer getResolution() {
		return this.resolution;
	}
	public void setResolution(Integer resolution) {
		this.resolution = resolution;
	}
	@Column(name = "resolution_content")
	public String  getResolutionContent() {
		return this.resolutionContent;
	}
	public void setResolutionContent(String resolutionContent) {
		this.resolutionContent = resolutionContent;
	}


	@Column(name = "subject_id")
	public Long getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}
	@Column(name = "lesson_id")
	public Long getLessonId() {
		return lessonId;
	}

	public void setLessonId(Long lessonId) {
		this.lessonId = lessonId;
	}
	@Column(name = "book_id")
	public Long getBookId() {
		return bookId;
	}

	public void setBookId(Long bookId) {
		this.bookId = bookId;
	}
@Transient
	public String getPeriodName() {
		return periodName;
	}

	public void setPeriodName(String periodName) {
		this.periodName = periodName;
	}
	@Transient
	public String getLessonName() {
		return lessonName;
	}

	public void setLessonName(String lessonName) {
		this.lessonName = lessonName;
	}
	@Transient
	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}
	@Transient
	public String getBookName() {
		return bookName;
	}

	public void setBookName(String bookName) {
		this.bookName = bookName;
	}
	@Transient
	public String getBookPress() {
		return bookPress;
	}

	public void setBookPress(String bookPress) {
		this.bookPress = bookPress;
	}
	@Column(name = "user")
	public Integer getUsing() {
		return using;
	}

	public void setUsing(Integer using) {
		this.using = using;
	}
	@Column(name = "step")
	public Integer getStep() {
		return step;
	}

	public void setStep(Integer step) {
		this.step = step;
	}
@Transient
	public Integer getProgress() {
		return progress;
	}

	public void setProgress(Integer progress) {
		this.progress = progress;
	}
	@Transient
	public Integer getOver() {
		return over;
	}

	public void setOver(Integer over) {
		this.over = over;
	}
@Transient
	public Long getPaperId() {
		return paperId;
	}

	public void setPaperId(Long paperId) {
		this.paperId = paperId;
	}
}

