package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.UserFavoriteRelation;
import com.ptteng.learn.course.service.UserFavoriteRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * UserFavoriteRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserFavoriteRelationController {
	private static final Log log = LogFactory.getLog(UserFavoriteRelationController.class);

	@Autowired
	private UserFavoriteRelationService userFavoriteRelationService;


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userFavoriteRelation1 ", method = RequestMethod.GET)
	public String getUserFavoriteRelationIdsByUserIDJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long userID) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userFavoriteRelationService.getUserFavoriteRelationIdsByUserID(userID,start,size);
		log.info("get countUserFavoriteRelationIdsByUserID size is " + ids.size());

			List<UserFavoriteRelation> userFavoriteRelationList = userFavoriteRelationService.getObjectsByIds(ids);
			log.info("get userFavoriteRelation data is " + userFavoriteRelationList.size());

			Integer total = userFavoriteRelationService. countUserFavoriteRelationIdsByUserID(userID);
			log.info("get userFavoriteRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userFavoriteRelationList", userFavoriteRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userFavoriteRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userFavoriteRelation/json/userFavoriteRelationListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/userFavoriteRelation/{id}", method = RequestMethod.GET)
	public String getUserFavoriteRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserFavoriteRelation userFavoriteRelation = userFavoriteRelationService.getObjectById(id);
			log.info("get userFavoriteRelation data is " + userFavoriteRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userFavoriteRelation", userFavoriteRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userFavoriteRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userFavoriteRelation/json/userFavoriteRelationDetailJson";
	}

	@RequestMapping(value = "/a/userFavoriteRelation/{id}", method = RequestMethod.PUT)
	public String updateUserFavoriteRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserFavoriteRelation userFavoriteRelation) throws Exception {
		
		log.info("update userFavoriteRelation : userFavoriteRelation= " + userFavoriteRelation);
		
		try {
			
			userFavoriteRelationService.update(userFavoriteRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userFavoriteRelation", userFavoriteRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userFavoriteRelation error,id is  " + userFavoriteRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userFavoriteRelation", method = RequestMethod.POST)
	public String addUserFavoriteRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserFavoriteRelation userFavoriteRelation) throws Exception {
		
		log.info("update userFavoriteRelation : userFavoriteRelation= " + userFavoriteRelation);
		
		try { 
			userFavoriteRelation.setId(null);

			userFavoriteRelationService.insert(userFavoriteRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userFavoriteRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userFavoriteRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserFavoriteRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userFavoriteRelation : id= " + id);
		try {
			userFavoriteRelationService.delete(id);

			log.info("add userFavoriteRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userFavoriteRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userFavoriteRelation", method = RequestMethod.GET)
	public String getMultiUserFavoriteRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserFavoriteRelation> userFavoriteRelationList = userFavoriteRelationService.getObjectsByIds(idList);
			log.info("get  userFavoriteRelation data is " + userFavoriteRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userFavoriteRelationList.size());

			model.addAttribute("userFavoriteRelationList", userFavoriteRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userFavoriteRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userFavoriteRelation/json/userFavoriteRelationListJson";
	}
	
	
	
	
	
}

