package com.ptteng.course.admin.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.course.util.VideoAndVoiceUtil;
import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.ptteng.learn.course.vo.TaskUnit;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * Task  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TaskController {
	private static final Log log = LogFactory.getLog("task");

	@Autowired
	private TaskService taskService;
	@Autowired
	private UnitService unitService;
	@Autowired
	private LessonService lessonService;
	@Autowired
	private SubjectService subjectService;
	@Autowired
	private BookService bookService;
	@Autowired
	private PeriodService periodService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private BookVersionService bookVersionService;
	@Autowired AnswerService answerService;
	@Autowired ConstantService constantService;
	@Autowired
	private BookSubjectService bookSubjectService;

	/**
	 * 题库搜索
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/question/list", method = RequestMethod.GET)
	public String getQuestionByPeriodIDOrderBySortJsonList(HttpServletRequest request,
														  HttpServletResponse response, ModelMap model, Integer page,
														  Integer size,Integer type,String name,Long subjectId,Long lessonId,Long periodId,Long bookId,Integer level,Integer status,Integer bookPress , Integer noteType, Integer includeCount,Integer answerType , Integer sort) throws Exception {
		log.info("getQuestionByPeriodIDOrderBySortJsonList : type is " +type + ",name is" +name +",subjectId is" + subjectId + ",lessonId  is" + lessonId+"periodId is" + periodId + "bookId is" +bookId +", level" + level +",status is" +status +"bookPress is" +bookPress +"noteType is"+noteType+"includeCount is" +includeCount +"answerType is" +answerType +"sort is"+sort);
		if (type == null) {
			model.addAttribute("code", -5030);
			return "/common/success";
		}
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List <Long> bookIds=null;
			Map<String,Object> param=null;
			String  bookIdList =null;
			if(type == 4) {
				Map<String,Object> params = DynamicUtil.getbookList(subjectId);
				bookIds =  bookService.getIdsByDynamicCondition(Book.class,params, start, size);
				if(bookId !=null){
					List <Book> searchBook = bookService.getObjectsByIds(bookIds);
					for (Book book :searchBook ){
						if(book.getId().equals(bookId)){
							bookIdList=String.valueOf(bookId);
						}
					}
					if(bookIdList == null){
						bookId=Long.valueOf(Integer.MAX_VALUE);
					}
				}else{
					bookIdList=StringUtils.join(bookIds,",");
				}

				 param= DynamicUtil.getQuestBankList(type,name, null, lessonId, periodId, null, level,bookIdList,status,bookId,bookPress,noteType,includeCount,answerType,sort);

//				  for(Book book : books){
//					  Map<String,Object> param= DynamicUtil.getQuestBankList(type,name, book.getSid(), lessonId, periodId, null, level,status,bookId,bookPress,noteType,includeCount,answerType,sort);
//					  List<Long> ids = taskService.getIdsByDynamicCondition(Task.class, param, start, size);
//					  taskListIds.add(ids)
//				  }
			}else{
				 param= DynamicUtil.getQuestBankList(type,name, subjectId, lessonId, periodId, null, level,null,status,bookId,bookPress,noteType,includeCount,answerType,sort);

			}

			List<Long> ids = taskService.getIdsByDynamicCondition(Task.class, param, start, size);
			List<Long> count = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
			log.info("get countTaskIdsByPeriodIDOrderBySort size is " + ids.size());
			if (ids == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			List<Task> taskList = taskService.getObjectsByIds(ids);

			for (Task task : taskList) {
				Long perId=task.getPeriodID();
				Period period = periodService.getObjectById(perId);
				if (period != null) {
					task.setPeriodName(period.getName());
				}
				if (task.getType().equals(Task.task_type_lesson) || task.getType().equals(Task.exercise_type_lesson)) {
					Long leId=task.getLessonId();
					Lesson lesson = lessonService.getObjectById(leId);
					Long subId = task.getSubjectId();
					Subject subject = subjectService.getObjectById(subId);
					if (subject != null) {
						task.setSubjectName(subject.getName());
					}
					log.info(lesson);
					if (lesson != null) {
						task.setLessonName(lesson.getName());
					}
				}
				if (task.getType().equals(Task.task_type_book) || task.getType().equals(Task.exercise_type_book)) {
					Long bookID = task.getBookId();
					Book book = bookService.getObjectById(bookID);
					BookSubject bookSubject = bookSubjectService.getObjectById(book.getSid());
					if (book != null) {
						task.setBookName(book.getName());
						task.setSubjectName(bookSubject.getSubjectName());
						BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());

						if(bookVersion == null){
							log.info("bookVersion : " + book.getPress() + " not exist");
						}else {
							task.setBookPress(bookVersion.getVersionName());
						}
					}
				}
			}
			if (taskList == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			log.info("get task data is " + taskList.size());
			Integer total=count.size();
			log.info("get task count is " + count.size());

			model.addAttribute("code", 0);
			boolean next=false;
			if (taskList.size() + start +1<= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);
			model.addAttribute("taskList", taskList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get task list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/task/json/taskListJson";
	}




	/**
	 * 根据课时搜任务
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/u/task/list ", method = RequestMethod.GET)
	public String getTaskIdsByPeriodIDOrderBySortJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer type,String name,Long subjectId,Long lessonId,Long periodId,Long bookId,Integer level,Integer status,Integer bookPress) throws Exception {

			if (type == null) {
				model.addAttribute("code", -5030);
				return "/common/success";
			}
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String,Object> param= DynamicUtil.getTaskList(type,name, subjectId, lessonId, periodId, null, level,status,bookId,bookPress);
			List<Long> ids = taskService.getIdsByDynamicCondition(Task.class, param, start, size);
			List<Long> count = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
		log.info("get countTaskIdsByPeriodIDOrderBySort size is " + ids.size());
			if (ids == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			List<Task> taskList = taskService.getObjectsByIds(ids);
			log.info(taskList);
			log.info("-============-=-=-=-=---------------------");
			for (Task task : taskList) {
				Long perId=task.getPeriodID();
				Period period = periodService.getObjectById(perId);
				if (period != null) {
					task.setPeriodName(period.getName());
				}
				if (type == 1 || type.equals(Task.exercise_type_lesson)) {
				    Long leId=task.getLessonId();
					Lesson lesson = lessonService.getObjectById(leId);
					Long subId = task.getSubjectId();
					Subject subject = subjectService.getObjectById(subId);
					if (subject != null) {
						task.setSubjectName(subject.getName());
					}
					log.info(lesson);
					if (lesson != null) {
						task.setLessonName(lesson.getName());
					}
				}
				if (type == 2 || type.equals(Task.exercise_type_book)) {
					Long bookID = task.getBookId();
					Book book = bookService.getObjectById(bookID);
					if (book != null) {
						task.setBookName(book.getName());
						BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
						if(bookVersion == null){
							log.info("bookVersion : " + book.getPress() + " not exist");
						}else {
							task.setBookPress(bookVersion.getVersionName());
						}
					}
				}
			}
			if (taskList == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			log.info("get task data is " + taskList.size());
 			Integer total=count.size();
			log.info("get task count is " + count.size());

			model.addAttribute("code", 0);
			boolean next=false;
			if (taskList.size() + start +1<= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);
			model.addAttribute("taskList", taskList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get task list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/task/json/taskListJson";
	}

//
//	@RequestMapping(value = "/a/u/task/list ", method = RequestMethod.GET)
//	public String getTaskJsonList(HttpServletRequest request,
//														  HttpServletResponse response, ModelMap model, Integer page,
//														  Integer size,@PathVariable Long periodID) throws Exception {
//
//
//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//
//		log.info("pageList : page= " + start + " , size=" + size);
//
//		try {
//
//			List<Long> ids= taskService.getTaskIdsByPeriodIDOrderBySort(periodID,start,size);
//			log.info("get countTaskIdsByPeriodIDOrderBySort size is " + ids.size());
//			if (ids == null) {
//				model.addAttribute("code", 2);
//				return "/common/success";
//			}
//			List<Task> taskList = taskService.getObjectsByIds(ids);
//			if (taskList == null) {
//				model.addAttribute("code", 2);
//				return "/common/success";
//			}
//			log.info("get task data is " + taskList.size());
//
//			Integer total = taskService. countTaskIdsByPeriodIDOrderBySort(periodID);
//			log.info("get task count is " + total);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("page", page);
//			model.addAttribute("size", size);
//
//			model.addAttribute("total", total);
//
//			model.addAttribute("taskList", taskList);
//
//		} catch (Throwable t) {
//			t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get task list error,page is  " + start + " , size "
//					+ size);
//			// for test
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/task/json/taskListJson";
//	}

    /**
	 * 获得任务详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
     */

	@RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.GET)
	public String getTaskJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id,Integer page,Integer size)
			throws Exception {

		log.info("get data : id= " + id);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Task task = taskService.getObjectById(id);
			if (task == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			Long perId=task.getPeriodID();
			Period period = periodService.getObjectById(perId);
			task.setPaperId(period.getPaperID());
			if (period != null) {
				task.setPeriodName(period.getName());
			}
			if (task.getType() == 1 || task.getType().equals(Task.exercise_type_lesson) || task.getType().equals(Task.exercise_newType_lesson)) {
				Long leId=task.getLessonId();
				Lesson lesson = lessonService.getObjectById(leId);
				Long subId = task.getSubjectId();
				Subject subject = subjectService.getObjectById(subId);
				if (subject != null) {
					task.setSubjectName(subject.getName());
				}
				log.info(lesson);
				if (lesson != null) {

					task.setLessonName(lesson.getName());
				}
			}
			if (task.getType() == 2 || task.getType().equals(Task.exercise_type_book) || task.getType().equals(Task.exercise_newType_book)) {
				Long bookId = task.getBookId();
				Book book = bookService.getObjectById(bookId);
				BookSubject bookSubject = bookSubjectService.getObjectById(book.getSid());

				if (book != null) {
					task.setBookName(book.getName());
					task.setSubjectName(bookSubject.getSubjectName());
					BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
					if(bookVersion == null){
						log.info("bookVersion : " + book.getPress() + " not exist");
					}else {
						task.setBookPress(bookVersion.getVersionName());
					}
				}
			}
			log.info("get task data is " + task);
			List<Long> untiIds=unitService.getUnitIdsByTaskIDOrderBySort(id, start, size);
			//answer列表
			List<Long> answerIds = answerService.getAnswerIdsByTaskIdOrderByCreateAt(id,start,size);

			if (untiIds.size() <= 0) {
				log.info("unit is null");
			}
			if (answerIds.size() <= 0) {
				log.info("answer is null");
			}
			List<Unit> unitList = unitService.getObjectsByIds(untiIds);
			List<Answer> answerList = answerService.getObjectsByIds(answerIds);
			for (Unit unit : unitList) {
				if(Unit.Unit_Video.equals(unit.getType())){
					String path = unit.getLink();
					String[] urlName =  path.split("\\/");
					Map<String,String> url=VideoAndVoiceUtil.getVideoUrl(urlName[urlName.length - 1]);
					String paths = url.get("path");
					String signs = url.get("sign");
					String ts = url.get("t");
					String domain = url.get("domain");
					String urls = domain + paths + "?sign=" + signs + "&t=" + ts;
					unit.setVideoUrl(urls);
				}
			}
			model.addAttribute("code", 0);

			model.addAttribute("task", task);
			model.addAttribute("unitList", unitList);
			model.addAttribute("answerList", answerList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get task error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/task/json/taskDetailJson";
	}

	/**
	 * 更新任务
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param taskUnit
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.PUT)
	public String updateTaskJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id,@RequestBody TaskUnit taskUnit) throws Exception {
		

		log.info("update task : task= " + taskUnit);
		Task task=taskUnit.getTask();
		List<Unit> unitList=taskUnit.getUnitList();
		List<Answer> answerList = taskUnit.getAnswerList();

		if(DataUtils.isNotNullOrEmpty(task.getNoteType())){
			Constant constant = constantService.getObjectById(Long.valueOf(task.getNoteType()));
			if(constant == null || !constant.getType().equals("dictationMistake")){
				model.addAttribute("code", -5095);
				return "/common/success";
			}
		}

		//任务类型
		Integer taskType = task.getType();
		//是否启用提示
		Integer using = task.getUsing();
		//校验类型是否合法
		if ( taskType == null ||
				( !taskType.equals(Task.task_type_lesson)
						&& !taskType.equals(Task.task_type_book)
						&& !taskType.equals(Task.exercise_type_lesson)
						&& !taskType.equals(Task.exercise_type_book)
						&& !taskType.equals(Task.exercise_newType_book)
						&& !taskType.equals(Task.exercise_newType_lesson)
				)) {
			model.addAttribute("code", -5030);
			return "/common/success";
		}

		if (task.getStep() == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		if (taskType.equals(Task.task_type_lesson) || taskType.equals(Task.exercise_type_lesson) || taskType.equals(Task.exercise_newType_lesson)) {
			if (task.getSubjectId() == null) {
				model.addAttribute("code", -5013);
				return "/common/success";
			}
			if (task.getLessonId() == null) {
				model.addAttribute("code", -5003);
				return "/common/success";
			}
			if (subjectService.getObjectById(task.getSubjectId()) == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			if (lessonService.getObjectById(task.getLessonId()) == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
		}
		if(taskType.equals(Task.task_type_book) || taskType.equals(Task.exercise_type_book) ||  taskType.equals(Task.exercise_newType_book)){
			if (task.getBookId()==null) {
				model.addAttribute("code", -5039);
				return "/common/success";
			}
			if (bookService.getObjectById(task.getBookId()) == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
		}

        //类型为习题时，answer为必填
        if ((taskType.equals(Task.exercise_type_lesson) || taskType.equals(Task.exercise_type_book)) && task.getAnswerType() == null){
            model.addAttribute("code", -5094);
            return "/common/success";
        }

        //任务名校验
        if (task.getName() == null) {
            model.addAttribute("code", -5005);
            return "/common/success";
        }

		if (using == null) {
			model.addAttribute("code", -5050);
			return "/common/success";
		}
//		if (task.getHintType()!=1&&task.getHintType()!=2) {
//			model.addAttribute("code", -5021);
//			return "/common/success";
//		}
//		if (task.getHintStatus() != 1 && task.getHintStatus() != 2) {
//			model.addAttribute("code", -5022);
//			return "/common/success";
//		}
		if (unitList == null || unitList.isEmpty()) {
			model.addAttribute("code", -5023);
			return "/common/success";
		}
		try {
//			List<Long> idList=taskService.getTaskIdsByName(task.getName());
//
//
//				if (idList != null ) {
//					if (idList.size()>0) {
//						log.info("name is exit");
//						model.addAttribute("code", -5007);
//						return "/common/success";
//					}
//				}
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			Task oldTask = taskService.getObjectById(id);
			task.setId(id);
			task.setCreateBy(oldTask.getCreateBy());
			task.setUpdateBy(Long.parseLong(userId));
			task.setLevel(oldTask.getLevel());
			task.setSort(oldTask.getSort());
			task.setCreateAt(oldTask.getCreateAt());

			//校验习题类型
			if ((task.getType().equals(Task.exercise_type_lesson) || task.getType().equals(Task.exercise_type_book)) && task.getAnswerType() == null){
				model.addAttribute("code", -5094);
				return "/common/success";
			}

			log.info("update task : " + task);
			taskService.update(task);
			List<Long> unitIds=unitService.getUnitIdsByTaskIDOrderBySort(task.getId(), 0, Integer.MAX_VALUE);
			unitService.deleteList(Unit.class,unitIds);
			Long taskId = task.getId();
			int i=1;
			for (Unit unit : unitList) {
				unit.setTaskID(taskId);

				unit.setSort(i);
				unitService.insert(unit);
				log.info("insert unit sort is"+i);
				i++;
			}

			//task为习题类型-存answer 删除原有答案，重新插入新值;
			if (task.getType().equals(Task.exercise_type_lesson) || task.getType().equals(Task.exercise_type_book)) {
				List<Long> answerIds = answerService.getAnswerIdsByTaskIdOrderByCreateAt(task.getId(),0,Integer.MAX_VALUE);
				answerService.deleteList(Answer.class,answerIds);
				for (Answer answer : answerList){
					answer.setTaskId(taskId);
					Long answerId=answerService.insert(answer);
					log.info("update answer success , id is " + answerId);

				}
			}

			model.addAttribute("code", 0);

			model.addAttribute("task", task);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update task error,id is  " + task.getId());
			model.addAttribute("code", -6003);

		}

		return "/common/success";
	}

	/**
	 * 新增任务
	 * @param request
	 * @param response
	 * @param model
	 * @param taskUnit
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/task", method = RequestMethod.POST)
	public String addTaskJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @RequestBody TaskUnit taskUnit) throws Exception {
		
		log.info("update task : task= " + taskUnit);

		Task task=taskUnit.getTask();
		task.setIncludeCount(0);
		List<Unit> unitList=taskUnit.getUnitList();
		List<Answer> answerList = taskUnit.getAnswerList();

		if(DataUtils.isNotNullOrEmpty(task.getNoteType())){
			Constant constant = constantService.getObjectById(Long.valueOf(task.getNoteType()));
			if(constant == null || !constant.getType().equals("dictationMistake")){
				model.addAttribute("code", -5095);
				return "/common/success";
			}
		}


		//任务、习题类型
		Integer taskType = task.getType();
		//是否启用提示
		Integer using = task.getUsing();
		//校验类型是否合法
		if ( taskType == null ||
				( !taskType.equals(Task.task_type_lesson)
				&& !taskType.equals(Task.task_type_book)
				&& !taskType.equals(Task.exercise_type_lesson)
				&& !taskType.equals(Task.exercise_type_book)
				&& !taskType.equals(Task.exercise_newType_book)
				&& !taskType.equals(Task.exercise_newType_lesson)
				)) {
			model.addAttribute("code", -5030);
			return "/common/success";
		}

		if (using == null) {
			model.addAttribute("code", -5050);
			return "/common/success";
		}
		//1为启用提示
		if(using==1) {
			if (task.getHintType() != 1 && task.getHintType() != 2) {
				model.addAttribute("code", -5021);
				return "/common/success";
			}
			if (task.getHintStatus() == null) {
				model.addAttribute("code", -5022);
				return "/common/success";
			}
			if (task.getHintStatus() != 1 && task.getHintStatus() != 2) {
				model.addAttribute("code", -5022);
				return "/common/success";
			}
		}
		//步骤不能为空
		if (task.getStep() == null) {
			model.addAttribute("code", -1000);
			return "/common/success";
		}

		//课程任务 OR 课程习题
		if ( taskType.equals(Task.task_type_lesson)|| taskType.equals(Task.exercise_type_lesson) || taskType.equals(Task.exercise_newType_lesson) ) {
			if (task.getSubjectId() == null) {
				model.addAttribute("code", -5020);
				return "/common/success";
			}
			if (task.getLessonId() == null) {
				model.addAttribute("code", -5020);
				return "/common/success";
			}
			if (subjectService.getObjectById(task.getSubjectId()) == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
			if (lessonService.getObjectById(task.getLessonId()) == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
		}

		//教材任务 OR 教材习题
		if(taskType.equals(Task.task_type_book) || task.getType().equals(Task.exercise_type_book) || task.getType().equals(Task.exercise_newType_book) ){
			if (task.getBookId()==null) {
				model.addAttribute("code", -5039);
				return "/common/success";
			}
			if (bookService.getObjectById(task.getBookId()) == null) {
				model.addAttribute("code", 2);
				return "/common/success";
			}
		}

		//类型为习题时，answer为必填
		if ((taskType.equals(Task.exercise_type_lesson) && task.getAnswerType() == null || taskType.equals(Task.exercise_type_book)) && task.getAnswerType() == null){
			model.addAttribute("code", -5094);
			return "/common/success";
		}

		//任务名校验
		if ( task.getName() == null) {
			model.addAttribute("code", -5005);
			return "/common/success";
		}

		if (unitList == null || unitList.isEmpty()) {
			model.addAttribute("code", -5023);
			return "/common/success";
		}

		try {
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

			Integer sort = getMaxSort(task.getPeriodID());
			task.setSort(sort);
			task.setCreateBy(Long.parseLong(userId));
			if (task.getSort() == null) {
				model.addAttribute("code", -5075);
				return "/common/success";
			}

			Long lessonId=task.getLessonId();
			Lesson lesson = lessonService.getObjectById(lessonId);
			if (lesson!=null) {
				task.setLevel(lesson.getLevel());
			}else {
				Long bookId = task.getBookId();
				Book book = bookService.getObjectById(bookId);
				if (book != null) {
					task.setLevel(book.getGrade());
				}
			}


			Long taskId =taskService.insert(task);
			int i=1;

			for (Unit unit : unitList) {
				unit.setTaskID(taskId);

				unit.setSort(i);
				unitService.insert(unit);
				log.info("insert unit sort is"+i);
				i++;
			}
			//task为习题类型-存answer
			if (task.getType().equals(Task.exercise_type_lesson) || task.getType().equals(Task.exercise_type_book)) {
				for (Answer answer : answerList){
					answer.setTaskId(taskId);
					Long answerId = answerService.insert(answer);
					log.info("insert answer success , id is " + answerId);
				}
			}


			model.addAttribute("code", 0);
			Long periodId=task.getPeriodID();
			Period period = periodService.getObjectById(periodId);
			period.setTaskCount(period.getTaskCount()+1);
			periodService.update(period);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add task error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * 删除任务
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.DELETE)
	public String deleteTaskJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete task : id= " + id);
		try {
			Task task = taskService.getObjectById(id);
			Map<String, Object> param = DynamicUtil.getTaskList(null, null, null, null, task.getPeriodID(), null, null, null, null,null);
			List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
			if (taskIds.size() > 1) {
				taskService.delete(id);
				List<Task> taskList = taskService.getObjectsByIds(taskIds);
				List<Task> newTaskList = new LinkedList<>();
				int i = 1;
				for (Task task1 : taskList) {
					if (task1 != null) {
						task1.setSort(i);
						i++;
						newTaskList.add(task1);
					}
				}
				taskService.updateList(newTaskList);
			} else {
				Period period = periodService.getObjectById(task.getPeriodID());
				if (period.getStatus().equals(Period.status_normal)) {
					model.addAttribute("code", -5065);
					return "/common/success";
				} else {
					taskService.delete(id);
				}
			}
			log.info("add task success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete task error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	/**
	 * 排序课程
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/task/sort", method = RequestMethod.POST)
	public String sort(HttpServletRequest request,
					   HttpServletResponse response, ModelMap model,
					   @RequestBody List<Long> ids) throws Exception {

		log.info("sort lesson : uids= " + ids);

		try {
			List<Task> taskList = taskService
					.getObjectsByIds(ids);

			int index = 1;
			for (Task task : taskList) {
				task.setSort(index);
				index = index +1;
			}
			this.taskService.updateList(taskList);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("sort task error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	/**
	 * 动态获得url
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/task/url", method = RequestMethod.GET)
	public String getUrl(HttpServletRequest request,
					   HttpServletResponse response, ModelMap model,
					   String path) throws Exception {

		if (path == null) {
			model.addAttribute("code", -8004);
			return "/common/success";
		}

		try {

			String[] urlName =  path.split("\\/");
			Map<String,String> url= VideoAndVoiceUtil.getVideoUrl(urlName[urlName.length - 1]);
			String paths = url.get("path");
			String signs = url.get("sign");
			String ts = url.get("t");
			String domain = url.get("domain");
			String urls = domain + paths + "?sign=" + signs + "&t=" + ts;
			model.addAttribute("url", urls);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("sort task error ");
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/task/json/url";
	}
	private Integer getMaxSort(Long periodId) throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getTaskList(null,null,null,null,periodId,null,null,null,null,null);
		List<Long> maxs = this.taskService.getIdsByDynamicCondition(
				Task.class, param, 0, Integer.MAX_VALUE);
		Integer max = 0;
		if (CollectionUtils.isEmpty(maxs)) {
			log.info("first order ");

		} else {
			Long maxID = maxs.get(maxs.size()-1);
			max = this.taskService.getObjectById(maxID).getSort();
			log.info("quiz max order is " + max);
		}
		return max+1;
	}



	
	
	
}

