package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.Progress;
import com.ptteng.learn.course.service.ProgressService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * Progress  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProgressController {
	private static final Log log = LogFactory.getLog(ProgressController.class);

	@Autowired
	private ProgressService progressService;



	    		
			
    /**
	 * 
	 * @param 
	 * @return
	 */
	
		@RequestMapping(value = "/a/progress1 ", method = RequestMethod.GET)
	public String getProgressIdsByUserIDAndTypeOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long userID,Integer type) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= progressService.getProgressIdsByUserIDAndTypeOrderByCreateAt(userID,type,start,size);
		log.info("get countProgressIdsByUserIDAndTypeOrderByCreateAt size is " + ids.size());

			List<Progress> progressList = progressService.getObjectsByIds(ids);
			log.info("get progress data is " + progressList.size());

			Integer total = progressService. countProgressIdsByUserIDAndTypeOrderByCreateAt(userID,type);
			log.info("get progress count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("progressList", progressList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get progress list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/progress/json/progressListJson";
	}

	
	
		
			
			
//    /**
//	 *
//	 * @param
//	 * @return
//	 */
//
//		@RequestMapping(value = "/a/progress2 ", method = RequestMethod.GET)
//	public String getProgressIdsByUserIDAndTargetIDAndTypeJsonList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Integer page,
//			Integer size,Long userID,Long targetID,Integer type) throws Exception {
//
//
//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//
//		log.info("pageList : page= " + start + " , size=" + size);
//
//		try {
//
//			List<Long> ids= progressService.getProgressIdsByUserIDAndTargetIDAndType(userID,targetID,type);
//		log.info("get countProgressIdsByUserIDAndTargetIDAndType size is " + ids.size());
//
//			List<Progress> progressList = progressService.getObjectsByIds(ids);
//			log.info("get progress data is " + progressList.size());
//
//			Integer total = progressService. countProgressIdsByUserIDAndTargetIDAndType(userID,targetID,type);
//			log.info("get progress count is " + total);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("page", page);
//			model.addAttribute("size", size);
//
//			model.addAttribute("total", total);
//
//			model.addAttribute("progressList", progressList);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get progress list error,page is  " + start + " , size "
//					+ size);
//			// for test
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/progress/json/progressListJson";
//	}

	
	
		
	
	

	@RequestMapping(value = "/a/progress/{id}", method = RequestMethod.GET)
	public String getProgressJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Progress progress = progressService.getObjectById(id);
			log.info("get progress data is " + progress);

			model.addAttribute("code", 0);

			model.addAttribute("progress", progress);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get progress error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/progress/json/progressDetailJson";
	}

	@RequestMapping(value = "/a/progress/{id}", method = RequestMethod.PUT)
	public String updateProgressJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Progress progress) throws Exception {
		
		log.info("update progress : progress= " + progress);
		
		try {
			
			progressService.update(progress);

			model.addAttribute("code", 0);

			model.addAttribute("progress", progress);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update progress error,id is  " + progress.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/progress", method = RequestMethod.POST)
	public String addProgressJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Progress progress) throws Exception {
		
		log.info("update progress : progress= " + progress);
		
		try { 
			progress.setId(null);

			progressService.insert(progress);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add progress error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/progress/{id}", method = RequestMethod.DELETE)
	public String deleteProgressJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete progress : id= " + id);
		try {
			progressService.delete(id);

			log.info("add progress success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete progress error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/progress", method = RequestMethod.GET)
	public String getMultiProgressJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Progress> progressList = progressService.getObjectsByIds(idList);
			log.info("get  progress data is " + progressList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",progressList.size());

			model.addAttribute("progressList", progressList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get progress error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/progress/json/progressListJson";
	}
	
	
	
	
	
}

