package com.ptteng.course.admin.controller;

import java.math.BigDecimal;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static com.ptteng.course.util.Constants.DIALOGUE;
import static com.ptteng.course.util.Constants.DownLine;
import static com.ptteng.course.util.Constants.OnLine;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Period  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class PeriodController {
    private static final Log log = LogFactory.getLog("period");

    @Autowired
    private PeriodService periodService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private BookService bookService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private BookVersionService bookVersionService;
    @Autowired
    private BookUnitService bookUnitService;

    @RequestMapping(value = "/a/u/random", method = RequestMethod.GET)
    public String getPeriod(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info("get random begin");
        Random random = new Random();
        Integer randoms = random.nextInt(6);
        while (randoms == 0) {
            randoms = random.nextInt(6);
        }
        model.addAttribute("random", randoms);
        model.addAttribute("code", 0);

        return "/learn-course-service/period/json/random";
    }

//
//
//
//		@RequestMapping(value = "/a/u/period1 ", method = RequestMethod.GET)
//	public String getPeriodIdsByLessonIDOrderBySortJsonList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Integer page,
//			Integer size,Long lessonID,Integer type) throws Exception {
//
//
//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//
//		log.info("pageList : page= " + start + " , size=" + size);
//
//		try {
//
//			List<Long> ids= periodService.getPeriodIdsByLessonIDOrderBySort(lessonID,start,size);
//		log.info("get countPeriodIdsByLessonIDOrderBySort size is " + ids.size());
//
//			List<Period> periodList = periodService.getObjectsByIds(ids);
//			log.info("get period data is " + periodList.size());
//
//			Integer total = periodService. countPeriodIdsByLessonIDOrderBySort(lessonID);
//			log.info("get period count is " + total);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("page", page);
//			model.addAttribute("size", size);
//
//			model.addAttribute("total", total);
//
//			model.addAttribute("periodList", periodList);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get period list error,page is  " + start + " , size "
//					+ size);
//			// for test
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/period/json/periodListJson";
//	}


    /**
     * 查看课时详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/{id}", method = RequestMethod.GET)
    public String getPeriodJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        if (id == null) {
            model.addAttribute("code", -5001);
            return "/common/success";
        }
        log.info("get data : id= " + id);
        try {

            Period period = periodService.getObjectById(id);
            if(period == null){
                log.info("period " + id + " not exist");
                model.addAttribute("code", -5002);
                return "/common/success";
            }
            if (period.getType() == 1) {
                Long lessonId = period.getLessonID();
                Long subjectId = period.getSubjectID();
                Lesson lesson = lessonService.getObjectById(lessonId);
                Subject subject = subjectService.getObjectById(subjectId);
                if (lesson != null) {
                    period.setLessonName(lesson.getName());
                }
                if (subject != null) {
                    period.setSubjectName(subject.getName());
                    period.setGradeType(subject.getGradeType());
                }
            } else {
                Long bookId = period.getBookID();
                Book book = bookService.getObjectById(bookId);
                period.setBookName(book.getName());
                BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
                if (bookVersion == null) {
                    log.info("bookVersion : " + book.getPress() + " not exist");
                } else {
                    period.setBookPress(bookVersion.getVersionName());
                }
            }
            if (period == null) {
                model.addAttribute("code", -5002);
                return "/common/success";
            }
            log.info("get period data is " + period);

            model.addAttribute("code", 0);
            model.addAttribute("period", period);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get period error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/periodDetailJson";
    }

    /**
     * 更新课时
     *
     * @param request
     * @param response
     * @param model
     * @param period
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/{id}", method = RequestMethod.PUT)
    public String updatePeriodJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Period period, @PathVariable Long id) throws Exception {

        log.info("update period : period= " + period);
        if (period.getName() == null) {
            model.addAttribute("code", -5005);
            return "/common/success";
        }
        if (period.getLocked() == 1) {
            if (period.getMoneyPrice() == null || StringUtil.isEmpty(period.getMoneyPrice().toString())) {
                model.addAttribute("code", -5061);
                return "/common/success";
            }
            if (period.getStarPrice() == null || StringUtil.isEmpty(period.getStarPrice().toString())) {
                model.addAttribute("code", -5062);
                return "/common/success";
            }
            if (period.getLocktype() == null || StringUtil.isEmpty(period.getLocktype().toString())) {
                log.info(period.getLocktype());
                log.info("=====================================================");
                model.addAttribute("code", -5093);
                return "/common/success";
            }
        } else {
            period.setMoneyPrice(new BigDecimal(0));
            period.setStarPrice(0);
        }
        log.info("=========================" + period.getType());
        if (period.getType() == 1) {
            if (period.getSubjectID() == null) {
                model.addAttribute("code", -5013);
                return "/common/success";
            }
            if (period.getLessonID() == null) {
                model.addAttribute("code", -5012);
                return "/common/success";
            }
            Lesson lesson = lessonService.getObjectById(period.getLessonID());
//			if (lesson.getLocked().equals(Lesson.Lock)) {
//				if (!period.getLocked().equals(Period.Lock)) {
//					model.addAttribute("code", -5074);
//					return "/common/success";
//				}
//			}
        } else {
            if (period.getUnitId() == null) {
                model.addAttribute("code", -3205);
                return "/common/success";
            }else {
                BookUnit bookUnit = bookUnitService.getObjectById(period.getUnitId());
                if(bookUnit == null){
                    log.info("unit : " + period.getUnitId() + " not exist");
                    model.addAttribute("code", -3200);
                    return "/common/success";
                }else {
                    period.setBookID(bookUnit.getBookId());
                }
            }
        }
        if (period.getIntroduce() == null) {
            model.addAttribute("code", -5004);
            return "/common/success";
        }
        if (period.getStar() == null) {
            model.addAttribute("code", -5015);
            return "/common/success";
        }
        if (period.getType() != 1 && period.getType() != 2) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        if (null == period.getStarDisplay()) {
            model.addAttribute("code", -5078);
            return "/common/success";
        }
        if (Lesson.STAR_DISPLAY.equals(period.getStarDisplay())
                && null == period.getStarLevel()) {
            model.addAttribute("code", -5079);
            return "/common/success";
        }
        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            period.setUpdateBy(Long.parseLong(userId));
            Period oldPeriod = periodService.getObjectById(id);
            period.setCreateBy(oldPeriod.getCreateBy());
            period.setId(id);

            if (period.getType() == 1) {
                if (oldPeriod.getName().equals(period.getName())) {
                    log.info("name is not change");
                } else {
                    List<Long> periodids = periodService.getPeriodIdsByLessonIDOrderBySort(period.getLessonID(), 0, Integer.MAX_VALUE);
                    List<Period> periodlist = periodService.getObjectsByIds(periodids);
                    for (Period period1 : periodlist) {
                        if (period.getName().equals(period1.getName())) {
                            model.addAttribute("code", -5007);
                            return "/common/success";
                        }
                    }
                }
                Subject subject = subjectService.getObjectById(period.getSubjectID());
                if (subject == null) {
                    model.addAttribute("code", -5042);
                    return "/common/success";
                }
                Lesson lesson = lessonService.getObjectById(period.getLessonID());
                if (lesson == null) {
                    model.addAttribute("code", -5043);
                    return "/common/success";
                }
            } else {
                Book book = bookService.getObjectById(period.getBookID());
                if (oldPeriod.getName().equals(period.getName())) {
                    log.info("name is not change");
                } else {
                    List<Long> periodids = periodService.getPeriodIdsByBookIdOrderBySort(period.getBookID(), 0, Integer.MAX_VALUE);
                    List<Period> periodlist = periodService.getObjectsByIds(periodids);
                    for (Period period1 : periodlist) {
                        if (period.getName().equals(period1.getName())) {
                            model.addAttribute("code", -5007);
                            return "/common/success";
                        }
                    }
                }
                if (book == null) {
                    model.addAttribute("code", -5044);
                    return "/common/success";
                }
            }
            if (DataUtils.isNullOrEmpty(period.getStarDisplay())) {
                period.setStarDisplay(0);
            }
            if (DataUtils.isNullOrEmpty(period.getStarLevel())) {
                period.setStarLevel(0);
            }
            log.info(period);
            log.info("-=-=-=-=-==--=-==-=-==-=--=-=-=-=-==-=-=-=-=--=---=-==-=--==--=-");
            periodService.update(period);
            //如果编辑的为上架的课程则计算一次课程的lock值
            if (period.getType() == 1) {
                if (period.getStatus().equals(Period.status_normal)) {
                    Map<String, Object> periodParams = null;
                    List<Long> lessonPeriodIdsList = null;
                    List<Period> lessonPeriodList = null;
                    periodParams = DynamicUtil.getPeriodList(null, null, period.getLessonID(), null, null, null, null, Period.status_normal, null);
                    lessonPeriodIdsList = periodService.getIdsByDynamicCondition(Period.class, periodParams, 0, Integer.MAX_VALUE);
                    lessonPeriodList = periodService.getObjectsByIds(lessonPeriodIdsList);
                    Lesson lesson = lessonService.getObjectById(period.getLessonID());
                    lesson.setLocked(Lesson.Lock);
                    for (Period period1 : lessonPeriodList) {
                        if (period1.getLocked().equals(Period.UnLock)) {
                            lesson.setLocked(Lesson.UnLock);
                        }
                    }
                    lessonService.update(lesson);
                }
            }

            model.addAttribute("code", 0);

            model.addAttribute("period", period);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update period error,id is  " + period.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 新增课时
     *
     * @param request
     * @param response
     * @param model
     * @param period
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period", method = RequestMethod.POST)
    public String addPeriodJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Period period) throws Exception {

        log.info("update period : period= " + period);
        if (period.getName() == null) {
            model.addAttribute("code", -5005);
            return "/common/success";
        }
        if (period.getLocked() == 1) {
            if (period.getMoneyPrice() == null || StringUtil.isEmpty(period.getMoneyPrice().toString())) {
                model.addAttribute("code", -5061);
                return "/common/success";
            }
            if (period.getStarPrice() == null || StringUtil.isEmpty(period.getStarPrice().toString())) {
                model.addAttribute("code", -5062);
                return "/common/success";
            }
            if(period.getLocktype() == null || StringUtil.isEmpty(period.getLocktype().toString())) {
                log.info(period.getLocktype());
                model.addAttribute("code", -5093);
                return "/common/success";
            }
        } else {
            period.setMoneyPrice(new BigDecimal(0));
            period.setStarPrice(0);
        }

        if (period.getType() == 1) {
            if (period.getSubjectID() == null) {
                model.addAttribute("code", -5013);
                return "/common/success";
            }
            if (period.getLessonID() == null) {
                model.addAttribute("code", -5012);
                return "/common/success";
            }
            Lesson lesson = lessonService.getObjectById(period.getLessonID());
            if (lesson.getLocked().equals(Lesson.Lock)) {
                if (!period.getLocked().equals(Period.Lock)) {
                    model.addAttribute("code", -5074);
                    return "/common/success";
                }
            }
        } else {
            if (period.getUnitId() == null) {
                model.addAttribute("code", -3205);
                return "/common/success";
            }else {
                BookUnit bookUnit = bookUnitService.getObjectById(period.getUnitId());
                if(bookUnit == null){
                    log.info("unit : " + period.getUnitId() + " not exist");
                    model.addAttribute("code", -3200);
                    return "/common/success";
                }else {
                    period.setBookID(bookUnit.getBookId());
                }
            }
        }
        if (period.getIntroduce() == null) {
            model.addAttribute("code", -5004);
            return "/common/success";
        }
        if (period.getStar() == null) {
            model.addAttribute("code", -5015);
            return "/common/success";
        }
        if (period.getType() != 1 && period.getType() != 2) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        if (null == period.getStarDisplay()) {
            model.addAttribute("code", -5078);
            return "/common/success";
        }
        if (Lesson.STAR_DISPLAY.equals(period.getStarDisplay())
                && null == period.getStarLevel()) {
            model.addAttribute("code", -5079);
            return "/common/success";
        }
        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            period.setCreateBy(Long.parseLong(userId));
            period.setId(null);
            if (period.getType() == 1) {
                Subject subject = subjectService.getObjectById(period.getSubjectID());
                List<Long> periodids = periodService.getPeriodIdsByLessonIDOrderBySort(period.getLessonID(), 0, Integer.MAX_VALUE);
                List<Period> periodlist = periodService.getObjectsByIds(periodids);
                for (Period period1 : periodlist) {
                    if (period.getName().equals(period1.getName())) {
                        model.addAttribute("code", -5007);
                        return "/common/success";
                    }
                }
                if (subject == null) {
                    model.addAttribute("code", -5042);
                    return "/common/success";
                }
                period.setLevel(subject.getGradeName());
                Lesson lesson = lessonService.getObjectById(period.getLessonID());
                if (lesson == null) {
                    model.addAttribute("code", -5043);
                    return "/common/success";
                }
                period.setLevel(lesson.getLevel());
            } else {


                List<Long> periodids = periodService.getPeriodIdsByBookIdOrderBySort(period.getBookID(), 0, Integer.MAX_VALUE);
                List<Period> periodlist = periodService.getObjectsByIds(periodids);
                for (Period period1 : periodlist) {
                    if (period.getName().equals(period1.getName())) {
                        model.addAttribute("code", -5007);
                        return "/common/success";
                    }
                }
                Book book = bookService.getObjectById(period.getBookID());
                if (book == null) {
                    model.addAttribute("code", -5044);
                    return "/common/success";
                }
                period.setLevel(book.getGrade());
            }
//			List<Long> ids=periodService.getPeriodIdsByName(period.getName());
//			if (ids.size() > 0) {
//				model.addAttribute("code", -5007);
//				return "/common/success";
//			}
//			if (period.getType() == 1) {
//				Long lessonId = period.getLessonID();
//				Lesson lesson = lessonService.getObjectById(lessonId);
//				lesson.setPeriodCount(lesson.getPeriodCount()+1);
//				lessonService.update(lesson);
//			}else {
//				Long bookId = period.getBookID();
//				Book book = bookService.getObjectById(bookId);
//				book.setPeriodCount(book.getPeriodCount()+1);
//				bookService.update(book);
//			}
            Integer sort = getMaxSort(period.getLessonID(), period.getLevel());
            period.setSort(sort);
            if (DataUtils.isNullOrEmpty(period.getStarDisplay())) {
                period.setStarDisplay(0);
            }
            if (DataUtils.isNullOrEmpty(period.getStarLevel())) {
                period.setStarLevel(0);
            }
            periodService.insert(period);

//			if (period.getType() == 1) {
//				Map<String, Object> periodParams = null;
//				List<Long> lessonPeriodIdsList = null;
//				List<Period> lessonPeriodList = null;
//				periodParams = DynamicUtil.getPeriodList(null, null, period.getLessonID(), null, null, null, Period.status_normal, null);
//				lessonPeriodIdsList = periodService.getIdsByDynamicCondition(Period.class, periodParams, 0, Integer.MAX_VALUE);
//				lessonPeriodList = periodService.getObjectsByIds(lessonPeriodIdsList);
//				Lesson lesson = lessonService.getObjectById(period.getLessonID());
//				lesson.setLocked(Lesson.Lock);
//				for (Period period1 : lessonPeriodList) {
//					if (period1.getLocked().equals(Period.UnLock)) {
//						lesson.setLocked(Lesson.UnLock);
//					}
//				}
//				lessonService.update(lesson);
//			}

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add period error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 上下架课时
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/updown/{id}", method = RequestMethod.PUT)
    public String deletePeriodJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete period : id= " + id);
        try {
            Period period = periodService.getObjectById(id);
            if (period == null) {
                model.addAttribute("code", 2);
                return "/data/json";
            }else {
                log.info("period : " + period);
            }
            Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, id, null, null, null, null, null);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
            List<Task> taskList = taskService.getObjectsByIds(taskIds);
            Map<String, Object> para = null;
            if (period.getStatus() == 1) {
                period.setStatus(DownLine);

                log.info("downline lesson success");
                if (Period.Lesson.equals(period.getType())) {
                    log.info("period type : " + period.getType() + " , lesson period");
                    para = DynamicUtil.getPeriodList(null, null, period.getLessonID(), null, Period.Lesson, null, null, Period.status_normal, null);
                    List<Long> periods = periodService.getIdsByDynamicCondition(Period.class, para, 0, Integer.MAX_VALUE);
                    if (periods.size() < 2) {
                        model.addAttribute("code", -5066);
                        return "/common/success";
                    }
                    Long lessonId = period.getLessonID();
                    Lesson lesson = lessonService.getObjectById(lessonId);
                    lesson.setPeriodCount(lesson.getPeriodCount() - 1);
                    if (period.getPaperID() != null) {
                        lesson.setPaperCount(lesson.getPaperCount() - 1);
                    }
                    lessonService.update(lesson);
                } else {
                    log.info("period type : " + period.getType() + " , book period");
                    Long unitId = period.getUnitId();
                    Long bookId = period.getBookID();
                    para = DynamicUtil.getPeriodList(null, null, null, null, Period.Book, null, unitId, Period.status_normal, null);
                    List<Long> periods = periodService.getIdsByDynamicCondition(Period.class, para, 0, Integer.MAX_VALUE);
                    log.info("periods : " + periods);
                    if (periods.size() < 2) {
                        model.addAttribute("code", -5090);
                        return "/common/success";
                    }
                    Book book = bookService.getObjectById(bookId);
                    book.setPeriodCount(book.getPeriodCount() - 1);
                    if (period.getPaperID() != null) {
                        book.setPaperCount(book.getPaperCount() - 1);
                    }
                    bookService.update(book);
                }
                for (Task task : taskList) {
                    task.setStatus(DownLine);
                    taskService.update(task);
                }
                model.addAttribute("code", 6);
                //将课时置于排序末尾
                period.setSort(10086);
            } else {
                taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(id, 0, Integer.MAX_VALUE);
                if (taskIds == null || taskIds.size() < 1) {
                    model.addAttribute("code", -5056);
                    return "/common/success";
                }
                if (period.getType() == 1) {
                    Lesson lesson = lessonService.getObjectById(period.getLessonID());
                    if (lesson != null) {
                        if (lesson.getStatus().equals(Lesson.status_freeze)) {
                            model.addAttribute("code", -5072);
                            return "/common/success";
                        }
                    }
                } else {
                    Book book = bookService.getObjectById(period.getBookID());
                    if (book != null) {
                        if (book.getStatus().equals(Lesson.status_freeze)) {
                            model.addAttribute("code", -5073);
                            return "/common/success";
                        }
                    }
                }
                period.setStatus(OnLine);
                log.info("online lesson success");
                for (Task task : taskList) {
                    task.setStatus(OnLine);
                    taskService.update(task);
                }
                period.setTaskCount(taskList.size());
                model.addAttribute("code", 5);
                if (period.getType() == 1) {
                    Long lessonId = period.getLessonID();
                    Lesson lesson = lessonService.getObjectById(lessonId);
                    lesson.setPeriodCount(lesson.getPeriodCount() + 1);
                    if (period.getPaperID() != null) {
                        lesson.setPaperCount(lesson.getPaperCount() + 1);
                    }
                    lessonService.update(lesson);
                } else {
                    Long bookId = period.getBookID();
                    Book book = bookService.getObjectById(bookId);
                    book.setPeriodCount(book.getPeriodCount() + 1);
                    if (period.getPaperID() != null) {
                        book.setPaperCount(book.getPaperCount() + 1);
                    }
                    bookService.update(book);
                }
            }
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            period.setUpdateBy(Long.parseLong(userId));
            periodService.update(period);

            if (period.getType() == 1) {
                Map<String, Object> periodParams = null;
                List<Long> lessonPeriodIdsList = null;
                List<Period> lessonPeriodList = null;
                periodParams = DynamicUtil.getPeriodList(null, null, period.getLessonID(), null, null, null, null, Period.status_normal, null);
                lessonPeriodIdsList = periodService.getIdsByDynamicCondition(Period.class, periodParams, 0, Integer.MAX_VALUE);
                lessonPeriodList = periodService.getObjectsByIds(lessonPeriodIdsList);
                Lesson lesson = lessonService.getObjectById(period.getLessonID());
                lesson.setLocked(Lesson.Lock);
                for (Period period1 : lessonPeriodList) {
                    if (period1.getLocked().equals(Period.UnLock)) {
                        lesson.setLocked(Lesson.UnLock);
                    }
                }
                lessonService.update(lesson);
            }

            Map<String, Object> param = null;
            List<Long> periodIds = null;
            Period sortPeriod = new Period();
            if (period.getType() == 1) {
                param = DynamicUtil.getPeriodList(null, null, period.getLessonID(), null, period.getType(), null, null, Period.status_normal, null);

            } else {
                param = DynamicUtil.getPeriodList(null, null, null, null, period.getType(), null, period.getUnitId(), Period.status_normal, null);
            }
            periodIds = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);

            int index = 1;
            if (periodIds != null && periodIds.size() > 0) {
                for (Long sortId : periodIds) {
                    sortPeriod = periodService.getObjectById(sortId);
                    if (sortPeriod != null) {
                        sortPeriod.setSort(index);
                        periodService.update(sortPeriod);
                        index++;
                    }
                }
            }

            log.info("add period success");


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete period error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/common/success";
    }

    /**
     * 根据条件搜索period列表
     *
     * @param request
     * @param response
     * @param model
     * @param name
     * @param lessonId
     * @param size
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/period/list", method = RequestMethod.GET)
    public String getMultiPeriodJson(HttpServletRequest request,
                                     HttpServletResponse response, Integer page, ModelMap model, Integer level, String name, Long subjectId, Long lessonId,
                                     Long bookId, Integer type, Integer size, Integer status, Integer bookPress, Long unitId)
            throws Exception {
        if (type == null) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        log.info("get  period data is " + name + "lessonId" + lessonId);
        if (type != 1 && type != 2 && type != 10) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        List<Long> unitIds = new ArrayList<>();
        Map<Long, String> id_unitName = new HashMap<>();
        List<Long> vids = new ArrayList<>();
        Map<Long, String> id_versionName = new HashMap<>();
        List<Book> books = new ArrayList<>();
        Map<Long, Long> id_press = new HashMap<>();
        Map<String, Object> param = DynamicUtil.getPeriodList(level, name, lessonId, subjectId, type, bookId, unitId, status, bookPress);
        try {
            List<Long> ids = periodService.getIdsByDynamicCondition(Period.class, param, start, size);
            List<Long> count = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
            Integer total = count.size();
            List<Period> periodList = periodService.getObjectsByIds(ids);
            log.info("periodList is" +periodList);
            if (type == 1) {
                for (Period period : periodList) {
                    Long sub = period.getSubjectID();
                    Long les = period.getLessonID();
                    Subject subject = subjectService.getObjectById(sub);
                    Lesson lesson = lessonService.getObjectById(les);
                    if (subject != null) {
                        period.setSubjectName(subject.getName());
                        period.setGradeType(subject.getGradeType());
                    }
                    if (lesson != null) {
                        period.setLessonName(lesson.getName());
                    }
                }
            }
            if (type == 2) {
                for (Period period : periodList) {
                    Long boId = period.getBookID();
                    unitIds.add(period.getUnitId());
                    Book book = bookService.getObjectById(boId);
                    if (book != null) {
                        period.setBookName(book.getName());
                        vids.add(book.getPress());
                        books.add(book);
                    }
                }
                List<BookUnit> units = bookUnitService.getObjectsByIds(unitIds);
                List<BookVersion> versions = bookVersionService.getObjectsByIds(vids);

                id_press = MyListUtil.convert2Map(Book.class.getDeclaredField("id"), Book.class.getDeclaredField("press"), books);
                log.info("id_press : " + id_press);
                id_unitName = MyListUtil.convert2Map(BookUnit.class.getDeclaredField("id"), BookUnit.class.getDeclaredField("unitName"), units);
                log.info("id_unitName : " + id_unitName);
                id_versionName = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), versions);
                log.info("id_versionName : " + id_versionName);
            }
            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("periodList", periodList);
            model.addAttribute("id_press", id_press);
            model.addAttribute("id_unitName", id_unitName);
            model.addAttribute("id_versionName", id_versionName);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get period error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/periodListJson";
    }
    /**
     * //lesson 排序
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/lesson/sort", method = RequestMethod.POST)
    public String getLessonIdsByLevelOrderBySortJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model,@RequestBody List<Long> ids ) throws Exception {




        try {
            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);

            int index = 1;
            for (Lesson lesson : lessonList) {
                lesson.setSort(index);
                index = index + 1;
            }
            this.lessonService.updateList(lessonList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort period error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    /**
     * 排序课程
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Period> periodList = periodService.getObjectsByIds(ids);

            int index = 1;
            for (Period period : periodList) {
                period.setSort(index);
                index = index + 1;
            }
            this.periodService.updateList(periodList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort period error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    private Integer getMaxSort(Long lessonId, Integer level) throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getPeriodList(level, null, lessonId, null, null, null, null, null, null);
        List<Long> maxs = this.periodService.getIdsByDynamicCondition(
                Period.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.periodService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


}

