package com.ptteng.course.admin.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.admin.model.Article;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.course.model.Member;
import com.ptteng.learn.course.service.MemberService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Member  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MemberController {
    private static final Log log = LogFactory.getLog("member");

    @Autowired
    private MemberService memberService;


    /**
     * 套餐列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param status    状态
     * @param name      套餐名称
     * @param minPeriod 套餐期限
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/member/search", method = RequestMethod.GET)
    public String getMemberIdsByStatusJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                                               Integer size, Integer status, String name, String minPeriod, String maxPeriod, String minPrice,
                                               String maxPrice) throws Exception {
        log.info(" /a/member/search name = " + name + " status = " + status + " minPeriod = " + minPeriod + " maxPeriod = " + maxPeriod
                + " minPrice = " + minPrice + " maxPrice = " + maxPrice);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Boolean recommendStatus = false;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> map = DynamicUtil.getMemberList(name, minPeriod, maxPeriod, minPrice, maxPrice, status, false);
            log.info(" map = " + map);
            List<Long> ids = memberService.getIdsByDynamicCondition(Member.class, map, start, size);

            List<Member> memberList = new ArrayList<>();

            if (CollectionUtils.isEmpty(ids)) {
                log.info(" get memberList   ids ,size is 0 ");

            } else {
                log.info(" get memberList   ids ,size is  " + ids.size());
                memberList = memberService.getObjectsByIds(ids);
            }
            log.info("get member data is " + memberList.size());

            for (Member member : memberList) {
                if (Member.is_recommend.equals(member.getRecommend())) {
                    recommendStatus = true;
                    break;
                }
            }

            map = DynamicUtil.getMemberList(name, minPeriod, maxPeriod, minPrice, maxPrice, status, true);
            BigInteger total = (BigInteger) memberService.getObjectByDynamicCondition(Member.class, map, 0, Integer.MAX_VALUE);
            log.info("get member count is " + total);
            log.info("get memberList  total is " + total);
            int totalPage = 1;
            if (null != total) {
                if (total.intValue() > 0) {
                    totalPage = (((total.intValue() - 1)) / (size)) + 1;
                    ;
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("recommendStatus", recommendStatus);
            model.addAttribute("memberList", memberList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get member list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/member/json/memberListJson";
    }


    @RequestMapping(value = "/a/member/{id}", method = RequestMethod.GET)
    public String getMemberJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Member member = memberService.getObjectById(id);
            if (null == member) {
                model.addAttribute("code", -9003);
                return "/data/json";
            }

            log.info("get member data is " + member);

            model.addAttribute("code", 0);

            model.addAttribute("member", member);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get member error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/member/json/memberDetailJson";
    }

    /**
     * 编辑套餐
     *
     * @param request
     * @param response
     * @param model
     * @param member
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/member/{id}", method = RequestMethod.PUT)
    public String updateMemberJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Member member, @PathVariable Long id) throws Exception {

        log.info("update member : member= " + member);
        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();
        try {

            Member oldMember = memberService.getObjectById(id);
            if (null == oldMember) {
                model.addAttribute("code", -9003);
                return "/data/json";
            }


            if (StringUtil.isEmpty(member.getName())) {
                model.addAttribute("code", -9000);
                return "/data/json";
            }
            if (DataUtils.isNullOrEmpty(member.getPeriod())) {
                model.addAttribute("code", -9001);
                return "/data/json";
            }
            if (DataUtils.isNullOrEmpty(member.getPrice())) {
                model.addAttribute("code", -9002);
                return "/data/json";
            }
            oldMember.setName(member.getName());
            oldMember.setPrice(member.getPrice());
            oldMember.setPeriod(member.getPeriod());
            oldMember.setLogo(member.getLogo());
            oldMember.setUpdateBy(managerId);
            oldMember.setIosId(member.getIosId());
            boolean update = memberService.update(oldMember);
            log.info(" update member = " + id + " result is = " + update);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update member error,id is  " + member.getId());
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }

    /**
     * 套餐上下架
     *
     * @param request
     * @param response
     * @param model
     * @param member
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/member/{id}/{status}", method = RequestMethod.PUT)
    public String updateMemberStatusJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, Member member,
                                         @PathVariable Long id, @PathVariable Integer status) throws Exception {

        log.info("update member : member= " + member);
        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();
        try {

            Member oldMember = memberService.getObjectById(id);
            if (null == oldMember) {
                model.addAttribute("code", -9003);
                return "/data/json";
            }

            oldMember.setStatus(status);
            oldMember.setUpdateBy(managerId);
            boolean update = memberService.update(oldMember);
            log.info(" update member = " + id + " status,result is = " + update);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update member error,id is  " + member.getId());
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }

    /**
     * 新增套餐
     *
     * @param request
     * @param response
     * @param model
     * @param member   套餐实体，包含名称、价格、期限
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/member", method = RequestMethod.POST)
    public String addMemberJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Member member) throws Exception {

        log.info("add member : member= " + member);
        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();
        try {
            if (StringUtil.isEmpty(member.getName())) {
                model.addAttribute("code", -9000);
                return "/data/json";
            }
            if (DataUtils.isNullOrEmpty(member.getPeriod())) {
                model.addAttribute("code", -9001);
                return "/data/json";
            }
            if (DataUtils.isNullOrEmpty(member.getPrice())) {
                model.addAttribute("code", -9002);
                return "/data/json";
            }

            member.setStatus(Article.Status_Unpublished);//新增默认是下架状态
            member.setRecommend(Member.not_recommend);
            member.setId(null);
            member.setCreateBy(managerId);
            member.setUpdateBy(managerId);
            log.info("insert member : " + member);
            Long id = memberService.insert(member);
            log.info(" add member success , id = " + id);
            model.addAttribute("code", 0);
            model.addAttribute("id", id);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add member error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }

    @RequestMapping(value = " /a/u/member/{id}", method = RequestMethod.DELETE)
    public String deleteMemberJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete member : id= " + id);
        try {
            Member oldMember = memberService.getObjectById(id);
            if (null == oldMember) {
                model.addAttribute("code", -9003);
                return "/data/json";
            }
            if(oldMember.getIosId().equals(Member.free_member)){
                model.addAttribute("code", -9008);
                return "/data/json";
            }
            memberService.delete(id);

            log.info("add member success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete member error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }


    //设置推荐套餐
    @RequestMapping(value = "/a/u/recommend/{id}", method = RequestMethod.PUT)
    public String recommendMember(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("set recommend member : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认套餐是否存在
            Member member = memberService.getObjectById(id);
            if(null == member){
                model.addAttribute("code", -9003);
                log.info("member not exist");
                return "/common/success";
            }else {
                log.info("member exist : " + member);
            }

            //确定套餐是否是未推荐状态
            if(Member.is_recommend.equals(member.getRecommend())){
                model.addAttribute("code", -9006);
                log.info("member already recommend");
                return "/common/success";
            }else {
                log.info("member not recommend");
            }

            //将当前推荐套餐列表取出并设为未推荐（正常应该只有一个）
            List<Long> memberIds = memberService.getMemberIdsByRecommend(Member.is_recommend,0,Integer.MAX_VALUE);
            log.info("now recommend member id : " + memberIds);
            List<Member> members = memberService.getObjectsByIds(memberIds);
            for(Member memberObj : members){
                memberObj.setRecommend(Member.not_recommend);
            }
            memberService.updateList(members);
            log.info("recommend member reset success");

            //将该套餐状态置1
            member.setRecommend(Member.is_recommend);
            memberService.update(member);
            log.info("member " + id + " set recommend success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("set recommend error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * @Description 取消推荐套餐
     * @Author: PeiyuFeng
     * @param id
     * @Time 2017/2/10 11:36
     */
    @RequestMapping(value = "/a/u/recommend/cancel/{id}", method = RequestMethod.PUT)
    public String cancelRecommendMember(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("cancel recommend member : id = " + id);

        Manager manager = (Manager) request.getAttribute("manager");
        Long managerId = manager.getId();

        try {
            //确认套餐是否存在
            Member member = memberService.getObjectById(id);
            if(null == member){
                model.addAttribute("code", -9003);
                log.info("member not exist");
                return "/common/success";
            }else {
                log.info("member exist : " + member);
            }

            //确定套餐是否是推荐状态
            if(Member.not_recommend.equals(member.getRecommend())){
                model.addAttribute("code", -9007);
                log.info("member not recommend");
                return "/common/success";
            }else {
                log.info("member already recommend");
            }

            //将该套餐状态置1
            member.setRecommend(Member.not_recommend);
            memberService.update(member);
            log.info("member " + id + " cancel recommend success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("cancel recommend error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


}

