package com.ptteng.course.admin.controller;

import java.util.*;

import javax.servlet.Registration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import static com.ptteng.course.util.Constants.DownLine;
import static com.ptteng.course.util.Constants.OnLine;


/**
 * Lesson  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class LessonController {
    private static final Log log = LogFactory.getLog("lesson");

    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private CollaborateService collaborateService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private GradeClassRelationService gradeClassRelationService;
    @Autowired
    private CookieUtil cookieUtil;


    /**
     * //根据条件查找课程
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/lesson/list", method = RequestMethod.GET)
    public String getLessonIdsByLevelOrderBySortJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Integer level, Long subjectId, String name, Integer status, Integer selected) throws Exception {

        log.info("get lessson level is" + level + "subject is " + subjectId + " name is " + name + " selected is " + selected);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> param = DynamicUtil.getLessonList(name, subjectId, level, status, selected);
            List<Long> ids = lessonService.getIdsByDynamicCondition(Lesson.class, param, start, size);
            List<Long> count = lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
            log.info("get countLessonIdsByLevelOrderBySort size is " + ids.size());

            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);
            for (Lesson lesson : lessonList) {
                Long id = lesson.getSubject();
                Integer leve = lesson.getLevel();

                log.info("subject id is : " + id);
                Subject subject = subjectService.getObjectById(id);
                if (subject != null) {
                    lesson.setSubjectName(subject.getName());
                    lesson.setGradeType(subject.getGradeType());
                }

                //查询lesson的levelName
                if (null != lesson.getLevel()) {
                    Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                            (id, leve);
                    if (null != gradeId) {
                        GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                        lesson.setLevelName(gradeClassRelation.getLevel());
                        lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                    }
                }

            }
            log.info("get lesson data is " + lessonList.size());

            Integer total = count.size();
            log.info("get lesson count is " + total);

            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);

            model.addAttribute("lessonList", lessonList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonListJson";
    }



//    @RequestMapping(value = "/a/u/lesson/sort", method = RequestMethod.POST)
//    public String lessonSort(HttpServletRequest request,
//                       HttpServletResponse response, ModelMap model,
//                       @RequestBody List<Long> ids) throws Exception {
//
//        log.info("sort lesson : uids= " + ids);
//
//        try {
//            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);
//
//            int index = 1;
//            for (Lesson lesson : lessonList) {
//                lesson.setSort(index);
//                index = index + 1;
//            }
//            this.lessonService.updateList(lessonList);
//
//            model.addAttribute("code", 0);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            log.error(t.getMessage());
//            log.error("sort period error ");
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/success";
//    }

//
//
//    /**
//	 *
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
//
//		@RequestMapping(value = "/a/lesson2 ", method = RequestMethod.GET)
//	public String getLessonIdsByRecommendOrderBySortJsonList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Integer page,
//			Integer size,Integer recommend) throws Exception {
//
//
//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//
//		log.info("pageList : page= " + start + " , size=" + size);
//
//		try {
//
//			List<Long> ids= lessonService.getLessonIdsByRecommendOrderBySort(recommend,start,size);
//		log.info("get countLessonIdsByRecommendOrderBySort size is " + ids.size());
//
//			List<Lesson> lessonList = lessonService.getObjectsByIds(ids);
//			log.info("get lesson data is " + lessonList.size());
//
//			Integer total = lessonService. countLessonIdsByRecommendOrderBySort(recommend);
//			log.info("get lesson count is " + total);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("page", page);
//			model.addAttribute("size", size);
//
//			model.addAttribute("total", total);
//
//			model.addAttribute("lessonList", lessonList);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get lesson list error,page is  " + start + " , size "
//					+ size);
//			// for test
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/lesson/json/lessonListJson";
//	}


    /**
     * 查看课程详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/{id}", method = RequestMethod.GET)
    public String getLessonJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer page, Integer size)
            throws Exception {
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        log.info("get data : id= " + id);
        try {
            Lesson lesson = lessonService.getObjectById(id);
            if (lesson == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Long subId = lesson.getSubject();
            Subject subject = subjectService.getObjectById(subId);
            if (subject != null) {
                lesson.setSubjectName(subject.getName());
                lesson.setGradeType(subject.getGradeType());
                model.addAttribute("subjectType", subject.getType());
            }
            List<Long> periodIds = periodService.getPeriodIdsByLessonIDOrderBySort(id, start, size);
            Long collaId = lesson.getCollaborateID();
            if (collaId != null) {

                Collaborate collaborate = collaborateService.getObjectById(collaId);
                model.addAttribute("collaborate", collaborate);
            }
            if (periodIds.size() <= 0) {
                log.info("period is null");
            }
            List<Period> periodList = periodService.getObjectsByIds(periodIds);
            log.info("get lesson data is " + lesson);

            model.addAttribute("code", 0);

            model.addAttribute("lesson", lesson);
            model.addAttribute("periodList", periodList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonDetailJson";
    }

    /**
     * 置顶
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/sort/{id}", method = RequestMethod.PUT)
    public String updateLessonSortJson(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        Manager manager = (Manager) request.getAttribute("manager");

        log.info("update lesson sort id = " + id);

        Lesson lesson = lessonService.getObjectById(id);
        lesson.setSort(getMinSort(lesson.getId()));
        lesson.setUpdateBy(manager.getId());
        lessonService.update(lesson);

        model.addAttribute("code", 0);
        return "/common/success";


    }

    /**
     * 修改课程
     *
     * @param request
     * @param response
     * @param model
     * @param lesson
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/{id}", method = RequestMethod.PUT)
    public String updateLessonJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Lesson lesson, String introduceHome, @PathVariable Long id) throws Exception {

        log.info("update lesson : lesson= " + lesson);
        if (lesson.getCollaborateID() != null) {
            Collaborate collaborate = collaborateService.getObjectById(lesson.getCollaborateID());
            if (collaborate == null) {
                model.addAttribute("code", -5045);
                return "/common/success";
            }
        }
        if (lesson.getFirstImg() == null) {
            model.addAttribute("code", -5046);
            return "/common/success";
        }
        if (lesson.getImg() == null) {
            model.addAttribute("code", -5047);
            return "/common/success";
        }
        if (lesson.getLocked() == 1) {
            if (lesson.getMoneyPrice() == null) {
                model.addAttribute("code", -5061);
                return "/common/success";
            }
            if (lesson.getStarPrice() == null) {
                model.addAttribute("code", -5062);
                return "/common/success";
            }
        }
        if (lesson.getSubject() == null) {
            model.addAttribute("code", -5035);
            return "/common/success";
        }
        if (subjectService.getObjectById(lesson.getSubject()) == null) {
            model.addAttribute("code", -5042);
            return "/common/success";
        }
        if (StringUtil.isEmpty(lesson.getName())) {
            model.addAttribute("code", -5007);
            return "/common/success";
        }
        if (lesson.getLevel() == null) {
            model.addAttribute("code", -5026);
            return "/common/success";
        }
        if (lesson.getIntroduce() == null) {
            model.addAttribute("code", -5004);
            return "/common/success";
        }
        if (null == lesson.getStarDisplay()) {
            model.addAttribute("code", -5078);
            return "/common/success";
        }
        if (Lesson.STAR_DISPLAY.equals(lesson.getStarDisplay())
                && null == lesson.getStarLevel()) {
            model.addAttribute("code", -5079);
            return "/common/success";
        }
        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        try {
            Lesson oldLesson = lessonService.getObjectById(id);
            if (lesson.getName().equals(oldLesson.getName())) {
                log.info("name is not change");
            } else {
                List<Long> lessonids = lessonService.getLessonIdsBySubjectOrderBySort(lesson.getSubject(), 0, Integer.MAX_VALUE);

                List<Lesson> lessonlist = lessonService.getObjectsByIds(lessonids);
                for (Lesson lesson1 : lessonlist) {
                    if (lesson.getName().equals(lesson1.getName())) {
                        model.addAttribute("code", -5007);
                        return "/common/success";
                    }
                }
            }
            lesson.setCreateBy(oldLesson.getCreateBy());
            lesson.setUpdateBy(Long.parseLong(userId));
            lessonService.update(lesson);

			/*如果修改了课程的难度等级，一并把课时和任务的等级也修改掉*/
            List<Long> periodIds = periodService.getPeriodIdsByLessonIDOrderBySort(id, 0, Integer.MAX_VALUE);
            log.info(" periodIds = " + periodIds);
            if (periodIds.size() > 0) {
                List<Period> periods = periodService.getObjectsByIds(periodIds);
                for (Period period : periods) {
                    period.setLevel(lesson.getLevel());
                    List<Long> taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(period.getId(), 0, Integer.MAX_VALUE);
                    if (taskIds.size() > 0) {
                        List<Task> tasks = taskService.getObjectsByIds(taskIds);
                        for (Task task : tasks) {
                            task.setLevel(lesson.getLevel());
                        }
                        taskService.updateList(tasks);
                    }
                }
                periodService.updateList(periods);

            }


            model.addAttribute("code", 0);
            lesson.setIntroduceHome(introduceHome);
            model.addAttribute("lesson", lesson);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error,id is  " + lesson.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 新增课程
     *
     * @param request
     * @param response
     * @param model
     * @param lesson
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson", method = RequestMethod.POST)
    public String addLessonJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Lesson lesson, String introduceHome) throws Exception {

        log.info("insert lesson : lesson= " + lesson);
        if (lesson.getCollaborateID() != null) {
            Collaborate collaborate = collaborateService.getObjectById(lesson.getCollaborateID());
            if (collaborate == null) {
                model.addAttribute("code", -5045);
                return "/common/success";
            }
        }
        if (lesson.getFirstImg() == null) {
            model.addAttribute("code", -5046);
            return "/common/success";
        }
        if (lesson.getLocked() == 1) {
            if (lesson.getMoneyPrice() == null) {
                model.addAttribute("code", -5061);
                return "/common/success";
            }
            if (lesson.getStarPrice() == null) {
                model.addAttribute("code", -5062);
                return "/common/success";
            }
        }
        if (lesson.getImg() == null) {
            model.addAttribute("code", -5047);
            return "/common/success";
        }
        if (lesson.getSubject() == null) {
            model.addAttribute("code", -5035);
            return "/common/success";
        }
        if (subjectService.getObjectById(lesson.getSubject()) == null) {
            model.addAttribute("code", -5042);
            return "/common/success";
        }
        if (StringUtil.isEmpty(lesson.getName())) {
            model.addAttribute("code", -5007);
            return "/common/success";
        }
        if (lesson.getLevel() == null) {
            model.addAttribute("code", -5026);
            return "/common/success";
        }
        if (lesson.getIntroduce() == null) {
            model.addAttribute("code", -5004);
            return "/common/success";
        }
        if (null == lesson.getStarDisplay()) {
            model.addAttribute("code", -5078);
            return "/common/success";
        }
        if (Lesson.STAR_DISPLAY.equals(lesson.getStarDisplay())
                && null == lesson.getStarLevel()) {
            model.addAttribute("code", -5079);
            return "/common/success";
        }


        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        try {
            lesson.setId(null);
            lesson.setCreateBy(Long.parseLong(userId));
            List<Long> lessonids = lessonService.getLessonIdsBySubjectOrderBySort(lesson.getSubject(), 0, Integer.MAX_VALUE);
            List<Lesson> lessonlist = lessonService.getObjectsByIds(lessonids);
            for (Lesson lesson1 : lessonlist) {
                if (lesson.getName().equals(lesson1.getName())) {
                    model.addAttribute("code", -5007);
                    return "/common/success";
                }
            }
            Long subId = lesson.getSubject();
            Integer sort = getMaxSort(subId);
            lesson.setSort(sort);
            lesson.setIntroduceHome(introduceHome);
            lessonService.insert(lesson);


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * 下架课程
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/up/{id}", method = RequestMethod.PUT)
    public String deleteLessonJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete lesson : id= " + id);
        try {
            Lesson lesson = lessonService.getObjectById(id);
            if (lesson == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, lesson.getId(), null, 1, null, null, null, null);
//			Map<String, Object> taskParam = DynamicUtil.getTaskList(1, null, null, lesson.getId(), null,null,null,null);
            Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, lesson.getSubject(), null, Lesson.status_normal, null);
            List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
            List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
//			List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
            List<Period> periodList = periodService.getObjectsByIds(periodIds);
//			List<Task> taskList = taskService.getObjectsByIds(taskIds);
            Map<String, Object> taskParam = null;
            List<Long> taskIds = null;
            List<Task> taskList = null;
            if (lesson.getStatus() == 1) {
                if (lesson.getRecommend() == 1) {
                    model.addAttribute("code", -5063);
                    return "/common/success";
                }
                if (lessonIds.size() < 2) {
                    model.addAttribute("code", -5068);
                    return "/common/success";
                }
                lesson.setStatus(DownLine);
                for (Period period : periodList) {
                    period.setStatus(DownLine);
                    periodService.update(period);
                }
//				for (Task task : taskList) {
//					task.setStatus(DownLine);
//					taskService.update(task);
//				}
                lesson.setPaperCount(0);
                lesson.setPeriodCount(0);
                model.addAttribute("code", 6);
                log.info("downline lesson success");
            }
            //上架课程
            else {
                log.info("online lesson");

                periodIds = periodService.getPeriodIdsByLessonIDOrderBySort(id, 0, Integer.MAX_VALUE);
                if (periodIds == null || periodIds.size() < 1) {
                    model.addAttribute("code", -5055);
                    return "/common/success";
                }
                Subject subject = subjectService.getObjectById(lesson.getSubject());
                if (subject.getStatus().equals(Subject.status_freeze)) {
                    model.addAttribute("code", -5071);
                    return "/common/success";
                }
                lesson.setStatus(OnLine);
                Integer paperCount = 0;
                periodList = periodService.getObjectsByIds(periodIds);
                int i = 1;
                lesson.setLocked(Lesson.Lock);
                //用来遍历所有课时动态获取课程上锁状态

                for (Period period : periodList) {
                    taskParam = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, null, null, null, null);
                    taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
                    if (taskIds.size() > 0) {
                        period.setStatus(OnLine);
                        period.setSort(i);
                        i++;
                        period.setTaskCount(taskIds.size());
                        if (period.getPaperID() != null) {
                            paperCount++;
                        }
                    }
                    periodService.update(period);

                }
                //遍历所有上架课时动态获取课程的锁定状态
                Map<String, Object> periodParams = null;
                periodParams = DynamicUtil.getPeriodList(null, null, id, null, null, null, null, Period.status_normal, null);
                periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParams, 0, Integer.MAX_VALUE);
                periodList = periodService.getObjectsByIds(periodIds);
                for (Period period : periodList) {
                    if (period.getLocked().equals(Period.UnLock)) {
                        log.info("period " + period.getId() + " unlock , so lesson unlock");
                        lesson.setLocked(Lesson.UnLock);
                    }
                }

                lesson.setPaperCount(paperCount);
                lesson.setPeriodCount(periodIds.size());
//				for (Task task : taskList) {
//					task.setStatus(OnLine);
//					taskService.update(task);
//				}
                model.addAttribute("code", 5);
                log.info("online lesson success");
            }
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            lesson.setUpdateBy(Long.parseLong(userId));
            log.info("lesson update : " + lesson);
            lessonService.update(lesson);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete lesson error,id is  " + id);
            model.addAttribute("code", -6004);
        }
        return "/common/success";
    }

    /**
     * 获得课程列表
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/grade/list", method = RequestMethod.GET)
    public String getMultiLessonJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Long subjectId, Integer level, Integer status)
            throws Exception {
        if (subjectId == null) {
            model.addAttribute("code", -5035);
            return "/common/success";
        }
        if (level == null) {
            model.addAttribute("code", -5026);
            return "/common/success";
        }

        try {
            Map<String, Object> param = DynamicUtil.getLessonByGradeType2(level, subjectId);
            List<Long> gradeRelationIds = gradeClassRelationService.getIdsByDynamicCondition(GradeClassRelation.class, param, 0, Integer.MAX_VALUE);
            List<GradeClassRelation> gradeClassRelationList = gradeClassRelationService.getObjectsByIds(gradeRelationIds);
            log.info(gradeClassRelationList + "=====================");
            List<Long> lessonIds = new LinkedList<>();
            Integer gradeName = null;
            Map<String, Object> lessonParam = null;
            for (GradeClassRelation gradeClassRelation : gradeClassRelationList) {
                gradeName = gradeClassRelation.getGradeName();
                lessonParam = DynamicUtil.getLessonBySubjectIdAndLevel(null, subjectId, status);
                lessonIds.addAll(lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE));
            }
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);
            model.addAttribute("code", 0);
            model.addAttribute("lessonList", lessonList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + subjectId + "level" + level);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/list";
    }

    /**
     * @param
     * @Description 设置取消精选课程
     * @Author: PeiyuFeng
     * @Time 2017/3/9 13:15
     */
    @RequestMapping(value = "/a/u/lesson/select/{id}", method = RequestMethod.PUT)
    public String sort(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("set / cancel select lesson : " + id);

        try {
            Lesson lesson = lessonService.getObjectById(id);

            if (null == lesson) {
                model.addAttribute("code", -5043);
                return "/common/success";
            } else {
                log.info("get lesson : " + lesson);
            }

            log.info("lesson select status : " + lesson.getSelected());
            if (Lesson.normal_lesson.equals(lesson.getSelected())) {
                lesson.setSelected(Lesson.select_lesson);
            } else {
                lesson.setSelected(Lesson.normal_lesson);
            }
            lessonService.update(lesson);
            log.info("update lesson " + lesson + " success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    private Integer getMaxSort(Long subjectId) throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getLessonList(null, null, null, null, null);
        List<Long> maxs = this.lessonService.getIdsByDynamicCondition(
                Lesson.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.lessonService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }

    private Integer getMinSort(Long lessonId) throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getLessonList(null, null, null, null, null);
        List<Long> mins = this.lessonService.getIdsByDynamicCondition(
                Lesson.class, param, 0, 1);

        Integer min = 0;
        if (CollectionUtils.isEmpty(mins)) {
            log.info("first order ");

        } else {
            log.info(" mins id  = " + mins.get(0));
            Long minID = mins.get(0);
            min = this.lessonService.getObjectById(minID).getSort();
            log.info("quiz min order is " + min);
        }
        return min - 1;
    }

}

