package com.ptteng.course.admin.controller;

import com.ptteng.learn.course.model.GameScoreRecords;
import com.ptteng.learn.course.service.GameScoreRecordsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * GameScoreRecords  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class GameScoreRecordsController {
	private static final Log log = LogFactory.getLog(GameScoreRecordsController.class);

	@Autowired
	private GameScoreRecordsService gameScoreRecordsService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/gameScoreRecords", method = RequestMethod.GET)
	public String getgameScoreRecordsList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/gameScoreRecords  to /gameScoreRecords/view/gameScoreRecordsList");

		return "/learn-course-service/gameScoreRecords/view/gameScoreRecordsList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/gameScoreRecords1 ", method = RequestMethod.GET)
	public String getGameScoreRecordsIdsByUserIdOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long userId) throws Exception {

		log.info("/gameScoreRecords  to /gameScoreRecords/view/gameScoreRecordsList");

		return "/learn-course-service/gameScoreRecords/view/gameScoreRecordsList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/gameScoreRecords/{id}", method = RequestMethod.GET)
	public String getGameScoreRecords(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/gameScoreRecords/" + id + "  to /gameScoreRecords/view/gameScoreRecordsDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/gameScoreRecords/view/gameScoreRecordsDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/gameScoreRecords1 ", method = RequestMethod.GET)
	public String getGameScoreRecordsIdsByUserIdOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long userId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= gameScoreRecordsService.getGameScoreRecordsIdsByUserIdOrderByCreateAt(userId,start,size);
		log.info("get countGameScoreRecordsIdsByUserIdOrderByCreateAt size is " + ids.size());

			List<GameScoreRecords> gameScoreRecordsList = gameScoreRecordsService.getObjectsByIds(ids);
			log.info("get gameScoreRecords data is " + gameScoreRecordsList.size());

			Integer total = gameScoreRecordsService. countGameScoreRecordsIdsByUserIdOrderByCreateAt(userId);
			log.info("get gameScoreRecords count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("gameScoreRecordsList", gameScoreRecordsList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRecords list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRecords/json/gameScoreRecordsListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/gameScoreRecords/{id}", method = RequestMethod.GET)
	public String getGameScoreRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			GameScoreRecords gameScoreRecords = gameScoreRecordsService.getObjectById(id);
			log.info("get gameScoreRecords data is " + gameScoreRecords);

			model.addAttribute("code", 0);

			model.addAttribute("gameScoreRecords", gameScoreRecords);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRecords error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRecords/json/gameScoreRecordsDetailJson";
	}

	@RequestMapping(value = "/a/gameScoreRecords/{id}", method = RequestMethod.PUT)
	public String updateGameScoreRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, GameScoreRecords gameScoreRecords) throws Exception {
		
		log.info("update gameScoreRecords : gameScoreRecords= " + gameScoreRecords);
		
		try {
			
			gameScoreRecordsService.update(gameScoreRecords);

			model.addAttribute("code", 0);

			model.addAttribute("gameScoreRecords", gameScoreRecords);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update gameScoreRecords error,id is  " + gameScoreRecords.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/gameScoreRecords", method = RequestMethod.POST)
	public String addGameScoreRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, GameScoreRecords gameScoreRecords) throws Exception {
		
		log.info("update gameScoreRecords : gameScoreRecords= " + gameScoreRecords);
		
		try { 
			gameScoreRecords.setId(null);

			gameScoreRecordsService.insert(gameScoreRecords);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add gameScoreRecords error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/gameScoreRecords/{id}", method = RequestMethod.DELETE)
	public String deleteGameScoreRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete gameScoreRecords : id= " + id);
		try {
			gameScoreRecordsService.delete(id);

			log.info("add gameScoreRecords success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete gameScoreRecords error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/gameScoreRecords", method = RequestMethod.GET)
	public String getMultiGameScoreRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<GameScoreRecords> gameScoreRecordsList = gameScoreRecordsService.getObjectsByIds(idList);
			log.info("get  gameScoreRecords data is " + gameScoreRecordsList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",gameScoreRecordsList.size());

			model.addAttribute("gameScoreRecordsList", gameScoreRecordsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get gameScoreRecords error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRecords/json/gameScoreRecordsListJson";
	}
	
	
	
	
	
}

