package com.ptteng.course.admin.controller;

import com.ptteng.learn.course.model.GameScoreRank;
import com.ptteng.learn.course.service.GameScoreRankService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * GameScoreRank  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class GameScoreRankController {
	private static final Log log = LogFactory.getLog(GameScoreRankController.class);

	@Autowired
	private GameScoreRankService gameScoreRankService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/gameScoreRank", method = RequestMethod.GET)
	public String getgameScoreRankList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/gameScoreRank  to /gameScoreRank/view/gameScoreRankList");

		return "/learn-course-service/gameScoreRank/view/gameScoreRankList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/gameScoreRank1 ", method = RequestMethod.GET)
	public String getGameScoreRankIdsByUserIdOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long userId) throws Exception {

		log.info("/gameScoreRank  to /gameScoreRank/view/gameScoreRankList");

		return "/learn-course-service/gameScoreRank/view/gameScoreRankList";
	}

	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/gameScoreRank2 ", method = RequestMethod.GET)
	public String getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAtList2(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long stasticsAt) throws Exception {

		log.info("/gameScoreRank  to /gameScoreRank/view/gameScoreRankList");

		return "/learn-course-service/gameScoreRank/view/gameScoreRankList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/gameScoreRank/{id}", method = RequestMethod.GET)
	public String getGameScoreRank(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/gameScoreRank/" + id + "  to /gameScoreRank/view/gameScoreRankDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/gameScoreRank/view/gameScoreRankDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/gameScoreRank1 ", method = RequestMethod.GET)
	public String getGameScoreRankIdsByUserIdOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long userId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= gameScoreRankService.getGameScoreRankIdsByUserIdOrderByCreateAt(userId,start,size);
		log.info("get countGameScoreRankIdsByUserIdOrderByCreateAt size is " + ids.size());

			List<GameScoreRank> gameScoreRankList = gameScoreRankService.getObjectsByIds(ids);
			log.info("get gameScoreRank data is " + gameScoreRankList.size());

			Integer total = gameScoreRankService. countGameScoreRankIdsByUserIdOrderByCreateAt(userId);
			log.info("get gameScoreRank count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("gameScoreRankList", gameScoreRankList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRank list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRank/json/gameScoreRankListJson";
	}

	
	
		
			
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/gameScoreRank2 ", method = RequestMethod.GET)
	public String getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long stasticsAt) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= gameScoreRankService.getGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(stasticsAt,start,size);
		log.info("get countGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt size is " + ids.size());

			List<GameScoreRank> gameScoreRankList = gameScoreRankService.getObjectsByIds(ids);
			log.info("get gameScoreRank data is " + gameScoreRankList.size());

			Integer total = gameScoreRankService. countGameScoreRankIdsByStasticsAtOrderByGameScoreAndUpdateAt(stasticsAt);
			log.info("get gameScoreRank count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("gameScoreRankList", gameScoreRankList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRank list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRank/json/gameScoreRankListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/gameScoreRank/{id}", method = RequestMethod.GET)
	public String getGameScoreRankJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			GameScoreRank gameScoreRank = gameScoreRankService.getObjectById(id);
			log.info("get gameScoreRank data is " + gameScoreRank);

			model.addAttribute("code", 0);

			model.addAttribute("gameScoreRank", gameScoreRank);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRank error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRank/json/gameScoreRankDetailJson";
	}

	@RequestMapping(value = "/a/gameScoreRank/{id}", method = RequestMethod.PUT)
	public String updateGameScoreRankJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, GameScoreRank gameScoreRank) throws Exception {
		
		log.info("update gameScoreRank : gameScoreRank= " + gameScoreRank);
		
		try {
			
			gameScoreRankService.update(gameScoreRank);

			model.addAttribute("code", 0);

			model.addAttribute("gameScoreRank", gameScoreRank);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update gameScoreRank error,id is  " + gameScoreRank.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/gameScoreRank", method = RequestMethod.POST)
	public String addGameScoreRankJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, GameScoreRank gameScoreRank) throws Exception {
		
		log.info("update gameScoreRank : gameScoreRank= " + gameScoreRank);
		
		try { 
			gameScoreRank.setId(null);

			gameScoreRankService.insert(gameScoreRank);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add gameScoreRank error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/gameScoreRank/{id}", method = RequestMethod.DELETE)
	public String deleteGameScoreRankJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete gameScoreRank : id= " + id);
		try {
			gameScoreRankService.delete(id);

			log.info("add gameScoreRank success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete gameScoreRank error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/gameScoreRank", method = RequestMethod.GET)
	public String getMultiGameScoreRankJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<GameScoreRank> gameScoreRankList = gameScoreRankService.getObjectsByIds(idList);
			log.info("get  gameScoreRank data is " + gameScoreRankList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",gameScoreRankList.size());

			model.addAttribute("gameScoreRankList", gameScoreRankList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get gameScoreRank error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRank/json/gameScoreRankListJson";
	}
	
	
	
	
	
}

