package com.ptteng.course.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * DictationLesson  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DictationLessonController {
    private static final Log log = LogFactory.getLog(DictationLessonController.class);

    @Autowired
    private DictationLessonService dictationLessonService;

    @Autowired
    private BookVersionService bookVersionService;

    @Autowired
    private UserDlessonRelationService userDlessonRelationService;

    @Autowired
    private DictationPeriodService dictationPeriodService;

    @Autowired
    private UserDperiodRelationService userDperiodRelationService;

    @Autowired
    private DictationLevelService dictationLevelService;

    @Autowired
    private DictationSubjectService dictationSubjectService;

    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param
     * @Description 听写课程列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 10:25
     */
    @RequestMapping(value = "/a/u/dictation/list", method = RequestMethod.GET)
    public String getDictationLessonList(HttpServletRequest request, HttpServletResponse response,
                                         ModelMap model, Integer page, Integer size, Long subject, Long level, String name,
                                         Integer status, Long version) throws Exception {

        log.info("get dictationLesson list subject:" + subject + "level:" + level + "name:" + name + " status : " + status
                + " version : " + version);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            Integer total = 0;
            List<DictationLesson> lessonList = null;
            Map<String, Object> param = DynamicUtil.getDictationLessonList(subject, level, name, status, version);

            List<Long> ids = dictationLessonService.getIdsByDynamicCondition(DictationLesson.class, param, start, size);
            List<Long> count = dictationLessonService.getIdsByDynamicCondition(DictationLesson.class, param, 0, Integer.MAX_VALUE);
            lessonList = dictationLessonService.getObjectsByIds(ids);
            total = count.size();

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(lessonList, false, DictationLesson.class.getDeclaredField("versionId"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);

            List<Long> lids = MyListUtil.getFieldValueListFromModelList(lessonList, false, DictationLesson.class.getDeclaredField("levelId"));
            List<DictationLevel> levels = dictationLevelService.getObjectsByIds(lids);
            Map<Long, String> id_levelName = MyListUtil.convert2Map(DictationLevel.class.getDeclaredField("id"), DictationLevel.class.getDeclaredField("name"), levels);

            List<Long> sids = MyListUtil.getFieldValueListFromModelList(lessonList, false, DictationLesson.class.getDeclaredField("sid"));
            List<DictationSubject> subjects = dictationSubjectService.getObjectsByIds(sids);
            Map<Long, String> id_subjectName = MyListUtil.convert2Map(DictationSubject.class.getDeclaredField("id"), DictationSubject.class.getDeclaredField("name"), subjects);


            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;

            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("dictationLessonList", lessonList);
            model.addAttribute("id_levelName", id_levelName);
            model.addAttribute("id_version", id_version);
            model.addAttribute("id_subjectName", id_subjectName);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictationLesson list error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationLesson/json/dictationLessonListJson";
    }


    /**
     * @param
     * @Description 编辑听写科目列表  (排序)
     * @Author: PeiyuFeng
     * @Time 2017/5/17 14:56
     */
    @RequestMapping(value = "/a/u/dictation/list/sort", method = RequestMethod.POST)
    public String putDictationSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                          @RequestBody List<Long> ids        ) throws Exception {
        log.info("sort dictationLesson : uids= " + ids);

        try {
            List<DictationLesson> dictationLessonList =  dictationLessonService.getObjectsByIds(ids);
            log.info("subjectList  is " +dictationLessonList );
            int index=1;
            for (DictationLesson dictationLesson : dictationLessonList) {
                dictationLesson.setSort(index);
                index = index + 1;
            }
            this.dictationLessonService.updateList(dictationLessonList);

            model.addAttribute ( "code" , 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get dictationSubject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }











    /**
     * @param
     * @Description 听写课程详情
     * @Author: PeiyuFeng
     * @Time 2017/5/17 13:17
     */
    @RequestMapping(value = "/a/u/dictation/detail/{id}", method = RequestMethod.GET)
    public String getBookJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer start, Integer size)
            throws Exception {

        log.info("get data : id= " + id);

        try {

            DictationLesson lesson = dictationLessonService.getObjectById(id);
            if (lesson == null) {
                log.info("lesson not exist");
                model.addAttribute("code", -2100);
                return "/common/success";
            } else {
                log.info("get lesson data");

            }

            BookVersion bookVersion = bookVersionService.getObjectById(lesson.getVersionId());
            String version = "";
            if (bookVersion != null) {
                version = bookVersion.getVersionName();
            } else {
                log.info("bookVersion : " + lesson.getVersionId() + " not exist");
            }

            DictationSubject subject = dictationSubjectService.getObjectById(lesson.getSid());
            if (subject == null) {
                log.info("data error , subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("get subject name info : " + subject.getName());
            }

            List<Long> lids = dictationLevelService.getIdsBySid(lesson.getSid());
            List<DictationLevel> levels = dictationLevelService.getObjectsByIds(lids);

            log.info("levels : " + levels);

            model.addAttribute("code", 0);
            model.addAttribute("dictationLesson", lesson);
            model.addAttribute("version", version);
            model.addAttribute("levels", levels);
            model.addAttribute("subjectName", subject.getName());

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationLesson/json/dictationLessonDetailJson";
    }


    /**
     * @param
     * @Description 新增听写课程
     * @Author: PeiyuFeng
     * @Time 2017/5/19 11:02
     */
    @RequestMapping(value = "/a/u/dictation", method = RequestMethod.POST)
    public String addBookJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, DictationLesson lesson) throws Exception {

        log.info("add lesson : lesson= " + lesson);

        if (lesson == null) {
            log.info("lesson is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (lesson.getImg() == null || lesson.getName() == null || lesson.getSid() == null || lesson.getVersionStatus() == null
                || lesson.getLevelId() == null || lesson.getSummary() == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            //校验是否展示版本状态
            if (!(lesson.getVersionStatus().equals(1) || lesson.getVersionStatus().equals(2))) {
                log.info("version status wrong");
                model.addAttribute("code", -2108);
                return "/common/success";
            } else if (lesson.getVersionStatus().equals(DictationLesson.VERSION_STATUS_NORMAL)) {
                if (DataUtils.isNullOrEmpty(lesson.getVersionId())) {
                    model.addAttribute("code", -1000);
                    return "/common/success";
                } else {
                    //校验版本id
                    BookVersion version = bookVersionService.getObjectById(lesson.getVersionId());
                    if (version == null) {
                        log.info("version not exist");
                        model.addAttribute("code", -3300);
                        return "/common/success";
                    } else {
                        log.info("get version name info : " + version.getVersionName());
                    }
                }
            }

            //校验科目id
            DictationSubject subject = dictationSubjectService.getObjectById(lesson.getSid());
            if (subject == null) {
                log.info("subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("get subject name info : " + subject.getName());
            }


            //校验难度id
            DictationLevel level = dictationLevelService.getObjectById(lesson.getLevelId());
            if (level == null) {
                log.info("level not exist");
                model.addAttribute("code", -2109);
                return "/common/success";
            } else {
                if (lesson.getSid().equals(level.getSid())) {
                    log.info("get level name info : " + level.getName());
                } else {
                    log.info("level not belong subject : " + lesson.getSid());
                    model.addAttribute("code", -2109);
                    return "/common/success";
                }
            }
        }

        try {

            lesson.setId(null);
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            lesson.setStatus(DictationLesson.STATUS_FORBIDDEN);
            lesson.setCreateAt(System.currentTimeMillis());
            lesson.setCreateBy(Long.parseLong(userId));
            dictationLessonService.insert(lesson);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add lesson error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 编辑听写课程
     * @Author: PeiyuFeng
     * @Time 2017/5/19 12:35
     */
    @RequestMapping(value = "/a/u/dictation/{id}", method = RequestMethod.PUT)
    public String updateBookJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, DictationLesson lesson,
                                 @PathVariable Long id) throws Exception {

        log.info("update lesson : lesson= " + lesson);

        if (lesson == null) {
            log.info("lesson is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            if (lesson.getImg() == null || lesson.getName() == null || lesson.getVersionStatus() == null ||
                    lesson.getLevelId() == null || lesson.getSummary() == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {
                //校验是否展示版本状态
                if (!(lesson.getVersionStatus().equals(1) || lesson.getVersionStatus().equals(2))) {
                    log.info("version status wrong");
                    model.addAttribute("code", -2108);
                    return "/common/success";
                } else if (lesson.getVersionStatus().equals(DictationLesson.VERSION_STATUS_NORMAL)) {
                    if (DataUtils.isNullOrEmpty(lesson.getVersionId())) {
                        model.addAttribute("code", -1000);
                        return "/common/success";
                    } else {
                        //校验版本id
                        BookVersion version = bookVersionService.getObjectById(lesson.getVersionId());
                        if (version == null) {
                            log.info("version not exist");
                            model.addAttribute("code", -3300);
                            return "/common/success";
                        } else {
                            log.info("get version name info : " + version.getVersionName());
                        }
                    }
                }
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            DictationLesson oldLesson = dictationLessonService.getObjectById(id);

            //校验难度id
            DictationLevel level = dictationLevelService.getObjectById(lesson.getLevelId());
            log.info("level : " + level);
            if (level == null) {
                log.info("level not exist");
                model.addAttribute("code", -2109);
                return "/common/success";
            } else {
                if (oldLesson.getSid().equals(level.getSid())) {
                    log.info("get level name info : " + level.getName());
                } else {
                    log.info("level not belong subject : " + lesson.getSid());
                    model.addAttribute("code", -2109);
                    return "/common/success";
                }
            }

            oldLesson.setName(lesson.getName());
            oldLesson.setUpdateBy(Long.parseLong(userId));
            oldLesson.setLevelId(lesson.getLevelId());
            oldLesson.setImg(lesson.getImg());
            oldLesson.setVersionId(lesson.getVersionId());
            oldLesson.setVersionStatus(lesson.getVersionStatus());
            oldLesson.setSummary(lesson.getSummary());
            log.info("update lesson : " + oldLesson);
            dictationLessonService.update(oldLesson);
            log.info("update lesson success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update lesson error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 上下架听写课程
     * @Author: PeiyuFeng
     * @Time 2017/5/19 12:58
     */
    @RequestMapping(value = "/a/u/updown/dictation/{id}", method = RequestMethod.PUT)
    public String updownSubject(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                                Integer size, @PathVariable Long id) throws Exception {

        log.info("up or down dictation lesson : " + id);

        try {
            DictationLesson lesson = dictationLessonService.getObjectById(id);
            if (lesson == null) {
                log.info("dictation lesson not exist");
                model.addAttribute("code", -2100);
                return "/common/success";
            } else {
                log.info("dictation lesson : " + id + " exist");
            }

            if (DictationLesson.STATUS_NORMAL.equals(lesson.getStatus())) {
                //下架
                log.info("dictation lesson down");
                lesson.setStatus(DictationLesson.STATUS_FORBIDDEN);

            } else {
                //上架
                log.info("dictation lesson up");
                List<Long> pids = dictationPeriodService.getIdsByLidOrderBySort(id);
                if(CollectionUtils.isEmpty(pids)){
                    log.info("dictation lesson no period");
                    model.addAttribute("code", -2116);
                    return "/common/success";
                }
                lesson.setStatus(DictationLesson.STATUS_NORMAL);

            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            lesson.setUpdateBy(Long.parseLong(userId));

            dictationLessonService.update(lesson);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update dictation lesson status error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }
}

