package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.model.Book;
import com.ptteng.learn.course.service.BookService;
import com.ptteng.learn.course.service.BookSubjectService;
import com.ptteng.learn.course.service.PeriodService;
import com.ptteng.learn.course.service.TaskService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.print.*;
import java.util.*;

/**
 * BookSubject  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BookSubjectController {
    private static final Log log = LogFactory.getLog(BookSubjectController.class);

    @Autowired
    private BookSubjectService bookSubjectService;
    @Autowired
    private BookService bookService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param id 教材id
     * @Description 教材科目详情
     * @Author: PeiyuFeng
     * @Time 2017/3/31 9:38
     */
    @RequestMapping(value = "/a/u/book/subject/{id}", method = RequestMethod.GET)
    public String getBookSubjectJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                     @PathVariable Long id) throws Exception {

        log.info("get book subject : id= " + id);
        try {
            BookSubject bookSubject = bookSubjectService.getObjectById(id);


            if (bookSubject == null) {
                log.info("get bookSubject data null ");
                model.addAttribute("code", -3100);
                return "/common/success";
            } else {
                log.info("get bookSubject data is " + bookSubject);
            }

            model.addAttribute("code", 0);

            model.addAttribute("bookSubject", bookSubject);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get bookSubject error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/bookSubject/json/bookSubjectDetailJson";
    }

    /**
     * @param name 教材名称
     * @Description 编辑教材科目名称
     * @Author: PeiyuFeng
     * @Time 2017/3/31 10:04
     */
    @RequestMapping(value = "/a/u/book/subject/{id}", method = RequestMethod.PUT)
    public String updateBookSubjectJson(HttpServletRequest request, HttpServletResponse response,
                                        ModelMap model, String name, @PathVariable Long id) throws Exception {

        log.info("update bookSubject : name = " + name);

        try {

            BookSubject bookSubject = bookSubjectService.getObjectById(id);

            if (bookSubject == null) {
                log.info("book subject not exist");
                model.addAttribute("code", -3100);
                return "/common/success";
            } else {
                log.info("get book subject name : " + bookSubject.getSubjectName());

                Long nameId = bookSubjectService.getIdByName(name);
                if (nameId != null) {
                    log.info("same name subject : " + nameId + " exist, init forbidden");
                    model.addAttribute("code", -3101);
                    return "/common/success";
                } else {
                    bookSubject.setSubjectName(name);
                    bookSubjectService.update(bookSubject);
                    log.info("update book subject success");
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update bookSubject error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    /**
     * @param name 教材名称
     * @Description 新增教材科目
     * @Author: PeiyuFeng
     * @Time 2017/3/31 10:12
     */
    @RequestMapping(value = "/a/u/book/subject", method = RequestMethod.POST)
    public String addBookSubjectJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, String name) throws Exception {

        log.info("add bookSubject : name = " + name);

        try {
            Long id = bookSubjectService.getIdByName(name);

            if (id == null) {
                log.info("same name subject not exist, init allow");

                BookSubject bookSubject = new BookSubject();
                bookSubject.setSubjectName(name);
                bookSubject.setStatus(BookSubject.STATUS_OFF);
                bookSubject.setSort(this.getMaxSort());
                bookSubjectService.insert(bookSubject);

            } else {
                log.info("same name subject : " + id + " exist, init forbidden");
                model.addAttribute("code", -3101);
                return "/common/success";
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bookSubject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param ids 教材科目id
     * @Description 教材科目排序
     * @Author: PeiyuFeng
     * @Time 2017/3/31 10:44
     */
    @RequestMapping(value = "/a/u/book/subject/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<BookSubject> subjectList = bookSubjectService.getObjectsByIds(ids);

            int index = 1;
            for (BookSubject subject : subjectList) {
                subject.setSort(index);
                index = index + 1;
            }
            this.bookSubjectService.updateList(subjectList);
            log.info("book subject sort update success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort book subject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param
     * @Description 查看科目列表
     * @Author: PeiyuFeng
     * @Time 2017/3/31 14:21
     */
    @RequestMapping(value = "/a/u/book/subject/list", method = RequestMethod.GET)
    public String getBookSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                     String name, Integer status) throws Exception {

        log.info("get book subject list by name : " + name + " status : " + status);
        List<Long> idList = new ArrayList();

        try {
            Map<String, Object> params = DynamicUtil.getBookSubjectList(name, status);
            idList = bookSubjectService.getIdsByDynamicCondition(BookSubject.class, params, 0, Integer.MAX_VALUE);
            List<BookSubject> bookSubjects = bookSubjectService.getObjectsByIds(idList);
            log.info("get book subject data is " + bookSubjects.size());

            model.addAttribute("code", 0);
            model.addAttribute("bookSubjectList", bookSubjects);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get bookSubject error by name : " + name + " status : " + status);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/bookSubject/json/bookSubjectListJson";
    }


    /**
     * @param id 教材id
     * @Description 上下架教材科目
     * @Author: PeiyuFeng
     * @Time 2017/3/31 15:05
     */
    @RequestMapping(value = "/a/u/book/subject/up/{id}", method = RequestMethod.PUT)
    public String upSubject(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            @PathVariable Long id) throws Exception {

        log.info("up or down book subject : " + id);

        try {
            BookSubject bookSubject = bookSubjectService.getObjectById(id);
            if (bookSubject == null) {
                log.info("book subject not exist");
                model.addAttribute("code", -3100);
                return "/common/success";
            } else {
                log.info("book subject : " + id + " exist");
            }

            Map<String, Object> param = DynamicUtil.getBookList(null, null, null, null, null, id);

            if (BookSubject.STATUS_ON.equals(bookSubject.getStatus())) {
                //下架
                log.info("book subject down");
                bookSubject.setStatus(BookSubject.STATUS_OFF);
                bookSubject.setSort(10086);

                List<Long> idList = bookService.getIdsByDynamicCondition(Book.class, param, 0, Integer.MAX_VALUE);
                log.info("book id list : " + idList);
                if (idList.size() > 0) {
                    List<Book> bookList = bookService.getObjectsByIds(idList);
                    for (Book book : bookList) {
                        book.setStatus(Book.status_freeze);
                        book.setPeriodCount(0);
                    }
                    bookService.updateList(bookList);
                    log.info("update book list success");
                }
                param = DynamicUtil.getPeriodList(null, null, null, id, Period.Book, null, null, Period.status_normal, null);
                idList = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
                log.info("period id list : " + idList);
                if (idList.size() > 0) {
                    List<Period> periodList = periodService.getObjectsByIds(idList);
                    for (Period period : periodList) {
                        period.setStatus(Period.status_freeze);
                        period.setTaskCount(0);
                        periodService.update(period);
                    }
                }
                param = DynamicUtil.getTaskList(Task.book, null, id, null, null, null, null, Task.status_normal, null, null);
                idList = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
                log.info("task id list : " + idList);
                if (idList.size() > 0) {
                    List<Task> taskList = taskService.getObjectsByIds(idList);
                    for (Task task : taskList) {
                        task.setStatus(Task.status_freeze);
                        taskService.update(task);
                    }
                }
            } else {
                //上架
                log.info("book subject up");
                List<Long> idList = bookService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
                log.info("book id list : " + idList);
                if (idList.size() > 0) {
                    List<Book> bookList = bookService.getObjectsByIds(idList);
                    int taskcount = 0;
                    int periodcount = 0;
                    int papercount = 0;
                    int lessoncount = 0;
                    for (Book book : bookList) {
                        Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, null, null, null, book.getId(), null, null, null);
                        List<Long> upPeriodIdList = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
                        log.info("period id list : " + upPeriodIdList);
                        if (upPeriodIdList.size() > 0) {
                            List<Period> upPeriodList = periodService.getObjectsByIds(upPeriodIdList);
                            int periodSort = 1;
                            for (Period period : upPeriodList) {
                                Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, null, null, null, null);
                                List<Long> upTaskIdList = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
                                log.info("task id list : " + upTaskIdList);
                                if (upTaskIdList.size() > 0) {
                                    period.setStatus(Period.status_normal);
                                    period.setSort(periodSort);
                                    periodSort++;
                                    period.setTaskCount(upTaskIdList.size());
                                    periodService.update(period);
                                    periodcount++;
                                    book.setStatus(Lesson.status_normal);
                                    bookSubject.setStatus(BookSubject.STATUS_ON);
                                }

                            }
                        }
                        if (bookSubject.getStatus().equals(BookSubject.STATUS_OFF)) {
                            log.info("book ：" + book.getId() + " have no period");
                            model.addAttribute("code", -5088);
                            return "/common/success";
                        }
                        param = DynamicUtil.getPeriodList(null, null, null, id, Period.Book, book.getId(), null, Period.status_normal, null);
                        idList = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
                        book.setPeriodCount(idList.size());
                        bookService.update(book);
                        log.info("book subject update success");
                    }

                } else {
                    log.info("book subject have no book");
                    model.addAttribute("code", -5077);
                    return "/common/success";
                }

                //重新给教材排序
                param = DynamicUtil.getBookList(null, null, null, null, Lesson.status_normal, id);
                idList = bookService.getIdsByDynamicCondition(Book.class, param, 0, Integer.MAX_VALUE);
                List<Book> books = bookService.getObjectsByIds(idList);
                int bookSort = 1;
                for (Book book : books) {
                    book.setSort(bookSort);
                    bookSort++;
                }
                bookService.updateList(books);

                bookSubject.setSort(getMaxSort());
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            bookSubject.setUpdateBy(Long.parseLong(userId));

            bookSubjectService.update(bookSubject);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get update book subject status error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    private Integer getMaxSort() throws ServiceException, ServiceDaoException {
        List<Long> maxs = bookSubjectService.getSubjectIdsByStatusOrderBySort(BookSubject.STATUS_ON, 0, Integer.MAX_VALUE);
        log.info(maxs);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(0);
            max = this.bookSubjectService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


}

