package com.ptteng.course.admin.controller;

import java.io.File;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.tools.generic.ClassTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import org.springframework.web.multipart.MultipartFile;

import org.apache.http.config.Lookup;

/**
 * Book  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BookController {
    private static final Log log = LogFactory.getLog("book");

    @Autowired
    private BookService bookService;
    @Autowired
    private BookVersionService bookVersionService;
    @Autowired
    private BookSubjectService bookSubjectService;
    @Autowired
    private BookUnitService bookUnitService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CookieUtil cookieUtil;


//
//
//
//    /**
//	 * 根据年级查找教材
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
//
//		@RequestMapping(value = "/a/book1 ", method = RequestMethod.GET)
//	public String getBookIdsByGradeOrderBySortJsonList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Integer page,
//			Integer size,Integer grade) throws Exception {
//
//
//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//
//		log.info("pageList : page= " + start + " , size=" + size);
//
//		try {
//
//			List<Long> ids= bookService.getBookIdsByGradeOrderBySort(grade,start,size);
//		log.info("get countBookIdsByGradeOrderBySort size is " + ids.size());
//
//			List<Book> bookList = bookService.getObjectsByIds(ids);
//			log.info("get book data is " + bookList.size());
//
//			Integer total = bookService. countBookIdsByGradeOrderBySort(grade);
//			log.info("get book count is " + total);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("page", page);
//			model.addAttribute("size", size);
//
//			model.addAttribute("total", total);
//
//			model.addAttribute("bookList", bookList);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get book list error,page is  " + start + " , size "
//					+ size);
//			// for test
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/book/json/bookListJson";
//	}


    /**
     * 查看教材详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/book/{id}", method = RequestMethod.GET)
    public String getBookJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Book book = bookService.getObjectById(id);
            log.info("get book data is " + book);

            BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
            String version = "";
            if (bookVersion != null) {
                version = bookVersion.getVersionName();
            } else {
                log.info("bookVersion : " + book.getPress() + " not exist");
            }

            model.addAttribute("code", 0);
            model.addAttribute("version", version);
            model.addAttribute("book", book);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/book/json/bookDetailJson";
    }

    /**
     * 更新教材
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/book/{id}", method = RequestMethod.PUT)
    public String updateBookJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer step, String name, String img, Long press, String introduce, Integer grade,
                                 Integer starDisplay, Integer starLevel, Long sid, @PathVariable Long id) throws Exception {
        log.info("update book : book= ");
        if (img == null || StringUtil.isEmpty(img)) {
            model.addAttribute("code", -5014);
            return "/common/success";
        }
        if (name == null) {
            model.addAttribute("code", -5005);
            return "/common/success";
        }
        if (grade == null) {
            model.addAttribute("code", -5024);
            return "/common/success";
        }
        if (press == null) {
            model.addAttribute("code", -5027);
            return "/common/success";
        }

        if (introduce == null) {
            model.addAttribute("code", -5028);
            return "/common/success";
        }
//        if (step == null) {
//            model.addAttribute("code", -5052);
//            return "/common/success";
//        }
        if (null == starDisplay) {
            model.addAttribute("code", -5078);
            return "/common/success";
        }
        if (Lesson.STAR_DISPLAY.equals(starDisplay)
                && null == starLevel) {
            model.addAttribute("code", -5079);
            return "/common/success";
        }
        if (DataUtils.isNotNullOrEmpty(sid)) {
            BookSubject subject = bookSubjectService.getObjectById(sid);
            if (subject == null) {
                log.info("subject : " + sid + " not exist");
                model.addAttribute("code", -3100);
                return "/common/success";
            } else {
                log.info("get subject : " + sid + " " + subject.getSubjectName());
            }
        } else {
            log.info("not change sid");
        }
        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);


            Book book = bookService.getObjectById(id);
//            if (book.getStep() == step) {
//                log.info("step is not change");
//            } else {
//                Map<String, Object> taskParam = DynamicUtil.getTaskList(Task.book, null, null, null, null, null, null, null, id, null);
//                List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
//                List<Task> taskList = taskService.getObjectsByIds(taskIds);
//                for (Task task : taskList) {
//                    task.setStep(step);
//                }
//                taskService.updateList(taskList);
//            }
            book.setStep(step);
            book.setUpdateBy(Long.parseLong(userId));
            book.setName(name);
            book.setImg(img);
            book.setIntroduce(introduce);
            book.setGrade(grade);
            book.setPress(press);
            book.setStarDisplay(starDisplay);
            book.setStarLevel(starLevel);
            book.setSid(sid);
            bookService.update(book);

            model.addAttribute("code", 0);

            model.addAttribute("book", book);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update book error,id is  " + id);
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 新增教材
     *
     * @param request
     * @param response
     * @param model
     * @param book
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/book", method = RequestMethod.POST)
    public String addBookJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Book book) throws Exception {

        log.info("update book : book= " + book);
        if (book.getImg() == null || StringUtil.isEmpty(book.getImg())) {
            model.addAttribute("code", -5014);
            return "/common/success";
        }
        if (book.getName() == null) {
            model.addAttribute("code", -5005);
            return "/common/success";
        }
        if (book.getGrade() == null) {
            model.addAttribute("code", -5024);
            return "/common/success";
        }
        if (book.getPress() == null) {
            model.addAttribute("code", -5027);
            return "/common/success";
        }
        if (book.getStep() == null) {
            model.addAttribute("code", -5052);
            return "/common/success";
        }
        if (null == book.getStarDisplay()) {
            model.addAttribute("code", -5078);
            return "/common/success";
        }
        if (null == book.getSid()) {
            model.addAttribute("code", -5089);
            return "/common/success";
        }
        if (Lesson.STAR_DISPLAY.equals(book.getStarDisplay())
                && null == book.getStarLevel()) {
            model.addAttribute("code", -5079);
            return "/common/success";
        }
//		if (book.getTerm() == null) {
//			model.addAttribute("code", -5029);
//		}
//		if (book.getIntroduce()== null) {
//			model.addAttribute("code", -5028);
//			return "/common/success";
//		}
        try {
            book.setId(null);
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            book.setCreateAt(System.currentTimeMillis());
            book.setCreateBy(Long.parseLong(userId));
            book.setSort(getMaxSort());
            bookService.insert(book);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add book error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    @RequestMapping(value = "/a/book/{id}", method = RequestMethod.DELETE)
    public String deleteBookJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete book : id= " + id);
        try {
            bookService.delete(id);

            log.info("add book success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete book error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/common/success";
    }


    /**
     * 根据难度搜索教材
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param grade
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/book/list ", method = RequestMethod.GET)
    public String getBooklist(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                              Integer size, String name, Integer grade, Integer term, Long press, Integer status, Long sid) throws Exception {

        log.info("get booklist name:" + name + "grade:" + grade + "term:" + term + " status : " + status);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);
        Integer total = 0;
        List<Book> bookList = null;
        Map<String, Object> param = DynamicUtil.getBookList(name, press, grade, term, status, sid);
        try {

            List<Long> bookIds = bookService.getIdsByDynamicCondition(Book.class, param, start, size);
            List<Long> count = bookService.getIdsByDynamicCondition(Book.class, param, 0, Integer.MAX_VALUE);
            bookList = bookService.getObjectsByIds(bookIds);
            total = count.size();

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(bookList, false, Book.class.getDeclaredField("press"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);

            List<Long> sids = MyListUtil.getFieldValueListFromModelList(bookList, false, Book.class.getDeclaredField("sid"));
            List<BookSubject> bookSubjects = bookSubjectService.getObjectsByIds(sids);
            Map<Long, String> id_subjectName = MyListUtil.convert2Map(BookSubject.class.getDeclaredField("id"), BookSubject.class.getDeclaredField("subjectName"), bookSubjects);

            model.addAttribute("code", 0);
            boolean next = false;
            if (bookIds.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);

            model.addAttribute("bookList", bookList);
            model.addAttribute("id_version", id_version);
            model.addAttribute("id_subjectName", id_subjectName);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/book/json/bookListJson";
    }

    /**
     * 上下架教材
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/updown/book/{id}", method = RequestMethod.PUT)
    public String updateBook(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        try {
            Book book = bookService.getObjectById(id);
            Map<String, Object> taskParam = null;
            List<Long> taskIds = null;
            List<Task> taskList = null;
            if (Book.status_normal.equals(book.getStatus())) {
                log.info("down book");
                book.setStatus(Book.status_freeze);

                //下架所有单元
                List<Long> buids = bookUnitService.getBookUnitIdsByBid(id);
                if (buids != null && buids.size() > 0) {
                    List<BookUnit> bookUnitList = bookUnitService.getObjectsByIds(buids);
                    for (BookUnit bookUnit : bookUnitList) {
                        bookUnit.setStatus(BookUnit.STATUS_OFF);
                    }
                    bookUnitService.updateList(bookUnitList);
                }

                Map<String, Object> param = DynamicUtil.getPeriodList(null, null, null, null, Period.Book, id, null, null, null);
                List<Long> ids = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
                if (ids != null && ids.size() > 0) {
                    List<Period> periodList = periodService.getObjectsByIds(ids);
                    for (Period period : periodList) {
                        period.setStatus(Period.status_freeze);
                    }
                    periodService.updateList(periodList);
                }
                log.info("down book and id is" + id);
                model.addAttribute("code", 6);
            } else {
                log.info("up book");
                //上架所有单元
                Integer unitSort = 1;
                Integer paperCount = 0;
                Integer periodCount = 0;
                List<BookUnit> bookUnitList = new ArrayList<>();

                List<Long> buids = bookUnitService.getBookUnitIdsByBid(id);
                log.info("unit ids in book " + id + " : " + buids);

                if (buids != null && buids.size() > 0) {
                    bookUnitList = bookUnitService.getObjectsByIds(buids);

                    //循环教材单元列表
                    for (BookUnit bookUnit : bookUnitList) {
                        List<Long> pids = periodService.getPeriodIdsByBookUnitIDAndStatusOrderBySort(bookUnit.getId(), Period.status_freeze, 0, Integer.MAX_VALUE);
                        log.info("period ids in book unit " + bookUnit.getId() + " : " + pids);

                        if (pids.size() > 0) {
                            int i = 1;
                            List<Period> periodList = periodService.getObjectsByIds(pids);
                            log.info("==========开始单元" + bookUnit.getId() + "任务循环=========");
                            for (Period period : periodList) {
                                taskParam = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, null, null, null, null);
                                taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
                                if (taskIds.size() > 0) {
                                    period.setStatus(Period.status_normal);
                                    period.setSort(i);
                                    i++;
                                    periodCount++;
                                    period.setTaskCount(taskIds.size());
                                    if (period.getPaperID() != null) {
                                        paperCount++;
                                    }
                                    bookUnit.setStatus(BookUnit.STATUS_ON);
                                    book.setStatus(Book.status_normal);
                                }else {
                                    log.info("period : " + period.getId() + " have no task, can't upload");
                                    period.setSort(10086);
                                    period.setStatus(Period.status_freeze);
                                }
//                                log.info("period in " + bookUnit.getId() + " update : " + periodList);
                                periodService.updateList(periodList);
                            }
                            if(BookUnit.STATUS_ON.equals(bookUnit.getStatus())){
                                bookUnit.setSort(unitSort);
                                unitSort++;
                            }else {
                                log.info("book unit : " + bookUnit.getId() + " have period,but period no task, can't upload");
                                bookUnit.setSort(10086);
                                bookUnit.setStatus(BookUnit.STATUS_OFF);
                            }
                        } else {
                            log.info("book unit : " + bookUnit.getId() + " have no period, can't upload");
                            bookUnit.setSort(10086);
                            bookUnit.setStatus(BookUnit.STATUS_OFF);
                        }
                    }
                    bookUnitService.updateList(bookUnitList);
                } else {
                    log.info("book : " + id + " have no units");
                    model.addAttribute("code", -5091);
                    return "/common/success";
                }

                if(Book.status_normal.equals(book.getStatus())){
                    book.setPaperCount(paperCount);
                    book.setPeriodCount(periodCount);
                    log.info("up book and id is" + id);
                    model.addAttribute("code", 5);

                }else {
                    log.info("book : " + id + " have no units");
                    model.addAttribute("code", -5092);
                    return "/common/success";
                }

            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            book.setUpdateBy(Long.parseLong(userId));
            bookService.update(book);

            model.addAttribute("book", book);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update book error,id is " + id);
            model.addAttribute("code", -6003);
        }
        return "/common/success";
    }


    @RequestMapping(value = "/a/u/book/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort book : uids= " + ids);

        try {
            List<Book> lists = this.bookService
                    .getObjectsByIds(ids);

            int index = 0;
            for (Book book : lists) {
                book.setSort(index);
                index = index + 1;
            }
            this.bookService.updateList(lists);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bookUnit error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    private Integer getMaxSort() throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getBookList(null, null, null, null, null, null);
        List<Long> maxs = this.bookService.getIdsByDynamicCondition(
                Book.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.bookService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }

}

