package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.service.TaskService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.learn.course.model.Answer;
import com.ptteng.learn.course.service.AnswerService;

/**
 * Answer  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class AnswerController {
	private static final Log log = LogFactory.getLog(AnswerController.class);

	@Autowired
	private AnswerService answerService;

	@Autowired
	private TaskService taskService;




    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/web/c/answer", method = RequestMethod.GET)
	public String getanswerList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/answer  to /answer/view/answerList");

		return "/learn-course-service/answer/view/answerList";
	}
    
    

    		
			
		/**
	 * 任务习题列表
	 * @param taskId 任务id;
	 * @return answerList;
	 * @throws Exception;
	 */
	 
	
		 @RequestMapping(value = "/web/c/answer1 ", method = RequestMethod.GET)
	public String getAnswerIdsByTaskIdOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long taskId) throws Exception {

		log.info("/web/answer  to /answer/view/answerList");

		return "/learn-course-service/answer/view/answerList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/web/c/answer/{id}", method = RequestMethod.GET)
	public String getAnswer(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/answer/" + id + "  to /answer/view/answerDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/answer/view/answerDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/web/a/answer1 ", method = RequestMethod.GET)
	public String getAnswerIdsByTaskIdOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long taskId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= answerService.getAnswerIdsByTaskIdOrderByCreateAt(taskId,start,size);
		log.info("get countAnswerIdsByTaskIdOrderByCreateAt size is " + ids.size());

			List<Answer> answerList = answerService.getObjectsByIds(ids);
			log.info("get answer data is " + answerList.size());

			Integer total = answerService. countAnswerIdsByTaskIdOrderByCreateAt(taskId);
			log.info("get answer count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("answerList", answerList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get answer list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/answer/json/answerListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/web/a/answer/{id}", method = RequestMethod.GET)
	public String getAnswerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Answer answer = answerService.getObjectById(id);
			log.info("get answer data is " + answer);

			model.addAttribute("code", 0);

			model.addAttribute("answer", answer);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get answer error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/answer/json/answerDetailJson";
	}

	@RequestMapping(value = "/web/a/answer/{id}", method = RequestMethod.PUT)
	public String updateAnswerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Answer answer) throws Exception {
		
		log.info("update answer : answer= " + answer);
		
		try {
			
			answerService.update(answer);

			model.addAttribute("code", 0);

			model.addAttribute("answer", answer);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update answer error,id is  " + answer.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}


	/**
	 *习题新增
	 * @param answer 习题参数;
	 * @param taskId 习题所属任务id;
	 * @return json;
	 * @throws Exception;
	 */
	@RequestMapping(value = "/a/u/answer", method = RequestMethod.POST)
	public String addAnswerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Answer answer) throws Exception {
		
		log.info("add answer : answer= " + answer);
		
		try { 
			answer.setId(null);

			answerService.insert(answer);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add answer error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/answer/{id}", method = RequestMethod.DELETE)
	public String deleteAnswerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete answer : id= " + id);
		try {
			answerService.delete(id);

			log.info("add answer success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete answer error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/answer", method = RequestMethod.GET)
	public String getMultiAnswerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Answer> answerList = answerService.getObjectsByIds(idList);
			log.info("get  answer data is " + answerList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",answerList.size());

			model.addAttribute("answerList", answerList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get answer error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/answer/json/answerListJson";
	}
	
	
}

