package com.ptteng.course.admin.controller;

import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.model.Version;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.admin.service.VersionService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.invoke.ConstantCallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * Created by asus on 2016/8/20.
 */
@Controller
public class VersionController {

    private static final Log log = LogFactory.getLog("version");

    @Autowired
    private VersionService versionService;

    @RequestMapping(value = "/a/u/version", method = RequestMethod.POST)
    public String addProgressJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String versionCode,
                                  String os, String url, Boolean isForceUpdate, String info, String code) throws Exception {

            log.info("insert version : versionCode =  " + versionCode + " url = " + url + " os = " + os + " isForceUpdate = "
                + isForceUpdate + " info = " + info);

        try {
            if(DataUtils.isNullOrEmpty(versionCode)||DataUtils.isNullOrEmpty(url)||DataUtils.isNullOrEmpty(os)||
                    DataUtils.isNullOrEmpty(isForceUpdate)||DataUtils.isNullOrEmpty(info)){
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }else if(Version.os_ios.equals(os) || Version.os_android.equals(os)){
                log.info("params check OK");
            }else {
                log.info("version os error");
                model.addAttribute("code", -3401);
                return "/common/success";
            }

            Long versionId = versionService.getVersionIdByOsAndVersionCode(os, versionCode);
            if(null == versionId){
                Version version = new Version();
                version.setUrl(url);
                version.setVersionCode(versionCode);
                version.setInfo(info);
                version.setOs(os);
                version.setIsForceUpdate(isForceUpdate);
                version.setSummary(code);
                log.info("insert version : " + version);
                versionService.insert(version);
                log.info("version insert success");
            }else {
                log.info("version : " + versionCode + " in os : " + os + " exist , can't init");
                model.addAttribute("code", -3400);
                return "/common/success";
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add version error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    @RequestMapping(value = "/a/u/version/{id}", method = RequestMethod.PUT)
    public String updateVersion(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                                String url, Boolean isForceUpdate, String info, String code) throws Exception {

        log.info("update version " + id + " : url = " + url + " isForceUpdate = " + isForceUpdate + " info = " + info);

        try {
            if(DataUtils.isNullOrEmpty(url)|| DataUtils.isNullOrEmpty(isForceUpdate)||DataUtils.isNullOrEmpty(info)){
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }else {
                log.info("params check OK");
            }

            Version version = versionService.getObjectById(id);
            if(version == null){
                log.info("version : " + id + " not exist");
                model.addAttribute("code", -3400);
                return "/common/success";
            }else {
                version.setUrl(url);
                version.setInfo(info);
                version.setSummary(code);
                version.setIsForceUpdate(isForceUpdate);
                log.info("update version : " + version);
                versionService.update(version);
                log.info("version update success");

            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update version error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    //我的信息
    @RequestMapping(value = "/a/version", method = RequestMethod.GET)
    public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Long> numMap = new HashMap<String, Long>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();

        try {
            List<Long> andVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.os_android, 0, Integer.MAX_VALUE);
            log.info("android version id list : " + andVids);

            if(CollectionUtils.isNotEmpty(andVids)){

                List<Version> andVersions = versionService.getObjectsByIds(andVids);
                Collections.sort(andVersions);
                Version andVersion = andVersions.get(0);

                model.addAttribute("andVersion", andVersion);

            }else {
                log.info("no android version");
            }

            List<Long> iosVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.os_ios, 0, Integer.MAX_VALUE);
            log.info("ios version id list : " + iosVids);

            if(CollectionUtils.isNotEmpty(iosVids)){

                List<Version> iosVersions = versionService.getObjectsByIds(iosVids);
                Collections.sort(iosVersions);
                Version iosVersion = iosVersions.get(0);

                model.addAttribute("iosVersion", iosVersion);

            }else {
                log.info("no ios version");
            }

            model.addAttribute("code", 0);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "/learn-course-service/system/version";
    }
}
