package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.UserTaskRelation;
import com.ptteng.learn.course.service.UserTaskRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * UserTaskRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserTaskRelationController {
	private static final Log log = LogFactory.getLog(UserTaskRelationController.class);

	@Autowired
	private UserTaskRelationService userTaskRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userTaskRelation", method = RequestMethod.GET)
	public String getuserTaskRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userTaskRelation  to /userTaskRelation/view/userTaskRelationList");

		return "/learn-course-service/userTaskRelation/view/userTaskRelationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/userTaskRelation/{id}", method = RequestMethod.GET)
	public String getUserTaskRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userTaskRelation/" + id + "  to /userTaskRelation/view/userTaskRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/userTaskRelation/view/userTaskRelationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/userTaskRelation/{id}", method = RequestMethod.GET)
	public String getUserTaskRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserTaskRelation userTaskRelation = userTaskRelationService.getObjectById(id);
			log.info("get userTaskRelation data is " + userTaskRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userTaskRelation", userTaskRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTaskRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTaskRelation/json/userTaskRelationDetailJson";
	}

	@RequestMapping(value = "/a/userTaskRelation/{id}", method = RequestMethod.PUT)
	public String updateUserTaskRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserTaskRelation userTaskRelation) throws Exception {
		
		log.info("update userTaskRelation : userTaskRelation= " + userTaskRelation);
		
		try {
			
			userTaskRelationService.update(userTaskRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userTaskRelation", userTaskRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userTaskRelation error,id is  " + userTaskRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userTaskRelation", method = RequestMethod.POST)
	public String addUserTaskRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserTaskRelation userTaskRelation) throws Exception {
		
		log.info("update userTaskRelation : userTaskRelation= " + userTaskRelation);
		
		try { 
			userTaskRelation.setId(null);

			userTaskRelationService.insert(userTaskRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userTaskRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userTaskRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserTaskRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userTaskRelation : id= " + id);
		try {
			userTaskRelationService.delete(id);

			log.info("add userTaskRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userTaskRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userTaskRelation", method = RequestMethod.GET)
	public String getMultiUserTaskRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserTaskRelation> userTaskRelationList = userTaskRelationService.getObjectsByIds(idList);
			log.info("get  userTaskRelation data is " + userTaskRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userTaskRelationList.size());

			model.addAttribute("userTaskRelationList", userTaskRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userTaskRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTaskRelation/json/userTaskRelationListJson";
	}
	
	
	
	
	
}

