package com.ptteng.course.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.learn.course.model.UserPaperRelation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.learn.course.service.UserPaperRelationService;

/**
 * UserPaperRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserTargetRelationController {
	private static final Log log = LogFactory.getLog(UserTargetRelationController.class);

	@Autowired
	private UserPaperRelationService userPaperRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userTargetRelation", method = RequestMethod.GET)
	public String getuserTargetRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userTargetRelation  to /userTargetRelation/view/userTargetRelationList");

		return "/learn-course-service/userTargetRelation/view/userTargetRelationList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/userTargetRelation1 ", method = RequestMethod.GET)
	public String getUserTargetRelationIdsByTypeList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer type) throws Exception {

		log.info("/userTargetRelation  to /userTargetRelation/view/userTargetRelationList");

		return "/learn-course-service/userTargetRelation/view/userTargetRelationList";
	}

	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/userTargetRelation2 ", method = RequestMethod.GET)
	public String getUserTargetRelationIdsByTypeAndUidList2(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer type,Long uid) throws Exception {

		log.info("/userTargetRelation  to /userTargetRelation/view/userTargetRelationList");

		return "/learn-course-service/userTargetRelation/view/userTargetRelationList";
	}

	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/userTargetRelation3 ", method = RequestMethod.GET)
	public String getUserTargetRelationIdsByUidList3(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long uid) throws Exception {

		log.info("/userTargetRelation  to /userTargetRelation/view/userTargetRelationList");

		return "/learn-course-service/userTargetRelation/view/userTargetRelationList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/userTargetRelation/{id}", method = RequestMethod.GET)
	public String getUserTargetRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userTargetRelation/" + id + "  to /userTargetRelation/view/userTargetRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/userTargetRelation/view/userTargetRelationDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userTargetRelation1 ", method = RequestMethod.GET)
	public String getUserTargetRelationIdsByTypeJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer type) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userPaperRelationService.getUserTargetRelationIdsByType(type,start,size);
		log.info("get countUserTargetRelationIdsByType size is " + ids.size());

			List<UserPaperRelation> userPaperRelationList = userPaperRelationService.getObjectsByIds(ids);
			log.info("get userTargetRelation data is " + userPaperRelationList.size());

			Integer total = userPaperRelationService. countUserTargetRelationIdsByType(type);
			log.info("get userTargetRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userPaperRelationList", userPaperRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTargetRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTargetRelation/json/userTargetRelationListJson";
	}

	
	
		
			
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userTargetRelation2 ", method = RequestMethod.GET)
	public String getUserTargetRelationIdsByTypeAndUidJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer type,Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userPaperRelationService.getUserTargetRelationIdsByTypeAndUid(type,uid,start,size);
		log.info("get countUserTargetRelationIdsByTypeAndUid size is " + ids.size());

			List<UserPaperRelation> userPaperRelationList = userPaperRelationService.getObjectsByIds(ids);
			log.info("get userTargetRelation data is " + userPaperRelationList.size());

			Integer total = userPaperRelationService. countUserTargetRelationIdsByTypeAndUid(type,uid);
			log.info("get userTargetRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userPaperRelationList", userPaperRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTargetRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTargetRelation/json/userTargetRelationListJson";
	}

	
	
		
			
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userTargetRelation3 ", method = RequestMethod.GET)
	public String getUserTargetRelationIdsByUidJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userPaperRelationService.getUserTargetRelationIdsByUid(uid,start,size);
		log.info("get countUserTargetRelationIdsByUid size is " + ids.size());

			List<UserPaperRelation> userPaperRelationList = userPaperRelationService.getObjectsByIds(ids);
			log.info("get userTargetRelation data is " + userPaperRelationList.size());

			Integer total = userPaperRelationService. countUserTargetRelationIdsByUid(uid);
			log.info("get userTargetRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userPaperRelationList", userPaperRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTargetRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTargetRelation/json/userTargetRelationListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/userTargetRelation/{id}", method = RequestMethod.GET)
	public String getUserTargetRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserPaperRelation userPaperRelation = userPaperRelationService.getObjectById(id);
			log.info("get userPaperRelation data is " + userPaperRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userPaperRelation", userPaperRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userTargetRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTargetRelation/json/userTargetRelationDetailJson";
	}

	@RequestMapping(value = "/a/userTargetRelation/{id}", method = RequestMethod.PUT)
	public String updateUserTargetRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserPaperRelation userPaperRelation) throws Exception {
		
		log.info("update userPaperRelation : userPaperRelation= " + userPaperRelation);
		
		try {
			
			userPaperRelationService.update(userPaperRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userPaperRelation", userPaperRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userPaperRelation error,id is  " + userPaperRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userTargetRelation", method = RequestMethod.POST)
	public String addUserTargetRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, UserPaperRelation userPaperRelation) throws Exception {
		
		log.info("update userPaperRelation : userPaperRelation= " + userPaperRelation);
		
		try { 
			userPaperRelation.setId(null);

			userPaperRelationService.insert(userPaperRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userPaperRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userTargetRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserTargetRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userTargetRelation : id= " + id);
		try {
			userPaperRelationService.delete(id);

			log.info("add userTargetRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userTargetRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userTargetRelation", method = RequestMethod.GET)
	public String getMultiUserTargetRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserPaperRelation> userPaperRelationList = userPaperRelationService.getObjectsByIds(idList);
			log.info("get  userTargetRelation data is " + userPaperRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total", userPaperRelationList.size());

			model.addAttribute("userPaperRelationList", userPaperRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userTargetRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/userTargetRelation/json/userTargetRelationListJson";
	}
	
	
	
	
	
}

