package com.ptteng.course.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * UserOrder  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserOrderController {
    private static final Log orderlog = LogFactory.getLog("order");


    @Autowired
    private OrderStatisticsService orderStatisticsService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private UserService userService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private BookService bookService;
    @Autowired
    private MemberService memberService;


    /**
     * @Description 订单统计列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/30 0:11
     */
    @RequestMapping(value = "/a/u/order/list", method = RequestMethod.GET)
    public String getOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long staticAtStart,
                                   Long staticAtEnd, Integer page, Integer size) throws Exception {

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> params = DynamicUtil.getOrderList(staticAtStart, staticAtEnd);
            idList = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, start, size);
            List<OrderStatistics> orderStatisticsList = orderStatisticsService.getObjectsByIds(idList);
            orderlog.info("get  orderStatistics data is " + orderStatisticsList.size());

            List<Long> countIds = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, 0, Integer.MAX_VALUE);
            Integer orderCount = countIds.size();
            orderlog.info("   total = " + orderCount);
            model.addAttribute("userCount", orderCount);

            Integer totalPage = (((orderCount - 1)) / size) + 1;
            orderlog.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);

            model.addAttribute("orderStatisticsList", orderStatisticsList);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("get user list error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderStatisticsListJson";
    }


    /**
     * @Description 订单总体信息
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/30 0:11
     */
    @RequestMapping(value = "/a/u/order/info", method = RequestMethod.GET)
    public String getOrderInfo(HttpServletRequest request, HttpServletResponse response, Long staticAtStart,
                               Long staticAtEnd, ModelMap model) throws Exception {

        orderlog.info("get order info");

        try {

            Map<String, Object> params = DynamicUtil.getOrderList(staticAtStart, staticAtEnd);
            List<Long> idList = orderStatisticsService.getIdsByDynamicCondition(OrderStatistics.class, params, 0, Integer.MAX_VALUE);
            List<OrderStatistics> orderStatisticsList = orderStatisticsService.getObjectsByIds(idList);
            orderlog.info("get  orderStatistics data is " + orderStatisticsList.size());

            Integer orderCount = 0;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal weixinAmount = BigDecimal.ZERO;
            BigDecimal alipayAmount = BigDecimal.ZERO;
            BigDecimal appleAmount = BigDecimal.ZERO;
            Integer vipCount = 0;
            Integer lessonCount = 0;
            Integer paperCount = 0;
            BigDecimal vipAmount = BigDecimal.ZERO;
            BigDecimal lessonAmount = BigDecimal.ZERO;
            BigDecimal paperAmount = BigDecimal.ZERO;
            for(OrderStatistics orderStatistics : orderStatisticsList){
                orderCount = orderCount + orderStatistics.getOrderCount();
                totalAmount =  totalAmount.add(orderStatistics.getTotalAmount());
                weixinAmount =  weixinAmount.add(orderStatistics.getWeixinAmount());
                alipayAmount =  alipayAmount.add(orderStatistics.getAlipayAmount());
                appleAmount =  appleAmount.add(orderStatistics.getAppleAmount());
                vipAmount =  vipAmount.add(orderStatistics.getVipAmount());
                lessonAmount =  lessonAmount.add(orderStatistics.getLessonAmount());
                paperAmount =  paperAmount.add(orderStatistics.getPaperAmount());
                vipCount = vipCount + orderStatistics.getVipCount();
                lessonCount = lessonCount + orderStatistics.getLessonCount();
                paperCount = paperCount + orderStatistics.getPaperCount();
            }

            model.addAttribute("code", 0);
            model.addAttribute("orderCount", orderCount);
            model.addAttribute("totalAmount", totalAmount);
            model.addAttribute("weixinAmount", weixinAmount);
            model.addAttribute("alipayAmount", alipayAmount);
            model.addAttribute("appleAmount", appleAmount);
            model.addAttribute("vipAmount", vipAmount);
            model.addAttribute("lessonAmount", lessonAmount);
            model.addAttribute("paperAmount", paperAmount);
            model.addAttribute("vipCount", vipCount);
            model.addAttribute("lessonCount", lessonCount);
            model.addAttribute("paperCount", paperCount);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("get order info error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderInfo";
    }



    /**
     * @Description 按天统计订单列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/30 18:02
     */
    @RequestMapping(value = "/a/u/order/daily/list", method = RequestMethod.GET)
    public String getOrderInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long staticAt,
                               Integer page, Integer size) throws Exception {

        orderlog.info("get order daily list : staticAt " + staticAt);

        List<Long> idList = new ArrayList();
        Boolean next = false;

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            Map<String, Object> params = DynamicUtil.getOrderDailyList(staticAt);
            idList = userOrderService.getIdsByDynamicCondition(UserOrder.class, params, start, size);
            List<UserOrder> userOrders = userOrderService.getObjectsByIds(idList);
            orderlog.info("get  userOrders data is " + userOrders.size());

            List<Long> uids = MyListUtil.getFieldValueListFromModelList(userOrders, false, UserOrder.class.getDeclaredField("uid"));
            List<User> users = userService.getObjectsByIds(uids);
            Map<Long, String> uid_nick = MyListUtil.convert2Map(User.class.getDeclaredField("id"), User.class.getDeclaredField("nick"), users);

            Map<Long, String> oid_name = new HashMap<>();
            for(UserOrder userOrder : userOrders){
                Long targetId = userOrder.getTargetId();
                Long oid = userOrder.getId();

                switch (userOrder.getBuyType()) {

                    case UserOrder.ORDER_LESSON: {
                        Lesson lesson = lessonService.getObjectById(targetId);
                        oid_name.put(oid, lesson.getName());
                        break;
                    }

                    case UserOrder.ORDER_PERIOD: {
                        Period period = periodService.getObjectById(targetId);
                        oid_name.put(oid, period.getName());
                        break;
                    }

                    case UserOrder.ORDER_LPAPER: {
                        Lesson lesson = lessonService.getObjectById(targetId);
                        oid_name.put(oid, lesson.getName());
                        break;
                    }

                    case UserOrder.ORDER_PPAPER: {
                        Period period = periodService.getObjectById(targetId);
                        oid_name.put(oid, period.getName());
                        break;
                    }

                    case UserOrder.ORDER_BPAPER: {
                        Book book = bookService.getObjectById(targetId);
                        oid_name.put(oid, book.getName());
                        break;
                    }

                    case UserOrder.ORDER_MEMBER: {
                        Member member = memberService.getObjectById(targetId);
                        oid_name.put(oid, member.getName());
                        break;
                    }
                }
            }

            List<Long> countIds = orderStatisticsService.getIdsByDynamicCondition(UserOrder.class, params, 0, Integer.MAX_VALUE);
            Integer orderCount = countIds.size();
            orderlog.info("   total = " + orderCount);
            model.addAttribute("userCount", orderCount);

            Integer totalPage = (((orderCount - 1)) / size) + 1;
            orderlog.info("   totalPage = " + totalPage);

            if (idList != null && idList.size() > 0) {
                if (size.equals(idList.size())) {
                    next = true;
                    idList = idList.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("uid_nick", uid_nick);
            model.addAttribute("userOrders", userOrders);
            model.addAttribute("oid_name", oid_name);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("get order info error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/orderStatistics/json/orderDailyListJson";
    }
}

