package com.ptteng.course.admin.controller;

import com.ptteng.learn.admin.model.Manager;
import com.ptteng.learn.admin.service.ManagerService;
import com.ptteng.learn.course.model.ScoreRecord;
import com.ptteng.learn.course.service.ScoreRecordService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ScoreRecord  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ScoreRecordController {
	private static final Log log = LogFactory.getLog(ScoreRecordController.class);

	@Autowired
	private ScoreRecordService scoreRecordService;

	@Autowired
	private ManagerService managerService;


	
		@RequestMapping(value = "/a/score/record/{uid}/search", method = RequestMethod.GET)
	public String getScoreRecordIdsByUidOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,@PathVariable Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= scoreRecordService.getScoreRecordIdsByUidOrderByCreateAt(uid, start, size);
		log.info("get countScoreRecordIdsByUidOrderByCreateAt size is " + ids.size());

			List<ScoreRecord> scoreRecordList = scoreRecordService.getObjectsByIds(ids);
			log.info("get scoreRecord data is " + scoreRecordList.size());

			List<Long> managerIds = new ArrayList<>();
			for(ScoreRecord scoreRecord : scoreRecordList){
				managerIds.add(scoreRecord.getCreateBy());
			}
			if(managerIds.size()>0){
				List<Manager> managers = managerService.getObjectsByIds(managerIds);
				for(ScoreRecord scoreRecord : scoreRecordList){
					for(Manager manager : managers){
						if(manager.getId().equals(scoreRecord.getCreateBy())){
							scoreRecord.setCreateName(manager.getName());
						}
					}
				}
			}

			Integer total = scoreRecordService. countScoreRecordIdsByUidOrderByCreateAt(uid);
			log.info("get scoreRecord count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			int totalPage =1;
			if(0 != total){
				totalPage=(total-1)/size+1;
			}
			model.addAttribute("totalPage", totalPage);

			model.addAttribute("total", total);

			model.addAttribute("scoreRecordList", scoreRecordList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get scoreRecord list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/scoreRecord/json/scoreRecordListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/scoreRecord/{id}", method = RequestMethod.GET)
	public String getScoreRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			ScoreRecord scoreRecord = scoreRecordService.getObjectById(id);
			log.info("get scoreRecord data is " + scoreRecord);

			model.addAttribute("code", 0);

			model.addAttribute("scoreRecord", scoreRecord);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get scoreRecord error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/scoreRecord/json/scoreRecordDetailJson";
	}

	@RequestMapping(value = "/a/scoreRecord/{id}", method = RequestMethod.PUT)
	public String updateScoreRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ScoreRecord scoreRecord) throws Exception {
		
		log.info("update scoreRecord : scoreRecord= " + scoreRecord);
		
		try {
			
			scoreRecordService.update(scoreRecord);

			model.addAttribute("code", 0);

			model.addAttribute("scoreRecord", scoreRecord);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update scoreRecord error,id is  " + scoreRecord.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/scoreRecord", method = RequestMethod.POST)
	public String addScoreRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ScoreRecord scoreRecord) throws Exception {
		
		log.info("update scoreRecord : scoreRecord= " + scoreRecord);
		
		try { 
			scoreRecord.setId(null);

			scoreRecordService.insert(scoreRecord);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add scoreRecord error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/score/record/{id}", method = RequestMethod.DELETE)
	public String deleteScoreRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete scoreRecord : id= " + id);
		try {
			scoreRecordService.delete(id);

			log.info("add scoreRecord success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete scoreRecord error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/scoreRecord", method = RequestMethod.GET)
	public String getMultiScoreRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<ScoreRecord> scoreRecordList = scoreRecordService.getObjectsByIds(idList);
			log.info("get  scoreRecord data is " + scoreRecordList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",scoreRecordList.size());

			model.addAttribute("scoreRecordList", scoreRecordList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get scoreRecord error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/scoreRecord/json/scoreRecordListJson";
	}
	
	
	
	
	
}

