package com.ptteng.course.admin.controller;

import java.io.IOException;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.storage.util.notice.NoticeUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.course.util.MessageUpUtil;
import com.ptteng.learn.admin.model.Article;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Message  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class MessageController {
    private static final Log log = LogFactory.getLog(MessageController.class);

    @Autowired
    private MessageService messageService;
    @Autowired
    private UserService userService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private UserMessageRelationService userMessageRelationService;

    @Autowired
    private NoticeUtil androidPushServiceImpl;
    @Autowired
    private NoticeUtil iosPushServiceImpl;

    private void noticePush(Message message) throws ServiceException, ServiceDaoException, IOException {
        Integer status = message.getStatus();
        Integer grade = message.getGrade();
        //String result = "";
        if (Message.now.equals(message.getMessageType())) {
            if (Message.synchronization.equals(status)) {
                List<Long> userIds = new ArrayList<>();

                if (User.allGrade.equals(grade)) {
                    log.info(" all ");

                    userIds = userService.getUserIds(0, Integer.MAX_VALUE);
                } else {
                    userIds = userService.getUserIdByGrade(grade);
                }
                log.info(" user size = " + userIds.size());

                if (userIds.size() > 0) {
                    List<User> users = userService.getObjectsByIds(userIds);

                    StringBuilder anDevicceTokens = new StringBuilder("");
                    StringBuilder iosDevicceTokens = new StringBuilder("");
                    for (int i = 0; i < users.size(); i++) {
                        if ("android".equals(users.get(i).getPlatform())) {

                            if (StringUtil.isNotEmpty(users.get(i).getDeviceToken())) {
                                anDevicceTokens.append(users.get(i).getDeviceToken() + ",");
                            }

                        } else if ("ios".equals(users.get(i).getPlatform())) {

                            if (StringUtil.isNotEmpty(users.get(i).getDeviceToken())) {
                                iosDevicceTokens.append(users.get(i).getDeviceToken() + ",");
                            }
                        } else {
//						log.info("user "+users.get(i).getId()+ "is  another platfrorm = "+users.get(i).getPlatform());
                        }
                    }
//				log.info(" anDevicceTokens ="+anDevicceTokens);
//				log.info(" iosDevicceTokens =" + iosDevicceTokens);
                    Long endAt = 0L;
                    Long startAt = null;

                    log.info(" now  ");
                    endAt = message.getCreateAt() + (7 * 24 * 60 * 60 * 1000);
                    log.info(" startAt = " + startAt);
                    if (StringUtil.isNotEmpty(anDevicceTokens.toString())) {
                        log.info(" android ");
                        String anResult = androidPushServiceImpl.pushMessaeForList("android", "notification", "listcast", anDevicceTokens.toString(), message.getName(), message.getName(), message.getContent(), "go_app", "", "", "",
                                "", startAt, "", "true", endAt, "回家学习通知");
                        log.info(" anResult = " + anResult);

                        JSONObject jsonObject = JSONObject.fromObject(anResult);

                        if ("SUCCESS".equals((String) jsonObject.get("ret"))) {
                            log.info(" push success ");
                        } else {
                            log.info("fail" + jsonObject.get("data"));
                            JSONObject data = JSONObject.fromObject(jsonObject.get("data").toString());
                            log.info(" data = " + data);
                            log.info(" errorCode = " + data.get("error_code"));

                        }
                    }
                    if (StringUtil.isNotEmpty(iosDevicceTokens.toString())) {
                        log.info(" ios ");
                        String iosResult = iosPushServiceImpl.pushMessaeForList("ios", "notification", "listcast", iosDevicceTokens.toString(), message.getName(), message.getName(), message.getContent(), "go_app", "", "", "",
                                "", startAt, "", "true", endAt, "回家学习通知");
                        log.info(" iosResult = " + iosResult);
                        JSONObject jsonObjectios = JSONObject.fromObject(iosResult);

                        if ("SUCCESS".equals((String) jsonObjectios.get("ret"))) {
                            log.info(" push success ");
                        } else {
                            log.info(" ==== " + jsonObjectios.get("data"));
                            JSONObject data = JSONObject.fromObject(jsonObjectios.get("data").toString());
                            log.info(" data = " + data);
                            log.info(" errorCode = " + data.get("error_code"));

                        }
                    }
                }

            }

        }


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/message1 ", method = RequestMethod.GET)
    public String getMessageIdsByTypeAndUserIdJsonList(HttpServletRequest request,
                                                       HttpServletResponse response, ModelMap model, Integer page,
                                                       Integer size, Integer type, Long userId) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = messageService.getMessageIdsByTypeAndUserId(type, userId, start, size);
            log.info("get countMessageIdsByTypeAndUserId size is " + ids.size());

            List<Message> messageList = messageService.getObjectsByIds(ids);
            log.info("get message data is " + messageList.size());

            Integer total = messageService.countMessageIdsByTypeAndUserId(type, userId);
            log.info("get message count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("messageList", messageList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get message list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/message/json/messageListJson";
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/publish/message/{id}", method = RequestMethod.PUT)
    public String getMessageIdsByTypeJsonList(HttpServletRequest request,
                                              HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        try {

            Message message = messageService.getObjectById(id);
            if (message.getUpAndDown().equals(Message.status_freeze)) {
                message.setUpAndDown(Message.status_normal);
                message.setPublishAt(System.currentTimeMillis());
                messageService.update(message);
            } else {
                model.addAttribute("code", -5059);
                return "/common/success";
            }
            if (message.getStatus().equals(Message.status_freeze)) {
                MessageUpUtil messageUpUtil = new MessageUpUtil();
                messageUpUtil.messageUp(message);
            } else {
                model.addAttribute("code", -5059);
                return "/common/success";
            }
            noticePush(message);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());

            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.GET)
    public String getMessageJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Message message = messageService.getObjectById(id);
            log.info("get message data is " + message);
            if (message == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }
            model.addAttribute("code", 0);

            model.addAttribute("message", message);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get message error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/message/json/messageDetailJson";
    }

    /**
     * 更新消息
     *
     * @param request
     * @param response
     * @param model
     * @param message
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.PUT)
    public String updateMessageJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Message message, @PathVariable Long id) throws Exception {

        log.info("update message : message= " + message);
        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        if (message.getType() == 1) {
            if (message.getName() == null) {
                model.addAttribute("code", -5005);
                return "/common/success";
            }
            if (message.getGrade() == null) {
                model.addAttribute("code", -5031);
                return "/common/success";
            }
            if (message.getMessageType() == null) {
                model.addAttribute("code", -5032);
                return "/common/success";
            }
            if (message.getMessageType() == 2) {
                message.setUpAndDown(Message.status_freeze);
                if (message.getPublishAt() == null || message.getPublishAt() < System.currentTimeMillis()) {
                    model.addAttribute("code", -5060);
                    return "/common/success";
                }
            }
            if (message.getContent() == null) {
                model.addAttribute("code", -5033);
                return "/common/success";
            }
            if (message.getStatus() == null) {
                model.addAttribute("code", -5051);
                return "/common/success";
            }

        } else if (message.getType() == 2) {
            //帮助
            if (message.getName() == null) {
                model.addAttribute("code", -5005);
                return "/common/success";
            }
            if (message.getContent() == null) {
                model.addAttribute("code", -5033);
                return "/common/success";
            }
        } else {
            //意见
            if (message.getUserId() == null) {
                model.addAttribute("code", -5034);
                return "/common/success";
            }
            if (message.getContent() == null) {
                model.addAttribute("code", -5033);
                return "/common/success";
            }
            User user = userService.getObjectById(message.getUserId());
            if (user.getMail() != null) {
                message.setMail(user.getMail());
            }
        }
        try {
            message.setId(id);
            Message message1 = messageService.getObjectById(id);
            message.setCreateAt(message1.getCreateAt());
            message.setCreateBy(message1.getCreateBy());
            message.setUpdateBy(Long.parseLong(userId));

            messageService.update(message);
            model.addAttribute("code", 0);

            model.addAttribute("message", message);
            if (message.getType() == 1) {
                noticePush(message);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update message error,id is  " + message.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 新增帮助，消息，意见
     * type1,帮助，2消息，3意见
     *
     * @param request
     * @param response
     * @param model
     * @param message
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message", method = RequestMethod.POST)
    public String addMessageJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Message message) throws Exception {

        log.info("update message : message= " + message);

        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                CookieUtil.USER_ID));
        try {
            //消息
            if (message.getType() == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            if (Message.Type_Message.equals(message.getType())) {
                log.info(" xiaoxi ");
                if (message.getName() == null) {
                    model.addAttribute("code", -5005);
                    return "/common/success";
                }
                if (message.getGrade() == null) {
                    model.addAttribute("code", -5031);
                    return "/common/success";
                }
                if (message.getMessageType() == null) {
                    model.addAttribute("code", -5032);
                    return "/common/success";
                }
                if (message.getMessageType() == 2) {
                    if (message.getPublishAt() == null || message.getPublishAt() < System.currentTimeMillis()) {
                        model.addAttribute("code", -5060);
                        return "/common/success";
                    }
                }
                if (message.getContent() == null) {
                    model.addAttribute("code", -5033);
                    return "/common/success";
                }
                if (message.getStatus() == null) {
                    model.addAttribute("code", -5051);
                    return "/common/success";
                }
                if (message.getMessageType() == 2) {
                    if (message.getPublishAt() == null) {
                        model.addAttribute("code", -5053);
                        return "/common/success";
                    }
                }
                message.setSort(1);
            } else if (Message.Type_Help.equals(message.getType())) {
                log.info(" help ");

                //帮助
                if (message.getName() == null) {
                    model.addAttribute("code", -5005);
                    return "/common/success";
                }
                if (message.getContent() == null) {
                    model.addAttribute("code", -5033);
                    return "/common/success";
                }
                //保存排序
                message.setSort(getMaxSort());
            } else {
                log.info(" advise ");

                //意见
                if (message.getUserId() == null) {
                    model.addAttribute("code", -5034);
                    return "/common/success";
                }
                if (message.getContent() == null) {
                    model.addAttribute("code", -5033);
                    return "/common/success";
                }
                User user = userService.getObjectById(message.getUserId());
                if (user.getMail() != null) {
                    message.setMail(user.getMail());
                }
            }
            message.setId(null);
            message.setCreateBy(uid);
            if (message.getMessageType() == null) {
                message.setPublishAt(System.currentTimeMillis());
            } else {
                if (message.getMessageType().equals(Message.now)) {
                    message.setPublishAt(System.currentTimeMillis());
                } else {
                    message.setUpAndDown(Message.status_freeze);
                }
            }
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            message.setCreateBy(Long.parseLong(userId));
            Long messageId = messageService.insert(message);
            if (message.getType() == 1) {
                List<Long> userIds = null;
                List<User> userList = null;
                UserMessageRelation userMessageRelation = new UserMessageRelation();
                List<UserMessageRelation> userMessageRelationList = new LinkedList<>();
                if (message.getType() == 1) {
                    if (message.getGrade() == 7) {
                        userIds = userService.getUserIds(0, Integer.MAX_VALUE);

                    } else {
                        userIds = userService.getUserIdByGrade(message.getGrade());
                    }
                    userList = userService.getObjectsByIds(userIds);
                    userMessageRelation = new UserMessageRelation();
                    userMessageRelation.setTargetId(messageId);
                    userMessageRelationList = new LinkedList<>();
                    for (User user : userList) {
                        userMessageRelation.setUserId(user.getId());
                        userMessageRelationService.insert(userMessageRelation);
                    }
                    log.info(userMessageRelationList.size());
                }
            }
            if (message.getType() == 1) {
                message.setCreateAt(System.currentTimeMillis());
                noticePush(message);
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add message error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    private Integer getMaxSort() throws ServiceException, ServiceDaoException {
        log.info("  getMaxSort start ");
        Map<String, Object> param = DynamicUtil.getMessageList
                (null, "", Message.Type_Help, "", null, null, "", null);
        log.info(" param = " + param);
        List<Long> maxs = this.messageService.getIdsByDynamicCondition(
                Message.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            log.info(" maxID = " + maxID);
            max = this.messageService.getObjectById(maxID).getSort();
            if (null == max) {
                max = 0;
            }
            log.info("quiz max order is " + max);
        }
        return max + 10;
    }

    /**
     * 删除消息
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.DELETE)
    public String deleteMessageJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete message : id= " + id);
        try {
            Message message = messageService.getObjectById(id);
            messageService.delete(id);
            if (message.getType() == 1) {
                List<Long> userMessageRelationIds = userMessageRelationService.getUserMessageRelationIdsByName(id, 0, Integer.MAX_VALUE);
                userMessageRelationService.deleteList(UserMessageRelation.class, userMessageRelationIds);
            }

            log.info("add message success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete message error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/common/success";
    }

    /**
     * 帮助排序
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Message> messages = messageService
                    .getObjectsByIds(ids);

            int index = 1;
            for (Message message : messages) {
                message.setSort(index);
                index = index + 1;
            }
            this.messageService.updateList(messages);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update message sort error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 条件搜索消息
     *
     * @param request
     * @param response
     * @param type
     * @param page
     * @param size
     * @param model
     * @param name
     * @param messageType
     * @param nick
     * @param timeLow
     * @param timeHigh
     * @param mail
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/list", method = RequestMethod.GET)
    public String getMultiMessageJson(HttpServletRequest request,
                                      HttpServletResponse response, Integer type, Integer page, Integer size, ModelMap model, String name,
                                      Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer grade)
            throws Exception {
        if (type == null) {
            model.addAttribute("code", -5040);
            return "/common/success";
        }
        if (type != 1 && type != 2 & type != 3) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        List<Long> idList = new ArrayList();
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
            Map<String, Object> param = DynamicUtil.getMessageList(grade, name, messageType, nick, timeLow, timeHigh, mail, type);
            idList = messageService.getIdsByDynamicCondition(Message.class, param, start, size);
            List<Long> count = messageService.getIdsByDynamicCondition(Message.class, param, 0, Integer.MAX_VALUE);
            List<Message> messageList = messageService.getObjectsByIds(idList);
            log.info("get  message data is " + messageList);
            Integer total = count.size();
            Boolean next = false;
            Integer nex = start + size;
            if (total > nex) {

                next = true;
            }
            model.addAttribute("next", next);


            Integer totalPage = 1;
            if (total > 0) {

                totalPage = (total - 1) / size + 1;
            }
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("messageList", messageList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get message error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/message/json/messageListJson";
    }


}

