package com.ptteng.course.admin.controller;

import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.model.Version;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.admin.service.VersionService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * Created by asus on 2016/8/20.
 */
@Controller
public class ConstantController {

    private static final Log log = LogFactory.getLog("constant");

    @Autowired
    private ConstantService constantService;


    @RequestMapping(value = "/a/u/video/img", method = RequestMethod.PUT)
    public String addProgressJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String img) throws Exception {

        log.info("update video img : " + img);

        try {
            if(DataUtils.isNullOrEmpty(img)){
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Long cid = constantService.getConstantIdByKeyAndType("video", "img");
            if(null == cid){
                Constant constant = new Constant();
                constant.setMykey("video");
                constant.setValue(img);
                constant.setType("img");
                log.info("insert constant : " + constant);
                constantService.insert(constant);
                log.info("insert constant success");
            }else {
                Constant constant = constantService.getObjectById(cid);
                constant.setValue(img);
                constantService.update(constant);
                log.info("update constant success");
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update img error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    @RequestMapping(value = "/a/u/video/img", method = RequestMethod.GET)
    public String updateVersion(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get video img ");

        try {

            Long cid = constantService.getConstantIdByKeyAndType("video", "img");
            if(null == cid){
                log.info("no constant");
            }else {
                Constant constant = constantService.getObjectById(cid);
                model.addAttribute("constant", constant);
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get img error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/system/videoImgConstant";
    }

}
