package com.ptteng.course.admin.controller;

import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.BookVersion;
import com.ptteng.learn.course.service.BookService;
import com.ptteng.learn.course.service.BookVersionService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * BookVersion  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class BookVersionController {
	private static final Log log = LogFactory.getLog(BookVersionController.class);

	@Autowired
	private BookVersionService bookVersionService;
	@Autowired
	private BookService bookService;


	/**
	 * @Description 教材版本详情
	 * @param id 教材版本id
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 10:41
	 */
	@RequestMapping(value = "/a/u/book/version/{id}", method = RequestMethod.GET)
	public String getBookSubjectJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
									 @PathVariable Long id) throws Exception {

		log.info("get book version : id= " + id);
		try {
			BookVersion bookVersion = bookVersionService.getObjectById(id);

			if (bookVersion == null) {
				log.info("get bookVersion data null ");
				model.addAttribute("code", -3300);
				return "/common/success";
			} else {
				log.info("get bookVersion data is " + bookVersion);
			}

			model.addAttribute("code", 0);
			model.addAttribute("bookVersion", bookVersion);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get bookVersion error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/bookVersion/json/bookVersionDetailJson";
	}

	/**
	 * @Description 更新版本信息
	 * @param id 版本id
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 10:41
	 */
	@RequestMapping(value = "/a/u/book/version/{id}", method = RequestMethod.PUT)
	public String updateBookVersion(HttpServletRequest request, HttpServletResponse response,
										ModelMap model, String name, @PathVariable Long id) throws Exception {

		log.info("update bookVersion : name = " + name);

		try {

			BookVersion bookVersion = bookVersionService.getObjectById(id);

			if (bookVersion == null) {
				log.info("book version not exist");
				model.addAttribute("code", -3300);
				return "/common/success";
			} else {
				log.info("get book version name : " + bookVersion.getVersionName());

				Long nameId = bookVersionService.getIdByName(name);
				if(nameId != null){
					log.info("same name version : " + id + " exist, init forbidden");
					model.addAttribute("code", -3101);
					return "/common/success";
				}else {
					bookVersion.setVersionName(name);
					bookVersionService.update(bookVersion);
					log.info("update book version success");
				}
			}

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update bookVersion error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}


	/**
	 * @Description 新建教材版本
	 * @param name 版本名称
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 10:55
	 */
	@RequestMapping(value = "/a/u/book/version", method = RequestMethod.POST)
	public String addBookSubjectJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, String name) throws Exception {

		log.info("add BookVersion : name = " + name);

		try {
			Long id = bookVersionService.getIdByName(name);

			if (id == null) {
				log.info("same name version not exist, init allow");

				BookVersion bookVersion = new BookVersion();
				bookVersion.setVersionName(name);
				bookVersion.setStatus(BookVersion.STATUS_OFF);
				bookVersionService.insert(bookVersion);

			} else {
				log.info("same name version : " + id + " exist, init forbidden");
				model.addAttribute("code", -3301);
				return "/common/success";
			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add BookVersion error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	/**
	 * @Description 删除教材版本
	 * @param id 版本id
	 * @Author: PeiyuFeng
	 * @Time 2017/4/10 18:29
	 */
	@RequestMapping(value = "/a/u/book/version/{id}", method = RequestMethod.DELETE)
	public String addBookSubjectJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete BookVersion : " + id);

		try {
			List<Long> bookId = bookService.getBookIdsByVersion(id, 0, 1);

			if (bookId == null) {
				log.info("not book in version , delete allow");

				bookVersionService.delete(id);

				log.info("book version : " + id + " delete success");

			} else {
				log.info("there are book " + bookId + " in version : " + id + " , delete forbidden");
				model.addAttribute("code", -3302);
				return "/common/success";
			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete BookVersion error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 * @Description 获取教材版本列表
	 * @param name 教材名称
	 * @Author: PeiyuFeng
	 * @Time 2017/4/8 11:05
	 */
	@RequestMapping(value = "/a/u/book/version/list", method = RequestMethod.GET)
	public String getBookSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
									 String name, Integer status, Integer page, Integer size) throws Exception {

		log.info("get book version list by name : " + name + " status : " + status);
		List<Long> idList = new ArrayList();
		List<Long> totalIds = new ArrayList<>();
		if (null == page) {
			page = 1;
		}
		if (null == size) {
			size = 10;
		}
		int firstNmuber = (page - 1) * size;
		Boolean next = false;

		try {
			Map<String, Object> params = DynamicUtil.getBookVersionList(name, status);
			idList = bookVersionService.getIdsByDynamicCondition(BookVersion.class, params, firstNmuber, size);
			List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(idList);
			log.info("get book version data is " + bookVersions.size());

			if (idList != null && idList.size() > 0) {
				if (size.equals(idList.size())) {
					next = true;
					idList = idList.subList(0, size);
				}
			}

			totalIds = bookVersionService.getIdsByDynamicCondition(BookVersion.class, params, 0, Integer.MAX_VALUE);

			for(BookVersion bookVersion : bookVersions){
				List<Long> books = bookService.getBookIdsByVersion(bookVersion.getId(), 0 , Integer.MAX_VALUE);
				if(CollectionUtils.isNotEmpty(books)){
					bookVersion.setStatus(BookVersion.STATUS_ON);
				}else {
					bookVersion.setStatus(BookVersion.STATUS_OFF);
				}
			}


			log.info("   total = " + totalIds.size());
			Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
			log.info("   totalPage = " + totalPage);

			model.addAttribute("code", 0);
			model.addAttribute("next", next);
			model.addAttribute("page", page);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("bookVersionList", bookVersions);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get book version error by name : " + name + " status : " + status);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/bookVersion/json/bookVersionListJson";
	}

	
}

