package com.ptteng.graship.admin.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.graship.admin.model.RoleModuleRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface RoleModuleService extends BaseDaoService {


    public Long insert(RoleModuleRelation roleModule) throws ServiceException, ServiceDaoException;


    public List<RoleModuleRelation> insertList(List<RoleModuleRelation> roleModuleList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(RoleModuleRelation roleModule) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<RoleModuleRelation> roleModuleList) throws ServiceException, ServiceDaoException;


    public RoleModuleRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<RoleModuleRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countRoleModuleIdsByRid(Long rid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getRoleModuleIdsByRid(Long rid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getRoleModuleIdsByMid(Long mid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getRoleModuleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countRoleModuleIds() throws ServiceException, ServiceDaoException;


}

