package com.ptteng.graship.admin.util;

import com.cloopen.rest.sdk.utils.DateUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.graship.admin.controller.ComponentController;
import com.ptteng.graship.admin.model.Module;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.Serve;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.eclipse.jetty.util.log.Log;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {

	public static Map<String, Object> getIdsParam(Long startAt, Long endAt, String name, String mobile, Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" + endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", "'" + mobile + "'");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  user ");

		return params;
	}

	public static Map<String, Object> getCpyIdsParam(String cpyName, String phone, String name, String mobile,
	                                                 String grade, Integer status, Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name & like", "'%" + cpyName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(phone)) {
			params.put(" phone ", "'" + phone + "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", "'" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", "'" + mobile + "'");
		}
		if (DataUtils.isNotNullOrEmpty(grade)) {
			params.put("grade", "'" + grade + "'");
		}

		params.put("status", 2);

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  user ");

		return params;
	}

	// 根据服务查公司ids
	public static Map<String, Object> getCpyByServe(String cpyName, String servea, String serveb, String servec) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpyName & like", "'%" + cpyName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(servea)) {
			params.put("servea", "'" + servea + "'");
		}
		if (DataUtils.isNotNullOrEmpty(serveb)) {
			params.put("serveb", "'" + serveb + "'");
		}
		if (DataUtils.isNotNullOrEmpty(servec)) {
			params.put("servec", "'" + servec + "'");
		}
		params.put("query", "id");
		params.put("@table", "moduls");
		return params;
	}

	// 获得未读消息、
	public static Map<String, Object> getmessageListStage(Integer mstage, Long id) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(mstage)) {
			params.put("mstage", "'" + mstage + "'");
		}
		if (DataUtils.isNotNullOrEmpty(id)) {
			params.put("create_by", id);
		}

		params.put("@query", "id");
		params.put("@table", "message");
		return params;
	}

	public static Map<String, Object> getIdsByparentId(Long id) {
		Map<String, Object> params = new HashedMap();
		params.put("@table", "server");

		params.put("parent_id", id);

		params.put("@order", "sort");
		params.put("@query", "id");
		return params;

	}

	// 公司申请认证列表
	public static Map<String, Object> getCpyListIds(String cpyName, String industry, String stage, String name,
	                                                String mobile, Integer status, Long startAt, Long endAt) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name & like", "'%" + cpyName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(industry)) {
			params.put("industry", "'" + industry + "'");
		}
		if (DataUtils.isNotNullOrEmpty(stage)) {
			params.put("stage", "'" + stage + "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name", "'" + name + "'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", "'" + mobile + "'");
		}

		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", "'" + status + "'");
		}

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("apply_at & >=", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("apply_at & <=", "'" + endAt + "'");
		}
		params.put("@order", "  status desc ");
		params.put("@query", "id");
		params.put("@table", "user");
		return params;
	}

	//
	public static Map<String, Object> getSeaveListIds(String cpyName, Long servea, Long serveb, Integer staus,
	                                                  Long createAt, Long endAt) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name & like", "'%" + cpyName + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(staus)) {
			params.put("staus", "'" + staus + "'");
		}
		if (DataUtils.isNotNullOrEmpty(servea)) {
			params.put("servea", "'" + servea + "'");
		}
		if (DataUtils.isNotNullOrEmpty(serveb)) {
			params.put("serveb", "'" + serveb + "'");
		}
		if (DataUtils.isNotNullOrEmpty(createAt)) {
			params.put("create_at & >=", "'" + createAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("create_at & <=", "'" + endAt + "'");
		}
		params.put("@order", "  staus asc ");
		params.put("@query", "id");
		params.put("@table", "serve");
		return params;
	}

	public static Map<String, Object> getModulsList(String name, Long startAt, Long endAt, Integer grade, Long parentId,
	                                                Integer groups) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name", "'%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("create_at & >=", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("create_at & <=", "'" + endAt + "'");
		}

		if (DataUtils.isNotNullOrEmpty(groups)) {
			params.put("groups", "'" + groups + "'");
		}

		params.put("parent_id", Moduls.PARENT_ID);
		params.put("@order", "  level desc,create_at desc");
		params.put("@query", "id");
		params.put("@table", "moduls");
		return params;
	}

	// 通过servea查询名字
	public static Map<String, Object> getModulsServeaName(Long servea) {

		Map<String, Object> params = new HashedMap();

		params.put("id", "'" + servea + "'");

		params.put("@query", "name");
		params.put("@table", "moduls");
		return params;
	}

	// 通过serveb查询名字
	public static Map<String, Object> getModulsServebName(Long serveb) {

		Map<String, Object> params = new HashedMap();

		params.put("id", "'" + serveb + "'");

		params.put("@query", "name");
		params.put("@table", "moduls");
		return params;
	}

	// 使用服务申请列表
	public static Map<String, Object> getOrderListIds(String userName, Integer applya, Integer applyb, Long createAt,
	                                                  Long endAt, String mobile, String cpyName, Integer oStage, Long pact, Long endPact) {

		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(userName)) {
			params.put("user_name & like", "'%" + userName + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(createAt)) {
			params.put("pact & >=", "'" + pact + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endPact)) {
			params.put("pact & <=", "'" + endPact + "'");
		}
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name & like", "'%" + cpyName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", "'" + mobile + "'");
		}

		if (DataUtils.isNotNullOrEmpty(oStage)) {
			params.put("oStage", "'" + oStage + "'");
		}
		if (DataUtils.isNotNullOrEmpty(applya)) {
			params.put("applya", "'" + applya + "'");
		}
		if (DataUtils.isNotNullOrEmpty(applyb)) {
			params.put("applyb", "'" + applyb + "'");
		}
		if (DataUtils.isNotNullOrEmpty(createAt)) {
			params.put("create_at & >=", "'" + createAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("create_at & <=", "'" + endAt + "'");
		}

		// params.put("@order", " pact desc ");
		params.put("@query", " id ");
		params.put("@table", "  orderr ");

		return params;
	}

	// 展示服务列表
	public static Map<String, Object> getSucSeaveListIds(Long servea, Long serveb, String cpyName) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(cpyName)) {
			params.put("cpy_name & like", "'%" + cpyName + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(servea)) {
			params.put("servea", "'" + servea + "'");
		}
		if (DataUtils.isNotNullOrEmpty(serveb)) {
			params.put("serveb", "'" + serveb + "'");
		}

		params.put("@query", " id ");
		params.put("@table", " serve ");

		return params;
	}

	// 根据父类id获取子类对象
	public static Map<String, Object> getModulsListB(String name, Long startAt, Long endAt, Integer grade,
	                                                 Long parentId, Integer groups) {
		Map<String, Object> params = new HashedMap();

		params.put("parent_id", parentId);

		// params.put("grade", Moduls.son);
		// params.put("parent_id", parentId);

		params.put("@order", "  level desc ");
		params.put("@query", "id");
		params.put("@table", "moduls");
		return params;
	}

	// 根据用户名查询管理员
	public static Map<String, Object> getManagerListByName(String name) {
		Map<String, Object> params = new HashedMap();

		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", "'%" + name + "%'");
		}
		// params.put("grade", Moduls.son);
		// params.put("parent_id", parentId);

		params.put("@order", "  id desc ");
		params.put("@query", "id");
		params.put("@table", "manager");
		return params;
	}

	public static Map<String, Object> getArticleList(String title, String author, Long startAt, Long endAt, Long type,
	                                                 Long status, Long industry) {
		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(title)) {
			params.put("title & like ", "'%" + title + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(author)) {
			params.put("author & like ", "'%" + author + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("update_at & >=", startAt);
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("update_at & <= ", endAt);
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("type ", type);
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status ", status);
		}

		params.put("@order", "  publish_at desc ");

		params.put("@query", " id");

		params.put("@table", " article ");

		return params;
	}

	// 搜索栏获取父类id
	public static Map<String, Object> getSucSeaveaList(Long parentId) {
		Map<String, Object> params = new HashedMap();

		params.put("parent_id", Serve.PARENT_ID);

		params.put("@order", "  create_at desc ");

		params.put("@query", " id");

		params.put("@table", " moduls ");

		return params;
	}

	// 子类服务
	public static Map<String, Object> getSucSeavebList(Long modulsA_id) {
		Map<String, Object> params = new HashMap<String, Object>();

		params.put("parent_id", modulsA_id);

		params.put("@order", "  create_at desc ");

		params.put("@query", " id");

		params.put("@table", " moduls ");

		return params;
	}

	// 用户公司
	public static Map<String, Object> getCompanyList(String cname, String mobile, Integer grade, String name,
	                                                 String phone, Long uid) {
		Map<String, Object> params = new HashMap<String, Object>();
		Set<String> tables = new HashSet();
		tables.add("user_company_relation ucr");
		tables.add("company c");
		tables.add("user u");
		params.put("ucr.uid", "u.id");
		params.put("ucr.cid", "c.id");
		params.put("ucr.status & =", 2);
		if (DataUtils.isNotNullOrEmpty(uid)) {
			params.put("u.id & = ", uid);
		}
		if (DataUtils.isNotNullOrEmpty(cname)) {
			params.put("c.cname & like ", "'%" + cname + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("c.mobile & like ", "'%" + mobile + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(grade)) {
			params.put("c.grade &=", "'" + grade + "'");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("u.name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(phone)) {
			params.put("u.mobile & like ", "'%" + phone + "%'");
		}
		params.put("@order", "ucr.create_at desc ");

		params.put("@query", "distinct(ucr.id)");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}

	// 使用服务列表
	public static Map<String, Object> getUserServerIdsList(String companyName, String name, Long parentId, Long id,
	                                                       String mobile, Long startAt, Long endAt, Long companyId, Long applyStart, Long applyEnd, Integer status,
	                                                       Long uid) {
		Set<String> tables = new HashSet();
		Map<String, Object> params = new HashMap<String, Object>();
		tables.add("user u");
		tables.add("user_server_relation usr");
		tables.add("company c");
		tables.add("server s");
		params.put("s.id", "usr.sid");
		params.put("u.id", "usr.uid");
		params.put("c.id", "usr.cid");
		if (DataUtils.isNotNullOrEmpty(uid)) {
			params.put("u.id & = ", uid);
		}
		if (DataUtils.isNotNullOrEmpty(companyName)) {
			params.put("c.cname & like ", "'%" + companyName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(parentId)) {
			params.put("s.parent_id & = ", parentId);
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("u.name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(id)) {
			params.put("s.id &=", id);
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("u.mobile & like ", "'%" + mobile + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("usr.create_at &>", startAt);
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("usr.create_at &<", endAt);
		}
		if (DataUtils.isNotNullOrEmpty(companyId)) {
			params.put("usr.cid &=", companyId);
		}
		if (DataUtils.isNotNullOrEmpty(applyStart)) {
			params.put("usr.pre_date &>", applyStart);
		}
		if (DataUtils.isNotNullOrEmpty(applyEnd)) {
			params.put("usr.pre_date &<", applyEnd);
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("usr.status &=", status);
		}
		params.put("@order", "usr.create_at desc");
		params.put("@query", "usr.id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}

	public static Map<String, Object> getCompanyServerIdsList(String cname, Long cid, Long id, String parentId) {
		Set<String> tables = new HashSet();
		Map<String, Object> params = new HashMap<String, Object>();
		tables.add("company c");

		tables.add("company_server_relation csr");
		params.put("c.id", "csr.cid");
		tables.add("server s");
		params.put("s.id", "csr.sid");
		if (DataUtils.isNotNullOrEmpty(cname)) {
			params.put("c.cname & like", "'%" + cname + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(id)) {
			params.put("s.id &=", id);
		} else {
			// 解决 提供服务选择的时一级的问题
			if (DataUtils.isNotNullOrEmpty(parentId)) {
				params.put("s.id & in ", "("+parentId+")");
			}
		}
		if (DataUtils.isNotNullOrEmpty(cid)) {
			params.put("c.id &=", cid);
		}
		params.put("csr.status &=", 2);
		params.put("@order", "csr.create_at");
		params.put("@query", "csr.id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}

	public static Map<String, Object> getCserverIdsList(String cname, Integer grade, String name, String phone,
	                                                    String industry, String stage, Integer status, Long startAt, Long endAt, Long cid) {
		Set<String> tables = new HashSet();
		Map<String, Object> params = new HashMap<String, Object>();
		tables.add("user_company_relation ucr");
		tables.add("company c");
		tables.add("user u");
		params.put("ucr.uid", "u.id");
		params.put("ucr.cid", "c.id");
		params.put("ucr.status & !=", 2);
		if (DataUtils.isNotNullOrEmpty(cname)) {
			params.put("c.id & = ", "cid");
		}
		if (DataUtils.isNotNullOrEmpty(cname)) {
			params.put("c.cname & like ", "'%" + cname + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(grade)) {
			params.put("c.grade &=", grade);
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("u.name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(phone)) {
			params.put("u.mobile & like ", "'%" + phone + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(industry)) {
			params.put("c.industry &=", "'" + industry + "'");
		}
		if (DataUtils.isNotNullOrEmpty(stage)) {
			params.put("c.stage &=", stage);
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("ucr.status &=", status);
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("ucr.create_at &>=", startAt);
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("ucr.create_at &<=", endAt);
		}
		params.put("@order", "ucr.status ,ucr.create_at desc");
		params.put("@query", "ucr.id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}
	public static Map<String, Object> getServerListByparentId(Long parentId){
		Map<String, Object> params = new HashMap<String, Object>();
		Set<String> tables = new HashSet();
		tables.add("server");
		if (DataUtils.isNotNullOrEmpty(parentId)) {
			params.put(" parent_id & = ", parentId);
		}
		params.put("@order", "create_at");
		params.put("@query", "id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}
	public static Map<String, Object> getAllCompanyServerIdsList(String cname, Long id, String parentId, String status,
	                                                             Long startAt, Long endAt, Long cid) {
		Set<String> tables = new HashSet();
		Map<String, Object> params = new HashMap<String, Object>();
		tables.add("company c");

		tables.add("company_server_relation csr");
		params.put("c.id", "csr.cid");
		tables.add("server s");
		params.put("s.id", "csr.sid");
		params.put("csr.status & != ", 2);
		if (DataUtils.isNotNullOrEmpty(cname)) {
			params.put("c.cname & like ", "'%" + cname + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(cid)) {
			params.put("c.id & =", cid);
		}
		if (DataUtils.isNotNullOrEmpty(id)) {
			params.put("s.id &=", id);
		} else {
			// 解决 提供服务选择的时一级的问题
			if (DataUtils.isNotNullOrEmpty(parentId)) {
				params.put("s.id & in ", "("+parentId+")");
			}
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("csr.create_at &>", startAt);
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("csr.create_at &<", endAt);
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("csr.status & in ", "(" + status + ")");
		}
		params.put("@order", "csr.status,csr.create_at");
		params.put("@query", "csr.id");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}

	public static Map<String, Object> getIdsBycateName(Long parentId, String cateName, Long startAt, Long endAt) {
		Map<String, Object> params = new HashedMap();
		params.put("@table", "server");

		if (DataUtils.isNotNullOrEmpty(cateName)) {
			params.put("name & like ", "'%" + cateName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("create_at &>", startAt);
		}

		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("create_at &<", endAt);
		}
		// 父id
		if (DataUtils.isNotNullOrEmpty(parentId)) {
			params.put("parent_id &=", parentId);
		}
		params.put("@order", "sort");
		params.put("@query", "id");
		return params;

	}

	public static Map<String, Object> getIdsByParentIdAndSort(Long parentId, Integer sort) {
		Map<String, Object> params = new HashedMap();
		params.put("@table", "server");

		params.put("parent_id", parentId);
		if (DataUtils.isNotNullOrEmpty(sort)) {

			params.put("sort", sort);
		}
		params.put("@query", "id");
		return params;

	}

	public static Map<String, Object> getCompanyServerByIdAndUid(Long cid, Long sid) {
		Map<String, Object> params = new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("server s");
		tables.add("company c");
		tables.add("company_server_relation csr");
		params.put("s.id", "csr.sid");
		params.put("c.id", "csr.cid");
		params.put("csr.cid & =", cid);
		params.put("csr.sid &=", sid);
		params.put("csr.status", 2);
		params.put("c.status", 2);
		params.put("@query", "csr.id");

		params.put("@order", "csr.create_at desc");
		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		return params;
	}

	// 过往项目 模糊搜索
	public static Map<String, Object> getProjectByMulti(Integer type, Integer category, Integer number, String name,
	                                                    String cycleStart, String cycleEnd) {
		Map<String, Object> params = new HashedMap();
		params.put("@table", "project");

		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(cycleStart)) {
			params.put("cycle+0 &>=", cycleStart);
		}

		if (DataUtils.isNotNullOrEmpty(cycleEnd)) {
			params.put("cycle+0 &<=", cycleEnd);
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("type &=", type);
		}
		if (DataUtils.isNotNullOrEmpty(category)) {
			params.put("category &=", category);
		}
		if (DataUtils.isNotNullOrEmpty(number)) {
			params.put("number &=", number);
		}
		params.put("@order", "project.create_at desc");
		params.put("@query", "id");
		return params;

	}

	// 获得产品列表接口的方法
	public static Map<String, Object> getproductListIds() {
		Map<String, Object> params = new HashedMap();
		params.put("@table", "product");
		params.put("@order", "create_at desc");
		params.put("@query", "id");
		return params;
	}

	// 删除子组件
	public static Map<String, Object> getComponentListIdsByParentId(Long id) {
		Map<String, Object> params = new HashMap<>();

		params.put("parent_id", id);
		params.put("@table", "component");
		params.put("@order", "create_at");
		params.put("@query", "id");
		return params;
	}

	// 获得组件列表
	public static Map<String, Object> getComponentIdsByNameAndPidAndStatus(String name, Long pid, Integer status) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(pid)) {
			params.put("pid", pid);
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}
		params.put("parent_id", Component.PARENT_ID);
		params.put("@table", "component");
		params.put("@order", "create_at desc");
		params.put("@query", "id");
		return params;
	}

	//子组件搜索
	public static Map<String, Object> getChildComponentIdsParams(String name, String sname ,Long pid , Integer
		                                                                                                   status) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(sname)){
			params.put("name & like",  "'%" + sname +"%'");
		}
		if (DataUtils.isNotNullOrEmpty(pid)) {
			params.put("pid", pid);
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("parent_id & in ", "( select id from component where name like '%" + name + "%' and " +
				                              "parent_id=-1)");
		}else {
			params.put("parent_id & <> ",Component.PARENT_ID);
		}
		if(DataUtils.isNotNullOrEmpty(status)){
			params.put("status", status);
		}
		params.put("@table","component");
		params.put("@order","create_at desc");
		params.put("@query","id");
		return params;
	}

	public static Map<String, Object> getChildComponentIdsByComponentId(Long parentId) {
		Map<String, Object> params = new HashMap<>();
		if (DataUtils.isNotNullOrEmpty(parentId)) {
			params.put("parent_id", parentId);
		}
		params.put("@table", "component");
		params.put("@order", "create_at desc");
		params.put("@query", "id");
		return params;
	}

	//产品状态接口，通过pid得到组件id
	public static Map<String, Object> getComponentIdsByProductId(Long pid) {
		Map<String, Object> params = new HashMap<>();
		params.put("pid", pid);
		params.put("@table", "component");
		params.put("@order", "create_at desc");
		params.put("@query", "id");
		return params;
	}
}
