package com.ptteng.graship.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.Serve;
import com.ptteng.graship.home.service.ModulsService;
import com.ptteng.graship.home.service.ServeService;

import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Serve  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ServeController {
	private static final Log log = LogFactory.getLog(ServeController.class);

	@Autowired
	private ServeService serveService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private ModulsService modulsService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	//用户列表中查看用户的使用服务申请
	@RequestMapping(value = "/a/u/serve/{id}", method = RequestMethod.GET)
	public String getserveList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id) throws Exception {



		try{
			Serve serve = serveService.getObjectById(id);

			model.addAttribute("code", 0);
			model.addAttribute("serves", serve);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get serve error,id is  " + id);
			model.addAttribute("code", -1);
		}
		return "/graship-home-service/serve/json/serveDetail";
	}
    
    

    
	//搜索根据条件搜索公司
//	@RequestMapping(value = "/a/u/serve", method = RequestMethod.GET)
//	public String getServe(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model,String cpyName,Long servea,
//						   Long serveb,Integer staus,Long startAt,Long endAt,Integer page,Integer size)
//			throws Exception {
//		if (page == null) {
//			page = 1;
//
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}
//		List<Long> ids=null;
//		List<Serve> serves=null;
//		log.info( "get serve is cpyName"+cpyName+"servea is"+servea+"serveb"+serveb+"staus is"+staus);

//		try{
//			Map<String, Object> param = DynamicUtil.getSeaveListIds(cpyName,servea,
//					serveb,staus,startAt,endAt);
//			log.info("get regist ids param is "+param);
//			ids = serveService.getIdsByDynamicCondition(Serve.class,param,start,size);
//			serves = serveService.getObjectsByIds(ids);
//			log.info("get serves and ids is"+ids);
//			model.addAttribute("code", 0);
//			model.addAttribute("serves", serves);
//		}catch (Throwable t) {
//			t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get serve error,id is  " + ids);
//			model.addAttribute("code", -1);
//		}
//
//		return "/graship-home-service/serve/json/serveListJson";
//	}


	//更改服务状态 2申请1同意0未申请-1拒绝
	@RequestMapping(value = "/a/u/serve/regist/{id}", method = RequestMethod.PUT)
	public String updateServeRegist(HttpServletRequest request,
								  HttpServletResponse response, ModelMap model,@PathVariable Long id,Integer staus)
			throws Exception {



		log.info("update serve regist id="+id);

		try {
			Serve serve = serveService.getObjectById(id);
			serve.setStaus(staus);
			serveService.update(serve);
				log.info("update serve regist success");

			model.addAttribute("code", 0);



		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  " );
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	//删除服务申请
	@RequestMapping(value = "/a/u/serve/regist/{id}", method = RequestMethod.DELETE)
	public String deleteServeRegist(HttpServletRequest request,
									HttpServletResponse response, ModelMap model,@PathVariable Long id)
			throws Exception {



		log.info("update serve regist id="+id);

		try {


			serveService.delete(id);

				log.info("update serve regist success");

			model.addAttribute("code", 0);



		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  " );
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	//上下架公司服务
	@RequestMapping(value = "/a/u/serve/upandown/{id}", method = RequestMethod.PUT)
	public String frezeServeRegist(HttpServletRequest request,
									HttpServletResponse response, ModelMap model,@PathVariable Long id)
			throws Exception {



		log.info("update serve regist id="+id);

		try {
			Serve serve = serveService.getObjectById(id);
			if (serve.getStaus().equals(Serve.frezzing)) {
				serve.setStaus(Serve.aggree);
				log.info("up serve success ");
			} else if (serve.getStaus().equals(Serve.aggree)) {
				serve.setStaus(Serve.frezzing);
				log.info("freeze serve success");
			} else {
				model.addAttribute("code", -8004);
				return "/common/success";
			}
			model.addAttribute("code", 0);



		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("up or freeze serve fail  " );
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	@RequestMapping(value = "/web/a/serve/{id}", method = RequestMethod.PUT)
	public String updateServeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Serve serve) throws Exception {
		
		log.info("update serve : serve= " + serve);
		
		try {
			
			serveService.update(serve);

			model.addAttribute("code", 0);

			model.addAttribute("serve", serve);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update serve error,id is  " + serve.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/serve", method = RequestMethod.POST)
	public String addServeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Serve serve) throws Exception {
		
		log.info("update serve : serve= " + serve);
		
		try { 
			serve.setId(null);

			serveService.insert(serve);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add serve error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/serve/{id}", method = RequestMethod.DELETE)
	public String deleteServeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete serve : id= " + id);
		try {
			serveService.delete(id);

			log.info("add serve success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete serve error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/serve", method = RequestMethod.GET)
	public String getMultiServeJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Serve> serveList = serveService.getObjectsByIds(idList);
			log.info("get  serve data is " + serveList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",serveList.size());

			model.addAttribute("serveList", serveList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get serve error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/serve/json/serveListJson";
	}
	
	
}

