package com.ptteng.graship.admin.controller;


import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Project;
import com.ptteng.graship.home.service.ProjectService;
import com.qding.common.util.DataUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Project  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class ProjectController {
	private static final Log log = LogFactory.getLog(ProjectController.class);

	@Autowired
	private ProjectService projectService;






	/**
	 * 模糊查询
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/project/search", method = RequestMethod.GET)
	public String getprojectList(HttpServletRequest request,
	                             HttpServletResponse response, ModelMap model,Integer page,Integer size,Integer type,
	                             Integer category, Integer number, String name, String cycleStart,String cycleFinish) throws Exception {

		log.info("page:" + page + ", size:" + size + ", type:" + type + ", category:" + category +
			         ", number:" + number + ", name:" + name + ", cycleStart:" + cycleStart + ", cycleFinish:" + cycleFinish);
		//验证搜索区间是否合法(必须先判空)
		if(DataUtils.isNotNullOrEmpty(cycleStart) && DataUtils.isNotNullOrEmpty(cycleFinish)){
			if(Double.valueOf(cycleStart) > Double.valueOf(cycleFinish) ){
				model.addAttribute("code", -10003);
				log.info("region of search is illegal");
				return "/data/json";
			}
		}

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			//拼接动态查询条件
			Map<String,Object> param = DynamicUtil.getProjectByMulti(type, category, number, name, cycleStart, cycleFinish);
			log.info("param is :" + param);
			//查询所有满足条件的项目的id
			List<Long> ids = projectService.getIdsByDynamicCondition(Project.class, param, start, size);
			log.info("get ids is" +  ids);
			if (CollectionUtils.isEmpty(ids)) {
				log.info("ids is empty");
				model.addAttribute("code", 0);
			}
			//根据id查询项目列表
			List<Project> projectList = projectService.getObjectsByIds(ids);
			if (CollectionUtils.isEmpty(projectList)) {
				log.info("projectList is empty");
				model.addAttribute("code", 0);
			}
			log.info("get project data is " + projectList.size());
			//获取总数
			List<Long> totalList = projectService.getIdsByDynamicCondition(Project.class, param, 0, Integer.MAX_VALUE);
			int total = totalList.size();
			int totalPage = (total/size) + 1;
			log.info("total:" + total + ", tptalPage:" + totalPage);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("projectList", projectList);

		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("get project list error,page is  " + start + " , size " + size);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/project/json/projectListAllJson";
	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */


	@RequestMapping(value = "/c/project1 ", method = RequestMethod.GET)
	public String getProjectIdsByTypeAndStatusOrderByCreateAtList1(HttpServletRequest request,
	                                                               HttpServletResponse response, ModelMap model,Integer type,Integer status) throws Exception {

		log.info("/project  to /project/view/projectList");

		return "/graship-home-service/project/view/projectList";
	}







	@RequestMapping(value = "/c/project", method = RequestMethod.GET)
	public String getProject(HttpServletRequest request,
	                         HttpServletResponse response, ModelMap model,  Long id)
		throws Exception {

		log.info("/project/" + id + "  to /project/view/projectDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/project/view/projectDetail";
	}





	/**
	 * 根据项目id查询项目信息（后台）
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/project/{id}", method = RequestMethod.GET)
	public String getProjectJson(HttpServletRequest request,
	                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
		throws Exception {

		log.info("get data : id= " + id);
		//参数验证
		if(DataUtils.isNullOrEmpty(id)){
			log.info("project id is null");
			model.addAttribute("code", -1000);
			return "/data/json";
		}
		try {
			Project project = projectService.getObjectById(id);
			if(project == null){
				log.info("project is not find id is" + id);
				model.addAttribute("code", -10001);
				return "/data/json";
			}
			log.info("get project data is " + project);
			model.addAttribute("code", 0);
			model.addAttribute("project", project);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("get project error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/project/json/projectDetailJson";
	}

	/**
	 * 编辑项目
	 * @param request
	 * @param response
	 * @param model
	 * @param project
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/project/{id}", method = RequestMethod.PUT)
	public String updateProjectJson(HttpServletRequest request,
	                                HttpServletResponse response, ModelMap model, @PathVariable Long id,
	                                @RequestBody Project project) throws Exception {

		log.info("update project : project= " + project + ", id: " + id);
		//根据id查找是否有该项目
		Project oldProject = new Project();
		try {
			oldProject = projectService.getObjectById(id);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(oldProject == null){
			log.info("project is not find");
			model.addAttribute("code", -1000);
			return "/data/json";
		}

		//验证参数是否合法
		Boolean result = verifyProject(project);
		if(result){
			//赋值
			oldProject.setType(project.getType());
			oldProject.setCategory(project.getCategory());
			oldProject.setNumber(project.getNumber());
			oldProject.setName(project.getName());
			oldProject.setCycle(project.getCycle());
			oldProject.setBannerImg(project.getBannerImg());
			oldProject.setIntroduce(project.getIntroduce());
			oldProject.setFunction(project.getFunction());
			oldProject.setFeature(project.getFeature());
			oldProject.setFund(project.getFund());
			oldProject.setVersion(project.getVersion());
			oldProject.setFrameImg(project.getFrameImg());
			//这三个url可以为空，为空的时候就传null
			oldProject.setAndroidUrl(project.getAndroidUrl());
			oldProject.setIosUrl(project.getIosUrl());
			oldProject.setWebsiteUrl(project.getWebsiteUrl());
		}else{
			model.addAttribute("code", -10002);
			return "/data/json";
		}

		try {
			projectService.update(oldProject);
			log.info("update project success");
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("update project error,id is  " + project.getId());
			model.addAttribute("code", -1);

		}
		return "/data/json";
	}

	/**
	 * 新增项目
	 * @param request
	 * @param response
	 * @param model
	 * @param project
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/project", method = RequestMethod.POST)
	public String addProjectJson(HttpServletRequest request,
	                             HttpServletResponse response, ModelMap model,
	                             @RequestBody Project project) throws Exception {

		log.info("insert project : project= " + project);

		//验证参数是否合法
		Boolean result = verifyProject(project);
		if(result){
			//设置status默认值为1(下架)
			project.setStatus(Project.STATUS_DOWN);
		}else{
			model.addAttribute("code", -10002);
			return "/data/json";
		}
		try {
			projectService.insert(project);
			log.info("add project success");
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("add project error ");
			model.addAttribute("code", -1);
		}
		return "/data/json";
	}

	/**
	 * 根据id删除项目
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/project/{id}", method = RequestMethod.DELETE)
	public String deleteProjectJson(HttpServletRequest request,
	                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
		throws Exception {
		log.info("delete project : id= " + id);
		//参数验证
		if(DataUtils.isNullOrEmpty(id)){
			log.info("delete project id  is null");
			model.addAttribute("code", -1000);//返回参数为空
			return "/data/json";
		}
		try {
			Project project = projectService.getObjectById(id);
			if(project == null){
				log.info("project id " + id + " not find");
				model.addAttribute("code", -10001);//返回项目id不存在
				return "/data/json";
			}
			projectService.delete(id);
			log.info("delete project success");
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("delete project error,id is  " + id);
			model.addAttribute("code", -1);
		}
		return "/data/json";
	}

	/**
	 * 编辑项目状态
	 * @param request
	 * @param response
	 * @param model
	 * @param project
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/project/status/{status}/{id}", method = RequestMethod.PUT)
	public String updateProjectStatus(HttpServletRequest request,
	                                  HttpServletResponse response, ModelMap model, @PathVariable Integer status,
	                                  @PathVariable Long id) throws Exception {
		log.info("get data status:" + status + ", id:" + id);
		if(DataUtils.isNullOrEmpty(status) || DataUtils.isNullOrEmpty(id)){
			model.addAttribute("code", -1000);
			return "/data/json";
		}
		try {
			//根据id得到project
			Project project = projectService.getObjectById(id);
			log.info("project :" + project);
			if(project == null){
				log.info("project id " + id + " not find");
				model.addAttribute("code", -10001);//返回项目id不存在
				return "/data/json";
			}
			//编辑状态（上下架）
			project.setStatus(status);
			projectService.update(project);
			log.info("update project status  success");
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			log.error(t.getMessage(),t);
			log.error("update status fail");
			model.addAttribute("code", -1);
		}
		
		return "/data/json";
		
	}
	
	
	/**
	 * 验证project字段
	 * @param request
	 * @param response
	 * @param model
	 * @param project
	 * @return
	 */
	public  Boolean verifyProject(Project project){
		//参数验证
		if(DataUtils.isNullOrEmpty(project.getType())){
			log.info(" project type is null or illegal");
			return false;
		}
		if(DataUtils.isNullOrEmpty(project.getCategory())){
			log.info(" project category is null or illegal");
			return false;
		}
		//name长度不能超过10
		if(DataUtils.isNullOrEmpty(project.getName()) || project.getName().length() > 10 ){
			log.info(" project name is null or illegal");
			return false;
		}
		//验证cycle是否非空和符合".5"的形式
		String regCycle = "^[0-9]+(\\.[5])?$";
		Matcher mCycle = Pattern.compile(regCycle).matcher(project.getCycle());
		if(DataUtils.isNullOrEmpty(project.getCycle()) || !(mCycle.matches())){
			log.info("project cycle is null or illegal");
			return false;
		}
		//number不为空，不小于0，不大于999
		if(DataUtils.isNullOrEmpty(project.getNumber()) || project.getNumber() < 0 || project.getNumber() > 999){
			log.info("project number is null or illegal");
			return false;
		}
		if(DataUtils.isNullOrEmpty(project.getBannerImg())){
			log.info("project bannerImg is null or illegal");
			return false;
		}
		//不为空字数也不能超过1000
		if(DataUtils.isNullOrEmpty(project.getIntroduce())  || project.getIntroduce().length() > 10000){
			log.info("project introduce is null or illegal");
			return false;
		}
		//function长度不能超过300
		if(DataUtils.isNullOrEmpty(project.getFunction()) || project.getFunction().length() > 300){
			log.info("project function is null or illegal");
			return false;
		}
		//不为空字数也不能超过1000	
		if(DataUtils.isNullOrEmpty(project.getFeature()) || project.getFeature().length() > 10000){
			log.info("project feature is null or illegal");
			return false;
		}
		//资金fund需要保留两位小数
		String regFund = "^[0-9]+(\\.[0-9]{1,2})?$";
		Matcher mFund = Pattern.compile(regFund).matcher(project.getFund());
		if(DataUtils.isNullOrEmpty(project.getFund()) || !(mFund.matches())){
			log.info("project fund is null or illegal");
			return false;
		}
		if(DataUtils.isNullOrEmpty(project.getVersion())){
			log.info("project version is null or illegal");
			return false;
		}
		if(DataUtils.isNullOrEmpty(project.getFrameImg())){
			log.info("project frameImg is null or illegal");
			return false;
		}
		
		return true;
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	@RequestMapping(value = "/a/multi/project", method = RequestMethod.GET)
	public String getMultiProjectJson(HttpServletRequest request,
	                                  HttpServletResponse response, ModelMap model, Long[] ids)
		throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<Project> projectList = projectService.getObjectsByIds(idList);
			log.info("get  project data is " + projectList);

			model.addAttribute("code", 0);
			model.addAttribute("total",projectList.size());

			model.addAttribute("projectList", projectList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get project error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/project/json/projectListJson";
	}
	
	
	
	
	
}

