package com.ptteng.graship.admin.controller;

import com.ptteng.graship.admin.util.ComparatorList;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.service.ModulsService;

import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2016/6/14.
 */
@Controller
public class ModulsController {
    private static final Log log = LogFactory.getLog(ModulsController.class);

    @Autowired
    private ModulsService modulsService;
    @Autowired
    private CookieUtil cookieUtil;


//    /**
//     * 类别管理
//     * @param
//     * @return
//     * @throws ServiceException
//     * @throws ServiceDaoException
//     */

  //首页获得模块父类接口
    @RequestMapping(value = "/a/admin/moduls/lista", method = RequestMethod.GET)
    public String getserveaList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                Integer page,Integer size,Integer limit,String name,Long startAt,Long endAt,Integer grade,Long parentId,Integer groups) throws Exception {
        log.info("get moduls and moduls ids");
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 100;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> param = DynamicUtil.getModulsList(name,startAt,endAt,grade,parentId, groups);

            List<Long> modulsIds = modulsService.getIdsByDynamicCondition(Moduls.class, param, start, size);
            List<Moduls> modulsList = modulsService.getObjectsByIds(modulsIds);
            log.info("param is" + param);
           
            model.addAttribute("modulsList", modulsList);
            model.addAttribute("code", 0);
        
        }  catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get moduls idList error,start=  " + start+"limit="+limit);
            model.addAttribute("code", -1);
        }

 
        log.info("get success ids is " );

        return "/graship-home-service/moduls/json/messageListJson";
    }

  //首页获得模块点开父类接口获得子类接口
    @RequestMapping(value = "/a/admin/moduls/listb", method = RequestMethod.GET)
    public String getservebList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                Integer page,Integer size,Integer limit,String name,Long startAt,Long endAt,Integer grade,Long parentId,Integer groups) throws Exception {
        log.info("get moduls and moduls ids is = haha");
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 100;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            
        	Map<String, Object> param = DynamicUtil.getModulsListB(name,startAt,endAt,grade,parentId, groups);
            List<Long> modulsIds = modulsService.getIdsByDynamicCondition(Moduls.class, param, start, size);
            List<Moduls> modulsList = modulsService.getObjectsByIds(modulsIds);
            log.info("param is" + param);
           
            model.addAttribute("modulsList", modulsList);
            model.addAttribute("code", 0);
        
        }  catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get moduls idList error,start=  " + start+"limit="+limit);
            model.addAttribute("code", -1);
        }

 
        log.info("get success ids is " );

        return "/graship-home-service/moduls/json/messageListJson";
    }

    
    
    
    //添加类别管理
    @RequestMapping(value = "/a/admin/moduls", method = RequestMethod.POST)
    public String insertModuls(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model,
                               @RequestBody List<Map> modulsList) throws Exception {
        log.info("insert moduls by modulsList is="+modulsList);
        log.info("=============="+modulsList.get(0));
//        Long uid=Long.valueOf(cookieUtil.getKeyIdentity(request,
//                com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        try {
            Long parentId = null;
            Moduls moduls = new Moduls();
            moduls.setUpdateAt(System.currentTimeMillis());
            if (modulsList.size()>0) {
                Map<String, Object> map = modulsList.get(0);
                if (!map.get("grade").equals(1)) {
                    model.addAttribute("code", -8003);
                    return "/common/success";
                }
//                moduls.setCreateBy(uid);
                moduls.setName(String.valueOf(map.get("name")));
//                moduls.setGrade(Integer.valueOf(map.get("grade")));
                int grade=Integer.valueOf(String.valueOf(map.get("grade")));
                moduls.setGrade(grade);
                moduls.setLevel(getMaxLevel(grade));
               modulsService.insert(moduls);
                if (modulsList.size() > 1) {
                    int level = 1;
                    for (int i=1;i<modulsList.size();i++) {
                        map = modulsList.get(i);
                        moduls.setGrade(2);
                        moduls.setLevel(level);
                        moduls.setParentId(parentId);
                        moduls.setName(String.valueOf(map.get("name")));
//                        moduls.setCreateBy(uid);
                        modulsService.insert(moduls);
                        level++;
                    }
                }
            }
            log.info("insert modulsList success");
            model.addAttribute("code", 0);
        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        if(log.isInfoEnabled()) {
            log.info("add moduls success");
        }
        return "/common/success";
    }


    //删除模块
    @RequestMapping(value = "/a/admin/moduls/{id}", method = RequestMethod.DELETE)
    public String deleteModuls(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id) throws Exception {
        log.info("delete moduls and moduls id is ="+id);
        Boolean result=false;

        try {
            Moduls moduls = modulsService.getObjectById(id);
            if (moduls.getGrade().equals(Moduls.PARENT_ID)) {
                List<Long> ids = modulsService.getModulsIdsByParent(moduls.getId());
                modulsService.deleteList(Moduls.class,ids);
            }
             modulsService.delete(id);
            log.info("delete moduls  id is "+id);
            model.addAttribute("code", 0);
        }  catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete user error,id is  " + id);
            model.addAttribute("code", -1);
        }

        log.info("delete success id is "+id);

        return "/common/success";
    }

   
    //==============================上下移动=============================================
    @RequestMapping(value = "/a/admin/moduls/{id}", method = RequestMethod.PUT)
    public String updateModuls(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id,@RequestBody List<Moduls> modulsList) throws Exception {
        log.info("update moduls and moduls id is ="+id);
        Boolean result=false;
        Long uid=Long.valueOf(cookieUtil.getKeyIdentity(request,
                com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        try {

            Moduls moduls = modulsService.getObjectById(id);
            Long create_at = moduls.getCreateAt();
            Integer level = moduls.getLevel();
            if (moduls.getGrade().equals(Moduls.PARENT_ID)) {
                List<Long> ids = modulsService.getModulsIdsByParent(moduls.getId());
                modulsService.deleteList(Moduls.class,ids);
            }
            modulsService.delete(id);
            
            Long parentId = null;
            moduls = null;
            if (modulsList.size()>0) {
                moduls = modulsList.get(0);
                if (moduls.getGrade() != 1) {
                    model.addAttribute("code", -8003);
                    return "/common/success";
                }
                moduls.setCreateBy(uid);
                moduls.setCreateAt(create_at);
                moduls.setLevel(level);
                parentId = modulsService.insert(moduls);
                if (modulsList.size() > 1) {
                     level = 1;
                    for (int i=1;i<modulsList.size();i++) {
                        moduls = modulsList.get(i);
                        moduls.setGrade(2);
                        moduls.setLevel(level);
                        moduls.setParentId(parentId);
                        moduls.setCreateBy(uid);
                        modulsService.insert(moduls);
                        level++;
                    }
                }
            }
            log.info("update moduls  id is "+id);
            model.addAttribute("code", 0);
        }  catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -1);
        }


        log.info("update success id is "+id);

        return "/common/success";
    }


    public int getMaxLevel(int grade) {
        int level=1;
        try {
            List<Long> modulsIds=modulsService.getModulsAllByGrade(grade);
            Long modulsId = modulsIds.get(modulsIds.size() - 1);
            Moduls moduls = modulsService.getObjectById(modulsId);
            level = moduls.getLevel();
        } catch (Throwable e) {
            e.printStackTrace();
            log.info("get max level error");
        }
        return level;
    }

}
