package com.ptteng.graship.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;

import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.service.MessageService;

import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Message  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class MessageController {
	private static final Log log = LogFactory.getLog(MessageController.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private CookieUtil cookieUtil;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
//获得所有message
	@RequestMapping(value = "/a/u/message/all", method = RequestMethod.GET)
	public String getmessageListAll(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer start,Integer limit) throws Exception {
			Long id=Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			log.info("get message by id and id is "+id);
		List<Long> ids=null;
		List<Message> messagesList=null;
			try{
				ids=messageService.getMessageIds(id, start, limit);
				log.info("get message ids is" + ids);
				messagesList = messageService.getObjectsByIds(ids);
				Integer total=ids.size();
				model.addAttribute("total", total);
				model.addAttribute("code",0);
				model.addAttribute("messagesList", messagesList);
			}catch (Throwable t) {
				t.printStackTrace();
				log.error(t.getMessage());
				log.error("get message error,id is  " + ids);
				model.addAttribute("code", -1);
			}
		
		
		log.info("get /messageList success all");

		return "/graship-home-service/message/json/messageListJson";
	}


//获取任意状态的信息
	@RequestMapping(value = "/a/u/message/Stage", method = RequestMethod.GET)
	public String getmessageListStage(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,Integer page,Integer size,Integer mstage) throws Exception {
		Long createBy=Long.valueOf(cookieUtil.getKeyIdentity(request,
				com.qding.common.util.http.cookie.CookieUtil.USER_ID));
		log.info("get message by id and id is "+createBy);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		List<Long> ids=null;
		Map param=null;
		List<Message> messagesList=null;
		if (mstage == null) {
			mstage=0;
		}
		try{
			param = DynamicUtil.getmessageListStage(mstage, createBy);
			log.info("the sql is "+param);
			ids = messageService.getIdsByDynamicCondition(Message.class,param,start,size);
			log.info("get message ids is" + ids);

			messagesList = messageService.getObjectsByIds(ids);
			Integer total=ids.size();
			model.addAttribute("total", total);
			model.addAttribute("messagesList", messagesList);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get message error,id is  " + ids);
			model.addAttribute("code", -1);
		}


		log.info("get /messageList success all");

		return "/graship-home-service/message/json/messageListJson";
	}
    

    
	//批量删除
	@RequestMapping(value = "/a/u/message", method = RequestMethod.DELETE)
	public String getMessage(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		log.info("delete message ids is "+ids);
		List<Long> idlist = Arrays.asList(ids);
		if(idlist==null){
			model.addAttribute("code", -1);

			log.info("ids can't be null");
		}
		try{
			for(int s=0;s<ids.length;s++){
				Boolean q = messageService.delete(ids[s]);
			}
			log.info("delete message success idlist is"+idlist);
			model.addAttribute("code", 0);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete message error,id is  " + idlist);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

//批量设为已读
	@RequestMapping(value = "/a/u/message", method = RequestMethod.PUT)
	public String updateMessage(HttpServletRequest request,
							 HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		log.info("delete message ids is "+ids);
		List<Long> idlist = Arrays.asList(ids);
		if(idlist==null){
			model.addAttribute("code", -1);
			log.info("ids can't be null");
		}
		try{
			for(int s=0;s<ids.length;s++){
				Message message=messageService.getObjectById(ids[s]);
				message.setIfRead(1);
				message.setUpdateAt(System.currentTimeMillis());
				Boolean q = messageService.update(message);
			}
			log.info("delete message success idlist is"+idlist);
			model.addAttribute("code", 0);
		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete message error,id is  " + idlist);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	
	
	
	    
	

	@RequestMapping(value = "/web/a/message/{id}", method = RequestMethod.GET)
	public String getMessageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Message message = messageService.getObjectById(id);
			log.info("get message data is " + message);

			model.addAttribute("code", 0);

			model.addAttribute("message", message);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get message error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/message/json/messageDetailJson";
	}

	@RequestMapping(value = "/web/a/message/{id}", method = RequestMethod.PUT)
	public String updateMessageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Message message) throws Exception {
		
		log.info("update message : message= " + message);
		
		try {
			
			messageService.update(message);

			model.addAttribute("code", 0);

			model.addAttribute("message", message);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update message error,id is  " + message.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/message", method = RequestMethod.POST)
	public String addMessageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Message message) throws Exception {
		
		log.info("update message : message= " + message);
		
		try { 
			message.setId(null);

			messageService.insert(message);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add message error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/message/{id}", method = RequestMethod.DELETE)
	public String deleteMessageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete message : id= " + id);
		try {
			messageService.delete(id);

			log.info("add message success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete message error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/message", method = RequestMethod.GET)
	public String getMultiMessageJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Message> messageList = messageService.getObjectsByIds(idList);
			log.info("get  message data is " + messageList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",messageList.size());

			model.addAttribute("messageList", messageList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get message error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/message/json/messageListJson";
	}
	
	
}

