package com.ptteng.graship.admin.controller;

import java.util.ArrayList;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.graship.admin.ex.CompanyEX;
import com.ptteng.graship.admin.ex.CompanyServerEX;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.service.CompanyServerRelationService;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.UserCompanyRelationService;
import com.ptteng.graship.home.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Company crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CompanyController {
	private static final Log log = LogFactory.getLog(CompanyController.class);

	@Autowired
	private CompanyService companyService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private UserService userService;
	@Autowired
	private CompanyServerRelationService companyServerRelatioonService;
	@Autowired
	private UserCompanyRelationService userCompanyRelationService;

	/**
	 * 公司列表
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/company/list", method = RequestMethod.GET)
	public String getcompanyList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String cname,
			String mobile, Integer grade, String name, String phone, Integer page, Integer size, Long uid) {
		log.info("cname:" + cname + " mobile:" + mobile + " grade:" + grade + " name:" + name + " phone:" + phone
				+ ",uid:" + uid);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = DynamicUtil.getCompanyList(cname, mobile, grade, name, phone, uid);
		List<Long> cList;

		try {

			cList = userCompanyRelationService.getIdsByDynamicCondition(Company.class, param, start, size);
			List<UserCompanyRelation> comList = userCompanyRelationService.getObjectsByIds(cList);
			List<Long> totalList = userCompanyRelationService.getIdsByDynamicCondition(Company.class, param, 0,
					Integer.MAX_VALUE);
			int total = totalList.size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}
			List<CompanyEX> companyList = new ArrayList<CompanyEX>();
			for (UserCompanyRelation c : comList) {
				User u = new User();

				if (DataUtils.isNotNullOrEmpty(c.getUid())) {
					u = userService.getObjectById(c.getUid());
				}
				Company com = new Company();
				com = companyService.getObjectById(c.getCid());
				CompanyEX company = new CompanyEX();
				company.setCid(com.getId());
				if (null != com) {
					company.setCname(com.getCname());
					company.setGrade(com.getGrade());
					company.setMobile(com.getMobile());
				}
				if (null != u && !"".equals(u)) {
					//if(DataUtils.isNotNullOrEmpty(c.getGrade()+"")){
					//	company.setGrade(c.getGrade());
					//}else{
					//	company.setGrade(-1);
					//}
                    
					company.setName(u.getName());
					company.setUid(u.getId());
					company.setPhone(u.getMobile());
				}
				company.setStatus(c.getStatus());
				company.setRelationId(c.getId());
				companyList.add(company);
			}
			model.addAttribute("companyList", companyList);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}

		return "/graship-home-service/company/json/companyListJson";
	}

	/**
	 * 查看公司
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/a/company/{id}", method = RequestMethod.GET)
	public String getuserCompany(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Long cid,Long relationId) {
		log.info("id:" + id);
		try {
			UserCompanyRelation userCompanyRelation=userCompanyRelationService.getObjectById(relationId);
			Company company = companyService.getObjectById(cid);
			User user = userService.getObjectById(id);
			CompanyEX ex = new CompanyEX();
			if (null != company) {
				ex.setCid(company.getId());
				ex.setCname(company.getCname());
				//if(DataUtils.isNotNullOrEmpty(userCompanyRelation.getGrade()))
				//{
				//ex.setGrade(userCompanyRelation.getGrade());
				//}
				ex.setGrade(company.getGrade());
				ex.setRelationId(relationId);
				ex.setMobile(company.getMobile());
				ex.setAdvantage(company.getAdvantage());
				ex.setAdvertising(company.getAdvertising());
				ex.setDetails(company.getDetails());
				ex.setLogo(company.getLogo());
				ex.setProfile(company.getProfile());
				ex.setRelatedServices(company.getRelatedServices());
				ex.setWebsite(company.getWebsite());
				//if(DataUtils.isNotNullOrEmpty(userCompanyRelation.getCooperationLevel()))
				//{
				//ex.setCooperationLevel(userCompanyRelation.getCooperationLevel());
				//}
				ex.setCooperationLevel(company.getCooperationLevel());
			}
			if (null != user) {
				ex.setName(user.getName());
				ex.setPhone(user.getMobile());
				ex.setUid(user.getId());
			}

			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("company", ex);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/companyDetailJson";

	}

	/**
	 * 编辑公司
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param logo
	 * @param phone
	 * @param website
	 * @param cname
	 * @param mobile
	 * @param name
	 * @param profile
	 * @param grade
	 * @param details
	 * @param relatedServices
	 * @param advantage
	 * @param advertising
	 * @return
	 */
	@RequestMapping(value = "/a/company/{id}", method = RequestMethod.PUT)
	public String updateUserCompany(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, String logo, String phone, String website, String cname, String mobile, String name,
			String profile, Integer grade, String details, String relatedServices, String advantage, String advertising,
			Long cid, String cooperationLevel,Long relationId) {
		log.info(" id:" + id + ",logo:" + logo + ", phone:" + phone + ", website" + website + ", cname:" + cname
				+ ", mobile:" + mobile + ", name:" + name + ", profile:" + profile + ", grade:" + grade + ", details:"
				+ details + ", relatedServices:" + relatedServices + ", advantage:" + advantage + ", advertising:"
				+ advertising);

		try {

			UserCompanyRelation userCompanyRelation=userCompanyRelationService.getObjectById(relationId);
			Company company = companyService.getObjectById(cid);
			User user = userService.getObjectById(id);
			if (null != company) {
				company.setAdvantage(advantage);
				company.setAdvertising(advertising);
				company.setCname(cname);
				company.setDetails(details);
				//userCompanyRelation.setGrade(grade);
				if("0".equals(grade+""))
				{
					//如果公司等级为无合作则删除该关系
					userCompanyRelationService.delete(relationId);
				}
				company.setGrade(grade);
				company.setLogo(logo);
				company.setMobile(mobile);
				company.setProfile(profile);
				company.setRelatedServices(relatedServices);
				company.setWebsite(website);
				//userCompanyRelation.setCooperationLevel(cooperationLevel);
				company.setCooperationLevel(cooperationLevel);
				companyService.update(company);
				//userCompanyRelationService.update(userCompanyRelation);

			}
			if (null != user) {
				user.setName(name);
				user.setMobile(phone);
				userService.update(user);
			}

			model.addAttribute("code", 0);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", -10000);
		}
		return "/graship-home-service/company/json/result";

	}

	/**
	 * 公司认证列表
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param cname
	 * @param grade
	 * @param name
	 * @param phone
	 * @param industry
	 * @param stage
	 * @param status
	 * @param startAt
	 * @param endAt
	 * @param page
	 * @param size
	 * @return
	 */
	@RequestMapping(value = "/a/company/certifacated/list", method = RequestMethod.GET)
	public String getcompanyList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String cname,
			Integer grade, String name, String phone, String industry, String stage, Integer status, Long startAt,
			Long endAt, Integer page, Integer size, Long cid) {
		log.info(" cname:" + cname + ", grade:" + grade + ", name:" + name + ", phone:" + phone + ", industry:"
				+ industry + ", stage:" + stage + ", status:" + status + ", startAt:" + startAt + ", endAt:" + endAt);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = new HashMap<String, Object>();
		param = DynamicUtil.getCserverIdsList(cname, grade, name, phone, industry, stage, status, startAt, endAt, cid);
		try {
			List<Long> cList = userCompanyRelationService.getIdsByDynamicCondition(UserCompanyRelation.class, param,
					start, size);
			List<UserCompanyRelation> companyServerList = userCompanyRelationService.getObjectsByIds(cList);
			List<Long> allList = userCompanyRelationService.getIdsByDynamicCondition(UserCompanyRelation.class, param,
					0, Integer.MAX_VALUE);
			int total = allList.size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}
			List<CompanyEX> companyServerListEx = new ArrayList<CompanyEX>();
			for (UserCompanyRelation c : companyServerList) {
				User u = new User();
				Company company = new Company();
				if (StringUtil.isEmpty(c.getUid() + "")) {

				} else {
					u = userService.getObjectById(c.getUid());
				}
				if (StringUtil.isEmpty(c.getCid() + "")) {

				} else {
					company = companyService.getObjectById(c.getCid());
				}
				CompanyEX ex = new CompanyEX();
				ex.setRelationId(c.getId());
				ex.setCid(c.getCid());
				if (null != company) {
					ex.setCname(company.getCname());
					ex.setIndustry(company.getIndustry());
					ex.setStage(company.getStage());
					//ex.setStatus(company.getStatus());
				}
				ex.setStatus(c.getStatus());
				ex.setCreateAt(c.getCreateAt());
				if (null != u) {
					ex.setName(u.getName());
					ex.setPhone(u.getMobile());
				}

				//ex.setStatus(c.getStatus());
				companyServerListEx.add(ex);

			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("companyList", companyServerListEx);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/companyListJson";

	}

	/**
	 * 查看
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/a/user/company", method = RequestMethod.GET)
	public String getcompany(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id) {
		log.info("id:" + id);
		try {
			UserCompanyRelation userCompanyRelation = userCompanyRelationService.getObjectById(id);
			User user = new User();
			Company company = new Company();
			if (null != userCompanyRelation) {
				if (null != userCompanyRelation.getUid() && !"".equals(userCompanyRelation.getUid())) {
					user = userService.getObjectById(userCompanyRelation.getUid());
				}
				if (null != userCompanyRelation.getCid() && !"".equals(userCompanyRelation.getCid())) {
					company = companyService.getObjectById(userCompanyRelation.getCid());
				}
				if (DataUtils.isNullOrEmpty(userCompanyRelation.getBarcode())) {
					company.setBarcode("");
				} else {
					company.setBarcode(userCompanyRelation.getBarcode());
				}
				if (DataUtils.isNullOrEmpty(userCompanyRelation.getBarcode())) {
					company.setLicense("");
				} else {
					company.setLicense(userCompanyRelation.getLicense());
				}
				if (DataUtils.isNullOrEmpty(userCompanyRelation.getBarcode())) {
					company.setCreditCode("");
				} else {
					company.setCreditCode(userCompanyRelation.getCreditCode());
				}
				if (DataUtils.isNotNullOrEmpty(userCompanyRelation.getStatus())) {
					company.setStatus(userCompanyRelation.getStatus());
				} else {

				}
				model.addAttribute("code", 0);
				model.addAttribute("company", company);
				model.addAttribute("user", user);
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", -10000);
		}
		return "/graship-home-service/company/json/certifacationCompany";

	}

	/**
	 * 申请
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/a/user/company", method = RequestMethod.PUT)
	public String applycompany(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
			Integer status) {
		log.info("id:" + id + ",status:" + status);
		try {
			Company company = companyService.getObjectById(id);
			if (status == 2) {
				log.info("申请通过！");
				company.setStatus(status);
				company.setGrade(1);

			} else if (status == 3) {
				log.info("申请拒绝！");
				company.setStatus(status);
				company.setCreateAt(System.currentTimeMillis());
			}
			companyService.update(company);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/result";

	}

	// 删除用户合作入住信息
	@RequestMapping(value = "/a/user/company/{id}", method = RequestMethod.DELETE)
	public String deletecompany(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) {
		log.info("id:" + id);
		try {
			userCompanyRelationService.delete(id);
			model.addAttribute("code", 0);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", -10000);
		}
		return "/graship-home-service/company/json/result";

	}

}
