/**
 * 
 */
package com.ptteng.sca.auto.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.auto.common.model.Version;
import com.ptteng.auto.common.service.VersionService;

import java.util.List;
import java.util.Map;

public class VersionSCAClient implements VersionService {

    private VersionService versionService;

	public VersionService getVersionService() {
		return versionService;
	}
	
	
	public void setVersionService(VersionService versionService) {
		this.versionService =versionService;
	}
	
	
			   
		@Override
		public Long insert(Version version)throws ServiceException, ServiceDaoException{
		
		return versionService.insert(version);
		          
		
		}	
		  
    	   
		@Override
		public List<Version> insertList(List<Version> versionList)throws ServiceException, ServiceDaoException{
		
		return versionService.insertList(versionList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return versionService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Version version)throws ServiceException, ServiceDaoException{
		
		return versionService.update(version);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Version> versionList)throws ServiceException, ServiceDaoException{
		
		return versionService.updateList(versionList);
		          
		
		}	
		  
    	   
		@Override
		public Version getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return versionService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Version> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return versionService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os,String versionCode,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return versionService.getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(os,versionCode,start,limit);
	
	
	}

	@Override
	public List<Long> getVersionIdsByOs(String os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return versionService.getVersionIdsByOs(os, start, limit);
	}

	@Override
	public List<Long> getVersionIdsByOsOrderByVersionCode(String os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return versionService.getVersionIdsByOsOrderByVersionCode(os, start, limit);
	}

	@Override
	public Long getVersionIdByOsAndVersionCode(String os, String code) throws ServiceException, ServiceDaoException {
		return versionService.getVersionIdByOsAndVersionCode(os, code);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os,String versionCode)throws ServiceException, ServiceDaoException{
		
		return versionService.countVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(os,versionCode);
	
	
	}
	
		
	
		@Override
	public List<Long> getVersionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return versionService.getVersionIds(start, limit);
	}

	@Override
	public Integer countVersionIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return versionService.countVersionIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return versionService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return versionService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   versionService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.versionService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

