package com.ptteng.auto.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.auto.common.model.UserMessageRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserMessageRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserMessageRelation userMessageRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserMessageRelation> insertList(List<UserMessageRelation> userMessageRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserMessageRelation userMessageRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserMessageRelation> userMessageRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserMessageRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserMessageRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserMessageRelationIdsByNameAndNick(Long targetId, Long userId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserMessageRelationIdsByNick(Long userId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserMessageRelationIdsByName(Long targetId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserMessageRelationIdsByNameAndNick(Long targetId, Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserMessageRelationIdsByNick(Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserMessageRelationIdsByName(Long targetId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserMessageRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserMessageRelationIds() throws ServiceException, ServiceDaoException;
	

}

