package com.ptteng.auto.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "userMessage")
public class UserMessage implements Serializable {


    private static final long serialVersionUID = 2561911993561284608L;
    /**
     * 用户消息类型
     * 1--后台系统消息
     * 2--个人业务消息
     */
    public static final Integer SYSTEM_TYPE = 1;
    public static final Integer PERSON_TYPE = 2;

    /**
     * 消息已读未读
     */
    public static final Integer UNREAD = 1;
    public static final Integer READ = 2;
    /**
     * 保存状态
     * 1--草稿
     */
    public static final Integer NOSEAND = 0;



    private Long id;


    private Long uid;


    private String title;


    private String summary;


    private Long investId;


    private String img;


    private Integer status;


    private Long messageId;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;



    private Long pushAt;


    private Integer type;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "summary")
    public String getSummary() {
        return summary;
    }


    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Column(name = "invest_id")
    public Long getInvestId() {
        return investId;
    }


    public void setInvestId(Long investId) {
        this.investId = investId;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "message_id")
    public Long getMessageId() {
        return messageId;
    }


    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "push_at")

    public Long getPushAt() {
        return pushAt;
    }

    public void setPushAt(Long pushAt) {
        this.pushAt = pushAt;
    }
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

