package com.ptteng.auto.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "message")
public class Message implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5074540398389866496L;


    /**
     * 发送类型-立即发送
     */
    public static final Integer TYPE_NOW = 1;
    /**
     * 发送类型-定时发送
     */
    public static final Integer TYPE_AFTER = 2;

    /**
     * 保存状态-草稿
     */
    public static final Integer STATUS_DRAFT = 0;
    /**
     * 保存状态-已发送
     */
    public static final Integer STATUS_NOW = 1;
    /**
     * 保存状态-按时发送
     */
    public static final Integer STATUS_AFTER = 2;

    /**
     * 消息栏推送-不
     */
    public static final Integer NOTICE_NO = 0;
    /**
     * 消息栏推送-要
     */
    public static final Integer NOTICE_YES = 1;

    /**
     * 定时推送消息，是否已推送过
     */
    public static final Integer HAVE_NOTICE = 1;//已
    public static final Integer UN_NOTICE = 0;//未


    private Long id;

    /**
     * 标题
     */
	private String title;

    /**
     * 发送人群
     * 1：所有人
     * 2:所有付费用户
     * 3:所有未付费

     */

	private Integer personType;
	public static final int ALL_PERSON = 1;
	public static final int ALL_PAY_PERSON = 2;
	public static final int ALL_FREE_PERSON = 3;
//	public static final int ALL_CERTIFIED_DOCTOR = 4;
//	public static final int ALL_NOT_CERTIFIED_DOCTOR = 5;
	public static final int PERSON = 6;

    /**
     * 正文
     */
	private String content;

    /**
     * img(跳转图片，如果为空，则不跳转)
     */
	private String url;

    /**
     * 发送类型(1立即发送、2定时发送)
     */
	private Integer type;

    /**
     * 发送时间
     */
	private Long pushAt;

    /**
     * 推测是保存为发送或存草稿，0表示草稿，1表示已发送 2表示即将发送
     */
	private Integer status;

    /**
     * 同步？
     */
	private Integer synchronize;

    /**
     * 推测是消息栏推送，0表示不推送，1表示推送
     */
	private Integer noticeStatus;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;

    private Integer read;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "person_type")
    public Integer getPersonType() {
        return personType;
    }

    public void setPersonType(Integer personType) {
        this.personType = personType;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "push_at")
    public Long getPushAt() {
        return pushAt;
    }

    public void setPushAt(Long pushAt) {
        this.pushAt = pushAt;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "synchronize")
    public Integer getSynchronize() {
        return synchronize;
    }

    public void setSynchronize(Integer synchronize) {
        this.synchronize = synchronize;
    }

    @Column(name = "notice_status")
    public Integer getNoticeStatus() {
        return noticeStatus;
    }

    public void setNoticeStatus(Integer noticeStatus) {
        this.noticeStatus = noticeStatus;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Transient
    public Integer getRead() {
        return read;
    }


    public void setRead(Integer read) {
        this.read = read;
    }








    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }


}

